/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.pceftpos;

import ordermate.OrderMate;

public class PCEftposLogonResponse {
    private String responseCode;
    private String responseText;
    private String catId;
    private String caId;
    private String bankDate;
    private String bankTime;
    private String stan;
    private String pinpadVersion;
    private String purchaseAnalysisData;
    private boolean logonSuccess;
    private boolean conversionSuccessful = false;

    public PCEftposLogonResponse(String responseString) {
        if (!PCEftposLogonResponse.isValidLogonResponse(responseString)) {
            return;
        }
        int startPosition = 0;
        if (responseString.contains("#")) {
            startPosition = responseString.indexOf("#") + 1;
        }
        try {
            int index = startPosition + 6;
            this.setLogonSuccess(responseString.substring(index, index + 1).equals("1"));
            this.setResponseCode(responseString.substring(++index, index + 2));
            this.setResponseText(responseString.substring(index += 2, index + 20));
            this.setCatId(responseString.substring(index += 20, index + 8));
            this.setCaId(responseString.substring(index += 8, index + 15));
            this.setBankDate(responseString.substring(index += 15, index + 6));
            this.setBankTime(responseString.substring(index += 6, index + 6));
            this.setStan(responseString.substring(index += 6, index + 6));
            this.setPinpadVersion(responseString.substring(index += 6, index + 16));
            if ((index += 16) + 3 <= responseString.length()) {
                int padLength = Integer.parseInt(responseString.substring(index, index + 3));
                index += 3;
                if (padLength != 0) {
                    this.setPurchaseAnalysisData(responseString.substring(index, index + padLength));
                }
            }
            this.setConversionSuccessful(true);
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Error converting string to logon response", (Throwable)ex);
            this.setConversionSuccessful(false);
        }
    }

    public static boolean isValidLogonResponse(String responseString) {
        if (responseString == null || responseString.length() == 0) {
            return false;
        }
        int startPosition = 0;
        if (responseString.contains("#")) {
            startPosition = responseString.indexOf("#") + 1;
        }
        if (responseString.length() < startPosition + 5) {
            return false;
        }
        return responseString.substring(startPosition + 4, startPosition + 5).equals("G");
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    private void setResponseCode(String ResponseCode) {
        this.responseCode = ResponseCode;
    }

    public String getResponseText() {
        return this.responseText;
    }

    private void setResponseText(String ResponseText) {
        this.responseText = ResponseText;
    }

    public boolean isLogonSuccess() {
        return this.logonSuccess;
    }

    private void setLogonSuccess(boolean LogonSuccess) {
        this.logonSuccess = LogonSuccess;
    }

    public String getBankTime() {
        return this.bankTime;
    }

    public void setBankTime(String BankTime) {
        this.bankTime = BankTime;
    }

    public String getCatId() {
        return this.catId;
    }

    private void setCatId(String CatId) {
        this.catId = CatId;
    }

    public String getCaId() {
        return this.caId;
    }

    private void setCaId(String CaId) {
        this.caId = CaId;
    }

    public String getBankDate() {
        return this.bankDate;
    }

    private void setBankDate(String BankDate) {
        this.bankDate = BankDate;
    }

    public String getStan() {
        return this.stan;
    }

    private void setStan(String Stan) {
        this.stan = Stan;
    }

    public String getPinpadVersion() {
        return this.pinpadVersion;
    }

    private void setPinpadVersion(String PinpadVersion) {
        this.pinpadVersion = PinpadVersion;
    }

    public String getPurchaseAnalysisData() {
        return this.purchaseAnalysisData;
    }

    private void setPurchaseAnalysisData(String PurchaseAnalysisData) {
        this.purchaseAnalysisData = PurchaseAnalysisData;
    }

    public boolean isConversionSuccessful() {
        return this.conversionSuccessful;
    }

    private void setConversionSuccessful(boolean conversionSuccessful) {
        this.conversionSuccessful = conversionSuccessful;
    }
}

