/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.pceftpos;

import ordermate.OrderMate;

public class PCEftposStatusResponse {
    private boolean success;
    private String responseCode;
    private String responseText;
    private String merchant;
    private String AIIC;
    private String NII;
    private String caId;
    private String catId;
    private String Timeout;
    private boolean logonSuccess;
    private String pinpadSerialNumber;
    private String pinpadVersion;
    private String eftposNetwork;
    private boolean conversionSuccessful = false;

    public PCEftposStatusResponse(String responseString) {
        if (!PCEftposStatusResponse.isValidStatusResponse(responseString)) {
            return;
        }
        int startPosition = 0;
        if (responseString.contains("#")) {
            startPosition = responseString.indexOf("#") + 1;
        }
        try {
            int index = startPosition + 6;
            this.setSuccess(responseString.substring(index, index + 1).equals("1"));
            this.setResponseCode(responseString.substring(++index, index + 2));
            this.setResponseText(responseString.substring(index += 2, index + 20));
            this.setMerchant(responseString.substring(index += 20, index + 2));
            this.setAIIC(responseString.substring(index += 2, index + 11));
            this.setNII(responseString.substring(index += 11, index + 3));
            this.setCatId(responseString.substring(index += 3, index + 15));
            this.setCaId(responseString.substring(index += 15, index + 8));
            this.setTimeout(responseString.substring(index += 8, index + 3));
            this.setLogonSuccess(responseString.substring(index += 3, index + 1).equals("1"));
            this.setPinpadSerialNumber(responseString.substring(++index, index + 16));
            this.setPinpadVersion(responseString.substring(index += 16, index + 16));
            this.setEftposNetwork(responseString.substring(index += 16, index + 32));
            index += 32;
            this.setConversionSuccessful(true);
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Error converting string to logon response", (Throwable)ex);
            this.setConversionSuccessful(false);
        }
    }

    public static boolean isValidStatusResponse(String responseString) {
        if (responseString == null || responseString.length() == 0) {
            return false;
        }
        int startPosition = 0;
        if (responseString.contains("#")) {
            startPosition = responseString.indexOf("#") + 1;
        }
        if (responseString.length() < startPosition + 5) {
            return false;
        }
        return responseString.substring(startPosition + 4, startPosition + 5).equals("K");
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public String getMerchant() {
        return this.merchant;
    }

    public String getAIIC() {
        return this.AIIC;
    }

    public String getNII() {
        return this.NII;
    }

    public String getCaId() {
        return this.caId;
    }

    public String getCatId() {
        return this.catId;
    }

    public String getTimeout() {
        return this.Timeout;
    }

    public boolean isLogonSuccess() {
        return this.logonSuccess;
    }

    public String getPinpadSerialNumber() {
        return this.pinpadSerialNumber;
    }

    public String getPinpadVersion() {
        return this.pinpadVersion;
    }

    public String getEftposNetwork() {
        return this.eftposNetwork;
    }

    public boolean isConversionSuccessful() {
        return this.conversionSuccessful;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    public void setMerchant(String merchant) {
        this.merchant = merchant;
    }

    public void setAIIC(String aIIC) {
        this.AIIC = aIIC;
    }

    public void setNII(String nII) {
        this.NII = nII;
    }

    public void setCaId(String caId) {
        this.caId = caId;
    }

    public void setCatId(String catId) {
        this.catId = catId;
    }

    public void setTimeout(String timeout) {
        this.Timeout = timeout;
    }

    public void setLogonSuccess(boolean logonSuccess) {
        this.logonSuccess = logonSuccess;
    }

    public void setPinpadSerialNumber(String pinpadSerialNumber) {
        this.pinpadSerialNumber = pinpadSerialNumber;
    }

    public void setPinpadVersion(String pinpadVersion) {
        this.pinpadVersion = pinpadVersion;
    }

    public void setEftposNetwork(String eftposNetwork) {
        this.eftposNetwork = eftposNetwork;
    }

    public void setConversionSuccessful(boolean conversionSuccessful) {
        this.conversionSuccessful = conversionSuccessful;
    }
}

