/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.report;

import au.com.ordermate.OrderMateLog;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.StoreGroup;
import ordermate.integration.automatedsalesandvariance.ReportHelper;
import ordermate.integration.automatedsalesandvariance.SalesItemReport;
import ordermate.integration.eftpos.report.WriteableReport;

public class EftposDetailedReport
implements WriteableReport {
    private final Date from;
    private final Date to;

    public EftposDetailedReport(Date fromDate, Date toDate) {
        this.from = fromDate;
        this.to = toDate;
    }

    @Override
    public void writeReport(Writer writer) {
        String storeName = StoreGroup.getInstance().getStoreName();
        String storeNumber = StoreGroup.getInstance().getStoreNumber();
        SalesItemReport report = new SalesItemReport(this.from, this.to, storeNumber, storeName);
        List<? extends SalesItemReport> reports = report.generateReport(SalesItemReport.SalesItemReportType.EftposSales);
        try {
            ReportHelper.writeCSVToFile(writer, SalesItemReport.getHeadings(), reports);
        }
        catch (Exception ex) {
            OrderMateLog.LOG.warn("Cannot write eftpos export.", (Throwable)ex);
        }
    }
}

