/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.report;

import au.com.bytecode.opencsv.CSVWriter;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.eftpos.EftposSummary;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.TradingDay;
import ordermate.integration.eftpos.report.WriteableReport;

public class EftposSummaryReport
implements WriteableReport {
    private static final String[] HEADER = new String[]{"Date", "Store ID", "Store", "Type", "Number", "Amount", "Cashout"};
    private static final int DATE_INDEX = 0;
    private static final int ID_INDEX = 1;
    private static final int STORE_INDEX = 2;
    private static final int TYPE_INDEX = 3;
    private static final int NUMBER_INDEX = 4;
    private static final int AMOUNT_INDEX = 5;
    private static final int CASHOUT_INDEX = 6;
    public final DateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
    private List<EftposSummary> summaries;
    private final TradingDay tradingDay;
    private final String storeName;
    private final String storeNumber;

    public EftposSummaryReport(TradingDay day) {
        this.tradingDay = day;
        List<EftposSummary> normalSummaries = this.getNormalSummaries();
        List<EftposSummary> reversedSummaries = this.getReversedSummaries();
        this.summaries = this.aggregateLists(normalSummaries, reversedSummaries);
        this.storeName = StoreGroup.getInstance().getStoreName();
        this.storeNumber = StoreGroup.getInstance().getStoreNumber();
    }

    public EftposSummaryReport(Date day) {
        this(TradingDay.ReportDates.getFirstTradingDayForDate(day));
    }

    private List<EftposSummary> getNormalSummaries() {
        ObjectQuery normalTxnQuery = Query.select(FinanceUnit.Properties.LABEL, "FinanceUnit").count(FinanceTransaction.class, "NumberOfTxns").sum(FinanceTransaction.Properties.PAID, "TotalAmount").sum(FinanceTransaction.Properties.CASH_OUT, "TotalCashouts").linkUsing(FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.Properties.ID).wherePropertyIn(FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.getElectronicUnits()).equals(FinanceTransaction.Properties.TRADING_DAY, this.tradingDay).active(FinanceTransaction.class).groupBy(FinanceUnit.Properties.ID).orderBy(FinanceUnit.Properties.LABEL);
        return PersistenceManager.getObjectList(EftposSummary.class, normalTxnQuery.toString());
    }

    private List<EftposSummary> getReversedSummaries() {
        ObjectQuery reverseTxnQuery = Query.select(FinanceUnit.Properties.LABEL, "FinanceUnit").count(FinanceTransaction.class, "NumberOfTxns").select("0", "TotalAmount").select("0", "TotalCashouts").linkUsing(FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.Properties.ID).wherePropertyIn(FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.getElectronicUnits()).not().active(FinanceTransaction.class).equals(FinanceTransaction.Properties.TRADING_DAY, this.tradingDay).groupBy(FinanceUnit.Properties.ID).orderBy(FinanceUnit.Properties.LABEL);
        return PersistenceManager.getObjectList(EftposSummary.class, reverseTxnQuery.toString());
    }

    private List<EftposSummary> aggregateLists(List<EftposSummary> normalTxns, List<EftposSummary> reversedTxns) {
        for (EftposSummary nextForward : normalTxns) {
            for (EftposSummary nextReversal : reversedTxns) {
                if (!nextForward.getFinanceUnit().equals(nextReversal.getFinanceUnit())) continue;
                nextForward.setNumberOfTransactions(nextForward.getNumberOfTransactions() + nextReversal.getNumberOfTransactions());
            }
        }
        return normalTxns;
    }

    @Override
    public void writeReport(Writer output) {
        CSVWriter writer = new CSVWriter(output, ',', '\u0000', "\r\n");
        String[] toWrite = new String[HEADER.length];
        toWrite[0] = this.dateFormatter.format(this.tradingDay.getDate());
        toWrite[1] = this.storeNumber;
        toWrite[2] = this.storeName;
        writer.writeNext(HEADER);
        for (EftposSummary nextSummary : this.summaries) {
            toWrite[3] = nextSummary.getFinanceUnit();
            toWrite[4] = Integer.toString(nextSummary.getNumberOfTransactions());
            toWrite[5] = nextSummary.getTotalSales().toString(true);
            toWrite[6] = nextSummary.getTotalCashouts().toString(true);
            writer.writeNext(toWrite);
        }
    }
}

