/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.smartpay;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposPrintProcessor;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.misc.BusinessInfo;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.eftpos.smartpay.SmartpayIntegrationProcessor;
import ordermate.integration.eftpos.smartpay.request.SmartpayTransactionRequest;
import ordermate.integration.eftpos.smartpay.request.SmartpayTransactionType;
import ordermate.integration.eftpos.smartpay.response.SmartpayTransactionResponse;
import ordermate.services.hardware.physical.eftpos.EftposPrintProcessorFactory;

public class SmartpayEftpos
implements PhysicalEftpos {
    private VirtualEftpos vEft;
    private EftposPrintProcessor printProcessor;
    private final String EFTPOS_COMPLETED = "COMPLETED";
    private final String EFTPOS_ACCEPTED = "OK-ACCEPTED";
    private static final int POLL_RETRY_WAIT = 2000;

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
        this.vEft = virtualEftpos;
        this.printProcessor = EftposPrintProcessorFactory.createEftposPrintProcessor();
    }

    @Override
    public void closeOff() {
    }

    private Price centsToPrice(int cents) {
        return new Price((double)cents / 100.0, 0.01);
    }

    public EftposResult returnError(EftposRequest request) {
        return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, "Error with response from Smartpay, check connection/logs");
    }

    public void printReceipts(SmartpayTransactionResponse res, EftposRequest request) {
        try {
            if (!StringUtils.isEmpty(res.getData().getReceipt()) && this.vEft.isPrintReceipts()) {
                DocketProcessor.printEftposDocket(res.getData().getReceipt(), Terminal.getLocalHost().getAvailableReceiptPrinters(), request.getTransaction(), false);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem Printing Smartpay Receipt", (Throwable)ex);
        }
    }

    public void setLastTxnRef(String txnRef, String endPoint) {
        this.vEft.setPollingUrl(endPoint);
        this.vEft.setLastTxnReference(txnRef);
        this.vEft.save();
    }

    public EftposResult handleResponse(SmartpayTransactionResponse res, EftposRequest request, boolean isReversal, boolean isCashout) {
        if (this.checkError(res)) {
            if (!StringUtils.isEmpty(res.getError())) {
                OrderMate.LOG.error("Smartpay Error Returned: " + res.getError());
            }
            return this.returnError(request);
        }
        if (!res.getTransactionStatus().equals("COMPLETED")) {
            String endPoint = res.getData().getPollingUrl();
            this.setLastTxnRef(res.getTransactionId(), endPoint);
            while (!res.getTransactionStatus().equals("COMPLETED")) {
                try {
                    Thread.sleep(2000L);
                    res = SmartpayIntegrationProcessor.getInstance().checkTransaction(endPoint);
                    if (!this.checkError(res)) continue;
                    if (!res.getError().isEmpty()) {
                        OrderMate.LOG.error("Smartpay Error Returned: " + res.getError());
                    }
                    this.setLastTxnRef(null, null);
                    return this.returnError(request);
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Error whilst polling for smartpay request", (Throwable)ex);
                    this.setLastTxnRef(null, null);
                    return this.returnError(request);
                }
            }
        }
        this.printReceipts(res, request);
        this.setLastTxnRef(res.getTransactionId(), null);
        if (isReversal) {
            return new EftposResult(request, EftposStatus.APPROVED, this.getFinanceUnit(res), this.centsToPrice(-this.safeParseToInt(res.getData().getAmountTotal())), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, "");
        }
        request.getTransaction().setTransactionReference(res.getTransactionId());
        request.getTransaction().setAuthCode(res.getData().getAuthId());
        if (isCashout) {
            return new EftposResult(request, EftposStatus.APPROVED, this.getFinanceUnit(res), this.centsToPrice(this.safeParseToInt(res.getData().getAmountTotal())), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, this.centsToPrice(this.safeParseToInt(res.getData().getAmountTotal())), null, "");
        }
        return new EftposResult(request, EftposStatus.APPROVED, this.getFinanceUnit(res), this.centsToPrice(this.safeParseToInt(res.getData().getAmountTotal()) - this.safeParseToInt(res.getData().getAmountTip()) - this.safeParseToInt(res.getData().getAmountCash()) - request.getTransaction().getTip().getNumCents()), this.centsToPrice(this.safeParseToInt(res.getData().getAmountTip()) + request.getTransaction().getTip().getNumCents()), this.centsToPrice(this.safeParseToInt(res.getData().getAmountSurcharge())), this.centsToPrice(this.safeParseToInt(res.getData().getAmountCash())), null, "");
    }

    private FinanceUnit getFinanceUnit(SmartpayTransactionResponse res) {
        if (!res.getData().getAccountType().equals("CREDIT")) {
            return FinanceUnit.getDefaultUnitFor(FinanceUnit.DEBIT_TYPE);
        }
        return FinanceUnit.getUnitForName(res.getData().getCardType());
    }

    private int safeParseToInt(String amount) {
        if (amount == null) {
            return 0;
        }
        return Integer.parseInt(amount);
    }

    public EftposResult doPurchase(SmartpayTransactionRequest r, EftposRequest request) {
        SmartpayTransactionResponse res = SmartpayIntegrationProcessor.getInstance().doTransaction(r, SmartpayTransactionType.PURCHASE, this.vEft.getIpAddress());
        return this.handleResponse(res, request, false, false);
    }

    boolean checkError(SmartpayTransactionResponse res) {
        return res == null || res.getError() != null || res.getTransactionStatus().equals("COMPLETED") && !res.getData().getTransactionResult().equals("OK-ACCEPTED");
    }

    public EftposResult doRefund(SmartpayTransactionRequest r, EftposRequest request) {
        r.setAmountTotal(Math.abs(r.getAmountTotal()));
        SmartpayTransactionResponse res = SmartpayIntegrationProcessor.getInstance().doTransaction(r, SmartpayTransactionType.REFUND, this.vEft.getIpAddress());
        return this.handleResponse(res, request, true, false);
    }

    public EftposResult doPurchaseCash(SmartpayTransactionRequest r, EftposRequest request) {
        SmartpayTransactionResponse res = SmartpayIntegrationProcessor.getInstance().doTransaction(r, SmartpayTransactionType.PURCHASE_CASH, this.vEft.getIpAddress());
        return this.handleResponse(res, request, false, false);
    }

    public EftposResult doCashout(SmartpayTransactionRequest r, EftposRequest request) {
        SmartpayTransactionResponse res = SmartpayIntegrationProcessor.getInstance().doTransaction(r, SmartpayTransactionType.CASH_OUT, this.vEft.getIpAddress());
        return this.handleResponse(res, request, false, true);
    }

    @Override
    public EftposResult performTransaction(EftposRequest request) {
        SmartpayTransactionRequest r = this.buildBaseRequest(request.getTerminalToUse().getName(), true);
        r.setAmountTotal(request.getTransaction().getPaid().getNumCents() + request.getTransaction().getCashOut().getNumCents() + request.getTransaction().getTip().getNumCents());
        r.setAmountCash(request.getTransaction().getCashOut().getNumCents());
        if (r.getAmountTotal() < 0 || request.isReversal()) {
            return this.doRefund(r, request);
        }
        if (r.getAmountCash() > 0) {
            if (r.getAmountTotal() == r.getAmountCash()) {
                r.setAmountCash(0);
                return this.doCashout(r, request);
            }
            return this.doPurchaseCash(r, request);
        }
        return this.doPurchase(r, request);
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        return null;
    }

    @Override
    public boolean supportsNonBlocking() {
        return false;
    }

    @Override
    public String getTerminalIDIfReady() {
        return this.vEft.getTerminalId();
    }

    SmartpayTransactionRequest buildBaseRequest(String terminalName, boolean asyncMode) {
        SmartpayTransactionRequest r = new SmartpayTransactionRequest();
        r.setPOSBusinessName(BusinessInfo.getInstance().getName());
        r.setPOSRegisterName(terminalName);
        r.setPOSVendorName("OrderMate");
        r.setPOSRegisterID(this.vEft.getMerchantId());
        if (asyncMode) {
            r.setTransactionMode("ASYNC");
        }
        return r;
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        return true;
    }

    @Override
    public boolean supportsBlocking() {
        return false;
    }

    @Override
    public boolean supportsTipping() {
        return false;
    }

    @Override
    public void printInterruptedTransaction(String txnReference) {
        SmartpayTransactionResponse res;
        if (this.vEft.getLastTxnReference() != null && this.vEft.getPollingUrl() != null && !this.checkError(res = SmartpayIntegrationProcessor.getInstance().checkTransaction(this.vEft.getPollingUrl())) && res.getData().getReceipt() != null && !res.getData().getReceipt().isEmpty()) {
            this.printProcessor.printEftposDocket(res.getData().getReceipt(), null, false);
        }
        this.setLastTxnRef(null, null);
    }

    @Override
    public String clearInterruptedTransactions() {
        return null;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    @Override
    public boolean supportsPreAuth() {
        return false;
    }

    @Override
    public List<String> supportedPreAuth() {
        return null;
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
    }

    @Override
    public boolean supportsMOTO() {
        return false;
    }
}

