/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.smartpay;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import ordermate.OrderMate;
import ordermate.integration.eftpos.smartpay.request.SmartpayRequest;
import ordermate.integration.eftpos.smartpay.request.SmartpayTransactionRequest;
import ordermate.integration.eftpos.smartpay.request.SmartpayTransactionType;
import ordermate.integration.eftpos.smartpay.response.SmartpayPairResponse;
import ordermate.integration.eftpos.smartpay.response.SmartpayTransactionResponse;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;

public class SmartpayIntegrationProcessor {
    private static final Integer TIMEOUT = 20000;
    private static final String URL_ENDPOINT = "https://api.smart-connect.cloud/POS";
    private static SmartpayIntegrationProcessor instance;
    private static final boolean DEV_MODE_REQUIRES_KEY = false;

    public static boolean getDevModeOn() {
        return false;
    }

    public static SmartpayIntegrationProcessor getInstance() {
        if (instance == null) {
            instance = new SmartpayIntegrationProcessor();
        }
        return instance;
    }

    public static void setInstance(SmartpayIntegrationProcessor instance) {
        SmartpayIntegrationProcessor.instance = instance;
    }

    private static WebResource.Builder createBuilder(String uri, int ContentLength) {
        RestHelper rest = new RestHelper();
        WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        return (WebResource.Builder)resource.header("Content-Length", (Object)ContentLength).header("Content-Type", (Object)"application/x-www-form-urlencoded");
    }

    public SmartpayPairResponse doPair(SmartpayRequest r, String pairCode) {
        return this.doPair(r, pairCode, URL_ENDPOINT);
    }

    public SmartpayPairResponse doPair(SmartpayRequest r, String pairCode, String endpoint) {
        String uri = endpoint + "/Pairing/" + pairCode;
        try {
            WebResource.Builder builder = SmartpayIntegrationProcessor.createBuilder(uri, r.toString().length());
            MultivaluedMapImpl values = new MultivaluedMapImpl();
            values.add("POSRegisterID", r.getPOSRegisterID());
            values.add("POSRegisterName", r.getPOSRegisterName());
            values.add("POSBusinessName", r.getPOSBusinessName());
            values.add("POSVendorName", r.getPOSVendorName());
            ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, (Object)values);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Smartpay, error was " + response.getStatus());
            }
            String responseJSON = (String)response.getEntity(String.class);
            OrderMate.LOG.error("Smartpay Response: " + responseJSON);
            ObjectMapper mapper = new ObjectMapper();
            return (SmartpayPairResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SmartpayPairResponse>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Pair Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public SmartpayTransactionResponse doTransaction(SmartpayTransactionRequest r, SmartpayTransactionType t) {
        return this.doTransaction(r, t, URL_ENDPOINT);
    }

    public SmartpayTransactionResponse doTransaction(SmartpayTransactionRequest r, SmartpayTransactionType t, String endpoint) {
        String uri = endpoint + "/Transaction";
        try {
            ClientResponse response;
            WebResource.Builder builder = SmartpayIntegrationProcessor.createBuilder(uri, r.toString().length());
            MultivaluedMapImpl values = new MultivaluedMapImpl();
            values.add("POSRegisterID", r.getPOSRegisterID());
            values.add("POSRegisterName", r.getPOSRegisterName());
            values.add("POSBusinessName", r.getPOSBusinessName());
            values.add("POSVendorName", r.getPOSVendorName());
            values.add("TransactionType", t.toString());
            values.add("AmountTotal", (Object)r.getAmountTotal());
            values.add("AmountCash", (Object)r.getAmountCash());
            if (r.getTransactionMode() != null) {
                values.add("TransactionMode", r.getTransactionMode());
            }
            if ((response = (ClientResponse)builder.post(ClientResponse.class, (Object)values)).getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Smartpay, error was " + response.getStatus());
            }
            String responseJSON = (String)response.getEntity(String.class);
            OrderMate.LOG.error("Smartpay Response: " + responseJSON);
            ObjectMapper mapper = new ObjectMapper();
            return (SmartpayTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SmartpayTransactionResponse>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Transaction Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public SmartpayTransactionResponse checkTransaction(String endpoint) {
        try {
            WebResource.Builder builder = SmartpayIntegrationProcessor.createBuilder(endpoint, 0);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Smartpay, error was " + response.getStatus());
            }
            String responseJSON = (String)response.getEntity(String.class);
            OrderMate.LOG.error("Smartpay Response: " + responseJSON);
            ObjectMapper mapper = new ObjectMapper();
            return (SmartpayTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SmartpayTransactionResponse>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Check Transaction Request Failed: ", (Throwable)ex);
            return null;
        }
    }
}

