/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.smartpay.pairing;

import au.com.ordermate.gui.GuiHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.misc.BusinessInfo;
import ordermate.gui.FieldPanelBuilder;
import ordermate.integration.eftpos.smartpay.SmartpayIntegrationProcessor;
import ordermate.integration.eftpos.smartpay.request.SmartpayRequest;
import ordermate.integration.eftpos.smartpay.response.SmartpayPairResponse;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class SmartpayPairingPanel
extends JPanel
implements ActionListener {
    private JTextField pairCodeField;
    private final VirtualEftpos eftpos;
    private JButton pairButton;
    private Terminal terminal;
    private GuiHandler ui;
    Signal cancelSignal = Signals.createSignal();

    SmartpayPairingPanel(VirtualEftpos context, Terminal t, GuiHandler ui) {
        this.ui = ui;
        this.setupComponents();
        this.eftpos = context;
        this.terminal = t;
    }

    private void setupComponents() {
        this.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.pairCodeField = new JTextField(10);
        this.pairCodeField.setName("");
        this.pairCodeField.setEditable(true);
        builder.addRow("Pairing Code", (Component)this.pairCodeField);
        this.pairButton = new JButton("Perform Pair");
        this.pairButton.setVisible(true);
        this.pairButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.pairButton);
        buttonPanel.setAlignmentX(1.0f);
        builder.addRow(buttonPanel);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.pairButton) {
            SmartpayRequest pReq = new SmartpayRequest();
            pReq.setPOSBusinessName(BusinessInfo.getInstance().getName());
            pReq.setPOSRegisterName(this.terminal.getName());
            pReq.setPOSVendorName("OrderMate");
            pReq.setPOSRegisterID(this.eftpos.getMerchantId());
            SmartpayPairResponse res = SmartpayIntegrationProcessor.getInstance().doPair(pReq, this.pairCodeField.getText(), this.eftpos.getIpAddress());
            if (res.getError() != null || res == null) {
                this.ui.displayErrorDialog("Pairing Failed", res != null ? res.getError() : "Unknown Error, Check Logs", null);
            } else {
                this.ui.displayOkDialog("Pairing Successful", "EFTPOS Paired");
            }
            JComponent comp = (JComponent)event.getSource();
            Window win = SwingUtilities.getWindowAncestor(comp);
            win.dispose();
        }
    }
}

