/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro;

import java.io.File;

public class FileWaiter {
    private String nameToWaitFor;
    private File dir;
    private int nTrials;
    private MatchType matchType;
    private static final int CHECK_TIME_OUT = 100;
    private boolean isThere = true;

    public FileWaiter(String waitForThis, File directory, int timeoutInMillis) {
        this.nameToWaitFor = waitForThis;
        this.matchType = this.determineMatchType();
        this.dir = directory;
        this.nTrials = timeoutInMillis <= 0 ? -1 : timeoutInMillis / 100 + 1;
    }

    public void setWaitUntilNotThere() {
        this.isThere = false;
    }

    private MatchType determineMatchType() {
        if (this.nameToWaitFor.startsWith("*") && this.nameToWaitFor.endsWith("*")) {
            this.nameToWaitFor = this.nameToWaitFor.substring(1, this.nameToWaitFor.length() - 2);
            return MatchType.CONTAINS;
        }
        if (this.nameToWaitFor.startsWith("*")) {
            this.nameToWaitFor = this.nameToWaitFor.substring(1);
            return MatchType.ENDS_WITH;
        }
        if (this.nameToWaitFor.endsWith("*")) {
            this.nameToWaitFor = this.nameToWaitFor.substring(0, this.nameToWaitFor.length() - 2);
            return MatchType.STARTS_WITH;
        }
        return MatchType.EXACT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitOnIt() {
        while (this.nTrials > 0) {
            boolean found = this.doesExist(this.dir.listFiles());
            if (!(found ^ this.isThere)) {
                return true;
            }
            try {
                FileWaiter fileWaiter = this;
                synchronized (fileWaiter) {
                    if (this.nTrials > 0) {
                        --this.nTrials;
                    }
                }
                fileWaiter = this;
                synchronized (fileWaiter) {
                    this.wait(100L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return false;
    }

    private boolean doesExist(File[] files) {
        boolean found = false;
        for (File file : files) {
            String filename = file.getName();
            found = this.matchType.equals((Object)MatchType.CONTAINS) ? filename.contains(this.nameToWaitFor) : (this.matchType.equals((Object)MatchType.STARTS_WITH) ? filename.startsWith(this.nameToWaitFor) : (this.matchType.equals((Object)MatchType.ENDS_WITH) ? filename.endsWith(this.nameToWaitFor) : filename.equals(this.nameToWaitFor)));
            boolean bl = found = found && file.canRead() && file.canWrite();
            if (found) break;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        FileWaiter fileWaiter = this;
        synchronized (fileWaiter) {
            this.nTrials = 0;
            this.notifyAll();
        }
    }

    private static enum MatchType {
        EXACT,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS;

    }
}

