/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.Price;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposPrintProcessor;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.eftpos.tyro.FileWaiter;
import ordermate.integration.eftpos.tyro.TyroHelper;
import ordermate.services.hardware.physical.eftpos.EftposPrintProcessorFactory;

public class TyroEftpos
implements PhysicalEftpos {
    private static final int NUM_TRIALS_TO_READ = 20;
    private static final int REQUEST_TIMEOUT = 5000;
    private static AtomicLong fileId = new AtomicLong(1L);
    static final String REQUEST_SUFFIX = ".request";
    static final String IN_PROGRESS_SUFFIX = ".inprogress";
    static final String EVENT_SUFFIX = ".event";
    static final String COMPLETE_SUFFIX = ".complete";
    static final int TIME_PER_TRIAL = 1000;
    private String directory;
    private String currentName;
    private File dir;
    private int timeout;
    private List<String> readFiles = new ArrayList<String>();
    private final EftposPrintProcessor printProcessor;
    FilenameFilter tyroFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File fileDirectory, String name) {
            return name.endsWith(TyroEftpos.REQUEST_SUFFIX) || name.endsWith(TyroEftpos.IN_PROGRESS_SUFFIX) || name.contains(TyroEftpos.EVENT_SUFFIX) || name.endsWith(TyroEftpos.COMPLETE_SUFFIX);
        }
    };

    public TyroEftpos() {
        this.printProcessor = EftposPrintProcessorFactory.createEftposPrintProcessor();
    }

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
        this.directory = virtualEftpos.getFileSwapDirectory();
        this.timeout = virtualEftpos.getTimeoutMillis();
        this.dir = new File(this.directory);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        this.cleanUpFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRequest(String request) {
        if (request == null || request.length() == 0) {
            return false;
        }
        boolean success = false;
        this.currentName = Long.toString(fileId.incrementAndGet());
        StringBuilder SB = new StringBuilder(this.directory);
        SB.append(this.currentName);
        SB.append(REQUEST_SUFFIX);
        File requestFile = new File(SB.toString());
        FileLock lock = null;
        PrintWriter writer = null;
        try {
            FileOutputStream fout = new FileOutputStream(requestFile);
            lock = fout.getChannel().lock();
            writer = new PrintWriter(fout);
            writer.write(request);
            writer.flush();
            success = true;
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Couldn't write Tyro Eftpos request file.", (Throwable)ex);
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException ex) {
                    OrderMateLog.LOG.warn("Unable to release a file lock on Tyro request file", (Throwable)ex);
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
        FileWaiter waiter = new FileWaiter(requestFile.getName(), requestFile.getParentFile(), 5000);
        waiter.setWaitUntilNotThere();
        if (!waiter.waitOnIt()) {
            OrderMate.LOG.warn("No response from Tyro after five seconds, deleting request file: " + requestFile);
            if (!requestFile.delete()) {
                OrderMate.LOG.warn("Couldn't delete the Tyro .request file!");
            }
            success = false;
        }
        return success;
    }

    private List<String> readEventResponses() {
        FileWaiter waiter = new FileWaiter("*.event", this.dir, 1000);
        if (!waiter.waitOnIt()) {
            return null;
        }
        File[] files = this.dir.listFiles();
        ArrayList<String> data = new ArrayList<String>();
        for (File file : files) {
            int attempts;
            FileWaiter specificWaiter;
            if (!file.getName().startsWith(this.currentName) || !file.getName().endsWith(EVENT_SUFFIX) || this.readFiles.contains(file.getName()) || !(specificWaiter = new FileWaiter(file.getName(), this.dir, 1000)).waitOnIt()) continue;
            String fileString = null;
            for (attempts = 0; fileString == null && attempts < 20; ++attempts) {
                fileString = this.readInFile(file);
            }
            if (fileString == null) continue;
            data.add(fileString);
            this.readFiles.add(file.getName());
            attempts = 0;
            while (file.exists() && attempts < 20) {
                if (!file.delete()) {
                    OrderMateLog.LOG.warn("Unable to delete Tyro event file :" + file);
                    ++attempts;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    OrderMateLog.LOG.info("Deleted Tyro event file :" + file);
                }
                if (attempts != 20) continue;
                OrderMateLog.LOG.warn("Couldn't delete Tyro event file after " + attempts + " attempts.");
            }
        }
        if (data.size() == 0) {
            data = null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInFile(File file) {
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        BufferedReader in = null;
        StringBuilder buffer = null;
        FileLock lock = null;
        try {
            RandomAccessFile raFile = new RandomAccessFile(file, "rws");
            lock = raFile.getChannel().lock();
            raFile.close();
            FileInputStream fin = new FileInputStream(file);
            fin.getFD().sync();
            in = new BufferedReader(new InputStreamReader(fin));
            buffer = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                buffer.append(line);
                line = in.readLine();
                if (line == null) continue;
                buffer.append("\n");
            }
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Couldn't read in response file" + file, (Throwable)ex);
            buffer = null;
        }
        finally {
            try {
                try {
                    if (lock != null && lock.isValid()) {
                        lock.release();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("Couldn't close off response file" + file, (Throwable)ex);
            }
        }
        return buffer != null && buffer.length() > 0 ? buffer.toString() : null;
    }

    @Override
    public EftposResult performTransaction(EftposRequest request) {
        this.cleanUpFiles();
        if (request.isTippingAdjustment() || !this.sendRequest(TyroHelper.createTransactionRequest(request))) {
            request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.FAILED);
            return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null);
        }
        TxnState txnState = TxnState.Waiting;
        ArrayList<String> allResponses = new ArrayList<String>();
        int maxTrials = this.timeout / 1000;
        int trials = 0;
        while (txnState.equals((Object)TxnState.Waiting)) {
            if (this.isCompletedFilePresent()) {
                txnState = TxnState.Completed;
            }
            List<String> responses = this.readEventResponses();
            if (!txnState.equals((Object)TxnState.Completed) && ++trials > maxTrials) {
                OrderMateLog.LOG.warn("Tyro Transaction timed out for cashdrawer:" + request.getTransaction().getCashDrawer().getLabel());
                txnState = TxnState.TimedOut;
            }
            if (responses == null) continue;
            allResponses.addAll(responses);
            OrderMateLog.LOG.info("Received response files:" + responses.size());
            trials = 0;
            for (String nextResponse : responses) {
                this.printReceipts(nextResponse, request, TyroHelper.isTransactionCompleted(nextResponse));
            }
        }
        String completedResponse = null;
        for (String nextResponse : allResponses) {
            if (!TyroHelper.isTransactionCompleted(nextResponse)) continue;
            completedResponse = nextResponse;
        }
        if (txnState.equals((Object)TxnState.Completed)) {
            trials = 0;
            if (completedResponse == null) {
                OrderMateLog.LOG.info("Didn't get completed file, looking for it now.");
            } else {
                OrderMateLog.LOG.info("Found completed response:" + completedResponse);
            }
            while (completedResponse == null && trials <= maxTrials) {
                List<String> responses = this.readEventResponses();
                if (responses != null) {
                    OrderMateLog.LOG.info("Received response files:" + responses.size());
                    trials = 0;
                    for (String nextResponse : responses) {
                        boolean isCompletedFile = TyroHelper.isTransactionCompleted(nextResponse);
                        this.printReceipts(nextResponse, request, isCompletedFile);
                        if (!isCompletedFile) continue;
                        completedResponse = nextResponse;
                    }
                }
                if (++trials <= maxTrials) continue;
                OrderMateLog.LOG.info("Tyro Transaction timed out for cashdrawer while waiting for completed response:" + request.getTransaction().getCashDrawer().getLabel());
                txnState = TxnState.TimedOut;
            }
        }
        if (completedResponse != null) {
            OrderMateLog.LOG.info("Received Transaction completed from Tyro Eftpos.");
        } else {
            OrderMateLog.LOG.warn("Tyro Transaction not processed. TxnState:" + (Object)((Object)txnState));
        }
        return TyroHelper.getEftposResult(request, completedResponse);
    }

    private boolean isCompletedFilePresent() {
        String toWaitOn = this.currentName != null ? this.currentName + COMPLETE_SUFFIX : "*.complete";
        return new FileWaiter(toWaitOn, this.dir, 100).waitOnIt();
    }

    private void printReceipts(String response, EftposRequest request, boolean asCustomer) {
        List<String> dockets = TyroHelper.extractDocketsFromResponse(response);
        OrderMateLog.LOG.info("Printing Tyro receipts:" + dockets.size());
        for (String nextDocket : dockets) {
            if (nextDocket.length() <= 0) continue;
            if (!asCustomer) {
                this.printProcessor.printEftposDocket(TyroHelper.appendMerchant(nextDocket), request, asCustomer);
                continue;
            }
            this.printProcessor.printEftposDocket(TyroHelper.makeCustomer(nextDocket), request, asCustomer);
        }
    }

    @Override
    public boolean supportsNonBlocking() {
        return true;
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        return true;
    }

    @Override
    public String getTerminalIDIfReady() {
        File[] files = this.dir.listFiles(this.tyroFileFilter);
        if (files.length == 0) {
            return "";
        }
        return null;
    }

    @Override
    public void closeOff() {
        this.currentName = null;
        this.readFiles.clear();
        this.cleanUpFiles();
    }

    @Override
    public boolean supportsBlocking() {
        return true;
    }

    private void cleanUpFiles() {
        File[] files;
        for (File file : files = this.dir.listFiles(this.tyroFileFilter)) {
            FileWaiter waiter = new FileWaiter(file.getName(), file.getParentFile(), 1000);
            if (!waiter.waitOnIt() || file.delete()) continue;
            OrderMateLog.LOG.warn("Couldn't delete tyro file in clean up:" + file);
        }
    }

    @Override
    public void printInterruptedTransaction(String lastTxn) {
        if (this.isCompletedFilePresent()) {
            File[] files;
            for (File file : files = this.dir.listFiles(this.tyroFileFilter)) {
                String txnReference;
                String content;
                if (!file.getName().endsWith(EVENT_SUFFIX) || !TyroHelper.isTransactionCompleted(content = this.readInFile(file)) || String.valueOf(txnReference = TyroHelper.getTransactionReference(content)).equals(lastTxn)) continue;
                OrderMateLog.LOG.info("Printing lingering Tyro Eftpos file.");
                this.printReceipts(content, null, true);
            }
        }
    }

    @Override
    public String clearInterruptedTransactions() {
        String txnReference = null;
        if (this.isCompletedFilePresent()) {
            File[] files;
            for (File file : files = this.dir.listFiles(this.tyroFileFilter)) {
                String content;
                if (!file.getName().endsWith(EVENT_SUFFIX) || !TyroHelper.isTransactionCompleted(content = this.readInFile(file))) continue;
                txnReference = TyroHelper.getTransactionReference(content);
            }
        }
        this.cleanUpFiles();
        return txnReference;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    public String getCurrentFileName() {
        return this.currentName;
    }

    @Override
    public boolean supportsTipping() {
        return false;
    }

    @Override
    public boolean supportsPreAuth() {
        return false;
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        return null;
    }

    @Override
    public List<String> supportedPreAuth() {
        return null;
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
    }

    @Override
    public boolean supportsMOTO() {
        return false;
    }

    private static enum TxnState {
        Waiting,
        TimedOut,
        Completed;

    }
}

