/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.EftposResult;

public class TyroHelper {
    private static final String MERCHANT_TEXT = "\nMERCHANT COPY";
    private static final String CUSTOMER_TEXT = "\nCUSTOMER COPY";
    private static final String SIGNATURE_BLOCK = "Customer's Signature\n\n\n\n-----\n\n";
    static final String REQUEST_HEADER = "[Request]";
    static final String REQUEST_PURCHASE = "\nRequestType=Purchase";
    static final String REQUEST_REFUND = "\nRequestType=Refund";
    static final String PURCHASE_AMOUNT = "\nAmountPurchase=";
    static final String CASHOUT_AMOUNT = "\nAmountCashout=";
    static final String REFUND_AMOUNT = "\nAmountRefund=";
    static final String EVENT_HEADER = "[Event]";
    static final String EVENT_INDEX = "EventIndex=";
    static final String EVENT_TXN_COMPLETE = "EventType=TransactionCompleted";
    static final String RESULT_HEADER = "[Result]";
    static final String RESULT_OUTCOME = "Result=";
    static final String RESULT_CARDTYPE = "CardType=";
    static final String RESULT_REVERSED = "REVERSED";
    static final String RESULT_APPROVED = "APPROVED";
    static final String RESULT_DECLINED = "DECLINED";
    static final String RESULT_CANCELLED = "CANCELLED";
    static final String RESULT_ERROR = "SYSTEM_ERROR";
    static final String RECEIPT_HEADER = "[Receipt";
    static final String NUMBER_OF_RECEIPTS = "NumberOfReceipts=";
    static final String RECEIPT_SIG_REQUIRE = "SignatureRequired=";
    static final String RECEIPT_LINE = "Line-";
    static final String RESULT_TXN_REF = "TransactionReference=";
    static final String RESULT_AUTH_CODE = "AuthorisationCode=";
    static final String TERMINAL_ID = "Terminal ID:";
    static final String ERROR_HEADER = "[Error]";
    static final String ERROR_MESSAGE = "ErrorMessage=";
    static final String ERROR_TXN_STARTED = "IsTransactionStarted=";
    public static final String EFTPOS_CHEQUE = "EFTPOS Cheque";
    public static final String EFTPOS_SAVINGS = "EFTPOS";
    public static final String VISA = "Visa";
    public static final String MASTER_CARD = "MasterCard";
    public static final String AMEX = "American Express";
    public static final String DINERS = "Diners Club";
    public static final String BANK_CARD = "BankCard";
    public static final String JCB = "JCB";
    public static final String ALIPAY = "Alipay";

    static final String createTransactionRequest(EftposRequest request) {
        StringBuilder SB = new StringBuilder(REQUEST_HEADER);
        if (request.getTransaction().getPaid().lessThan(Price.ZERO_DOLLAR) ^ request.isReversal()) {
            SB.append(REQUEST_REFUND);
            SB.append(REFUND_AMOUNT);
            SB.append(TyroHelper.priceToString(request.getTransaction().getPaid().abs()));
        } else {
            SB.append(REQUEST_PURCHASE);
            SB.append(PURCHASE_AMOUNT);
            Price purchase = request.getTransaction().getPaid();
            if (request.getTransaction().getTip() != null) {
                purchase = purchase.add(request.getTransaction().getTip());
            }
            SB.append(TyroHelper.priceToString(purchase.abs()));
        }
        if (request.getTransaction().getCashOut() != null && !request.getTransaction().getCashOut().isZero() && !request.isReversal()) {
            SB.append(CASHOUT_AMOUNT);
            SB.append(TyroHelper.priceToString(request.getTransaction().getCashOut().abs()));
        }
        SB.append("\n");
        return SB.toString();
    }

    static EftposResult getEftposResult(EftposRequest request, String readResponse) {
        if (readResponse == null || !readResponse.contains(EVENT_TXN_COMPLETE)) {
            request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.FAILED);
            return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null);
        }
        request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.PROCESSED);
        String[] lines = readResponse.split("\n");
        EftposStatus eftposStatus = null;
        String txnReference = null;
        FinanceUnit cardType = null;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith(RESULT_OUTCOME)) {
                eftposStatus = TyroHelper.interpretEftposStatus(lines[i]);
                continue;
            }
            if (lines[i].startsWith(RESULT_TXN_REF)) {
                txnReference = lines[i].substring(RESULT_TXN_REF.length());
                continue;
            }
            if (!lines[i].startsWith(RESULT_CARDTYPE)) continue;
            cardType = TyroHelper.interpretCardType(lines[i]);
        }
        EftposTransaction txn = request.getTransaction();
        txn.setTransactionReference(txnReference);
        String termID = null;
        Price actuallySurcharged = txn.getSurcharge();
        Price actuallyPaid = txn.getPaid().subtract(actuallySurcharged);
        Price actuallyTipped = txn.getTip();
        Price actuallyCashedOut = txn.getCashOut();
        if (request.isReversal()) {
            actuallyPaid = actuallyPaid.negate();
            actuallyTipped = actuallyTipped.negate();
            actuallySurcharged = actuallySurcharged.negate();
        }
        EftposResult result = new EftposResult(request, eftposStatus, cardType, actuallyPaid, actuallyTipped, actuallySurcharged, actuallyCashedOut, termID);
        return result;
    }

    static boolean isTransactionCompleted(String response) {
        return response.contains(EVENT_HEADER) && (response.contains(RESULT_HEADER) || response.contains(ERROR_HEADER));
    }

    private static EftposStatus interpretEftposStatus(String line) {
        String result = line.substring(RESULT_OUTCOME.length());
        EftposStatus status = null;
        status = result.equals(RESULT_APPROVED) ? EftposStatus.APPROVED : (result.equals(RESULT_DECLINED) ? EftposStatus.DECLINED : (result.equals(RESULT_CANCELLED) ? EftposStatus.CANCELLED : EftposStatus.ERROR));
        return status;
    }

    private static final FinanceUnit interpretCardType(String line) {
        String cardType = line.substring(RESULT_CARDTYPE.length()).trim();
        return TyroHelper.getFinanceUnitFor(cardType);
    }

    public static FinanceUnit getFinanceUnitFor(String cardType) {
        String name = cardType;
        if (EFTPOS_CHEQUE.equalsIgnoreCase(cardType)) {
            name = "Cheque Acc";
        } else if (EFTPOS_SAVINGS.equalsIgnoreCase(cardType)) {
            name = "Savings Acc";
        } else if (VISA.equalsIgnoreCase(cardType)) {
            name = VISA;
        } else if (MASTER_CARD.equalsIgnoreCase(cardType)) {
            name = "Mastercard";
        } else if (AMEX.equalsIgnoreCase(cardType)) {
            name = "Amex";
        } else if (DINERS.equalsIgnoreCase(cardType)) {
            name = "Diners";
        } else if (BANK_CARD.equalsIgnoreCase(cardType)) {
            name = "Bankcard";
        } else if (JCB.equalsIgnoreCase(cardType)) {
            name = JCB;
        } else if (ALIPAY.equalsIgnoreCase(cardType)) {
            name = "ALIPAY";
        }
        return FinanceUnit.getUnitForName(name);
    }

    static String priceToString(Price value) {
        if (value == null) {
            return "0";
        }
        return Integer.toString(Math.abs(value.getNumCents()));
    }

    static List<String> extractDocketsFromResponse(String response) {
        String[] lines = response.split("\\n");
        StringBuilder docket = new StringBuilder();
        ArrayList<String> dockets = new ArrayList<String>();
        boolean signatureRequired = false;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith(RECEIPT_HEADER)) {
                if (docket != null) {
                    TyroHelper.modifyDocket(docket, signatureRequired);
                    dockets.add(docket.toString());
                }
                docket = new StringBuilder();
                signatureRequired = false;
                continue;
            }
            if (lines[i].startsWith(RECEIPT_SIG_REQUIRE)) {
                signatureRequired = lines[i].endsWith("true");
                continue;
            }
            if (lines[i].startsWith(RECEIPT_LINE)) {
                if (docket == null) continue;
                docket.append(lines[i].substring(lines[i].indexOf(61) + 1));
                docket.append("\n");
                continue;
            }
            if (docket == null) continue;
            TyroHelper.modifyDocket(docket, signatureRequired);
            dockets.add(docket.toString());
            docket = null;
        }
        if (docket != null) {
            TyroHelper.modifyDocket(docket, signatureRequired);
            dockets.add(docket.toString());
        }
        return dockets;
    }

    public static final void modifyDocket(StringBuilder docket, boolean isSignatureRequired) {
        if (isSignatureRequired) {
            docket.append(SIGNATURE_BLOCK);
        }
    }

    static boolean isCustomerCopy(String nextDocket) {
        return !nextDocket.contains(SIGNATURE_BLOCK);
    }

    static String getTransactionReference(String content) {
        int indexStart = content.indexOf(RESULT_TXN_REF);
        if (indexStart > 0) {
            int indexEnd = content.indexOf("\n", indexStart);
            return content.substring(indexStart + RESULT_TXN_REF.length(), indexEnd);
        }
        return null;
    }

    public static String appendMerchant(String nextDocket) {
        return nextDocket + MERCHANT_TEXT;
    }

    public static String makeCustomer(String nextDocket) {
        String toReturn = nextDocket;
        if (nextDocket.contains(SIGNATURE_BLOCK)) {
            toReturn = toReturn.replace(SIGNATURE_BLOCK, "\n");
        }
        toReturn = toReturn + CUSTOMER_TEXT;
        return toReturn;
    }
}

