/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice;

public enum RestErrorCode {
    R200(200, "OK"),
    R202(202, "Accepted"),
    R333(333, "OK Already Settled"),
    R400(400, "Bad Request"),
    R403(403, "Forbidden"),
    R404(404, "Not Found"),
    R409(409, "Conflict"),
    R410(410, "Gone"),
    R500(500, "Internal Server Error"),
    R501(501, "Not Implemented"),
    R503(503, "Service Unavailable"),
    R504(504, "Gateway Timeout");

    private final int code;
    private final String desc;

    public static RestErrorCode getCode(int code) {
        for (RestErrorCode nextCode : RestErrorCode.values()) {
            if (nextCode.getCode() != code) continue;
            return nextCode;
        }
        return R404;
    }

    private RestErrorCode(int theCode, String description) {
        this.code = theCode;
        this.desc = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.desc;
    }
}

