/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.PreauthType;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.eftpos.tyro.webservice.TyroTerminalStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebPreauthAllocation;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebPreauthConsume;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebPreauthVoid;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebPurchase;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebTerminalStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebTipAdjust;

public class TyroWebEftpos
implements PhysicalEftpos {
    private String server;
    private String mid;
    private String tid;
    private Integer timeout;
    private boolean printReceipts;
    private Map<Long, String> keyMap;
    private EftposToolkit toolkit;
    private final String CLOSE = "Settle";
    private final String VOID = "Void";

    public TyroWebEftpos(EftposToolkit theTookit) {
        this.toolkit = theTookit;
    }

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
        this.server = virtualEftpos.getIpAddress();
        this.mid = virtualEftpos.getMerchantId();
        this.tid = virtualEftpos.getTerminalId();
        this.keyMap = virtualEftpos.getPairingMap();
        this.timeout = virtualEftpos.getTimeoutMillis();
        this.printReceipts = virtualEftpos.isPrintReceipts();
    }

    @Override
    public void closeOff() {
    }

    @Override
    public EftposResult performTransaction(EftposRequest request) {
        EftposResult result;
        TyroWebContext context = new TyroWebContext(this.toolkit, request, this.server, this.mid, this.tid, this.keyMap.get(request.getTransaction().getTerminal().getID()), this.printReceipts);
        context.setTimeout(this.timeout);
        if (request.isTippingAdjustment()) {
            TyroWebTipAdjust adjust = new TyroWebTipAdjust(context);
            result = adjust.doTransaction();
        } else {
            TyroWebPurchase purchase = new TyroWebPurchase(context);
            result = purchase.doTransaction();
        }
        OrderMate.LOG.info("performTransaction(EftposRequest) complete! Returning result: " + result);
        return result;
    }

    @Override
    public boolean supportsNonBlocking() {
        return false;
    }

    @Override
    public String getTerminalIDIfReady() {
        return this.tid;
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        Long terminalID = fromThisTerminal.getID();
        if (!this.keyMap.containsKey(terminalID)) {
            OrderMate.LOG.warn("Cannot query Tyro Status, not paired: " + terminalID + " to " + this.tid);
            return false;
        }
        TyroWebContext context = new TyroWebContext(this.toolkit, (EftposRequest)null, this.server, this.mid, this.tid, this.keyMap.get(terminalID), this.printReceipts);
        context.setTimeout(this.timeout);
        ExperimentalFeature skipTyroStatus = ExperimentalFeature.find("Skip Tyro Status");
        if (skipTyroStatus != null && skipTyroStatus.getBooleanValue(Boolean.FALSE).booleanValue()) {
            OrderMate.LOG.info("Skipping call to Tyro status");
            return true;
        }
        TyroWebTerminalStatus status = new TyroWebTerminalStatus(context);
        TyroTerminalStatus tyro = status.getTyroStatus();
        OrderMate.LOG.info("Status of tyro:" + tyro.available);
        return tyro.available;
    }

    @Override
    public boolean supportsBlocking() {
        return true;
    }

    @Override
    public boolean supportsTipping() {
        return true;
    }

    @Override
    public void printInterruptedTransaction(String txnReference) {
    }

    @Override
    public String clearInterruptedTransactions() {
        return null;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    @Override
    public boolean supportsPreAuth() {
        return true;
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        PreauthResult result;
        PreauthType type = request.getTxn().getType();
        TyroWebContext context = new TyroWebContext(this.toolkit, request, this.server, this.mid, this.tid, this.keyMap.get(request.getTxn().getTerminal().getID()), true);
        if (PreauthType.ALLOCATION.equals((Object)type)) {
            TyroWebPreauthAllocation allocation = new TyroWebPreauthAllocation(context);
            result = allocation.doAllocation();
        } else if (PreauthType.CONSUMPTION.equals((Object)type)) {
            TyroWebPreauthConsume consumer = new TyroWebPreauthConsume(context);
            result = consumer.doConsume();
        } else if (PreauthType.VOID.equals((Object)type)) {
            TyroWebPreauthVoid voider = new TyroWebPreauthVoid(context);
            result = voider.doVoid();
        } else {
            throw new IllegalStateException("Unknown type of preauth " + (Object)((Object)type));
        }
        return result;
    }

    @Override
    public List<String> supportedPreAuth() {
        return Arrays.asList("Settle", "Void");
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
    }

    @Override
    public boolean supportsMOTO() {
        return false;
    }
}

