/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.StringUtils;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.x500.X500Principal;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.integration.webservice.WrappingX509TrustManager;

public class TyroX509TrustManager
extends WrappingX509TrustManager {
    private String server;
    private GuiHandler handler;

    public TyroX509TrustManager(String theServer, GuiHandler yourHandler) throws Exception {
        this.handler = yourHandler;
        this.server = theServer;
    }

    @Override
    protected boolean delegateServer(X509Certificate[] chain, String authType) {
        return true;
    }

    @Override
    protected boolean handleServerMistrust(CertificateException ex, final X509Certificate[] chain, String authType) {
        if (ex instanceof CertificateExpiredException) {
            StringBuilder SB = new StringBuilder("<html>A previously trusted certificate has expired.");
            SB.append("<br><br><b>Please contact Tyro immediately.</b></html>");
            this.handler.displayOkDialog("Expired Certificate!", SB.toString());
            return false;
        }
        if (chain.length > 0) {
            X509Certificate certificate = null;
            for (X509Certificate cert : chain) {
                String name = this.getName(cert);
                if (!name.equals("*.tyro.com") && !this.server.equals(name)) continue;
                certificate = cert;
                break;
            }
            X509Certificate finalCert = certificate;
            if (certificate != null) {
                final StringBuilder SB = new StringBuilder("<html>A certificate needs to be trusted before<br>").append("the Tyro transaction can be performed:<br><br>");
                X500Principal subject = finalCert.getSubjectX500Principal();
                for (String nextString : StringUtils.splitToList(subject.getName(), ",")) {
                    SB.append(nextString).append("<br>");
                }
                SB.append("Issuer:").append(certificate.getIssuerDN().getName());
                SB.append("<br><b>Do you trust this Certificate?</b></html>");
                if (SwingUtilities.isEventDispatchThread()) {
                    return this.confirmCertificate(SB.toString(), chain);
                }
                final AtomicBoolean bool = new AtomicBoolean(false);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            bool.set(TyroX509TrustManager.this.confirmCertificate(SB.toString(), chain));
                        }
                    });
                }
                catch (Exception ex1) {
                    OrderMate.LOG.error("Cannot accept key", (Throwable)ex1);
                }
                return bool.get();
            }
            OrderMate.LOG.error("Bad Tyro Certificate! Server request at " + this.server + " received certificate:\n" + certificate);
            StringBuilder SB = new StringBuilder("<html>An untrusted Certificate has been issued.");
            SB.append("<br><br>Pairing and transactions may not be performed.<br>").append("<br><b>Contact OrderMate or Tyro immediately.</b>");
            this.handler.displayOkDialog("Untrusted Certificate!", SB.toString());
            return false;
        }
        return false;
    }

    String getName(X509Certificate cert) {
        int cutoff;
        X500Principal subject = cert.getSubjectX500Principal();
        String name = subject.getName();
        int index = name.indexOf("CN=") + 3;
        String CN = index >= 0 ? ((cutoff = name.indexOf(",", index)) > 0 ? name.substring(index, cutoff) : name.substring(index, name.length())) : "Unknown";
        return CN;
    }

    private boolean confirmCertificate(String toDisplay, X509Certificate[] chain) {
        if (this.handler.displayForcedChoiceDialog("Trust Certificate?", toDisplay, "Yes", "No")) {
            try {
                for (X509Certificate cert : chain) {
                    this.getWrappedKeyStore().setCertificateEntry(cert.getIssuerX500Principal().getName(), cert);
                }
                OrderMate.LOG.info("Inserted Tyro certificate chain into keystore");
                this.handler.displayOkDialog("Key Stored", "The Certificate has been stored");
                this.saveKeystore();
                return true;
            }
            catch (Exception ex2) {
                this.handler.displayOkDialog("Key Stored", "The Certificate was not stored.");
                OrderMate.LOG.warn("Could not insert the Certificate into the KeyStore", (Throwable)ex2);
            }
        }
        return false;
    }
}

