/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.tyro.webservice.TyroWebStatusTranslation;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroReceipt;

public class TyroTxnStatus {
    private final String txnId;
    private EftposStatus status;
    private boolean nonFatal = false;
    private String message;
    private String txnRef;
    private String authCode;
    private String tipRef;
    private String completionRef;
    private CardType cardType;
    private String rrn;
    private Price tip = null;
    private Price surcharge = null;
    private int UIExErrorCode;
    private String question;
    private List<String> questionOptions;
    private List<TyroReceipt> receipts;

    TyroTxnStatus(EftposStatus tyroStatus, String txnIdString) {
        this(tyroStatus, txnIdString, 200);
    }

    TyroTxnStatus(EftposStatus tyroStatus, String txnIdString, int errorCode) {
        this.status = tyroStatus;
        this.txnId = txnIdString;
        this.UIExErrorCode = errorCode;
        this.message = TyroWebStatusTranslation.getHtmlError(errorCode);
    }

    public int getErrorCode() {
        return this.UIExErrorCode;
    }

    String getTxnId() {
        return this.txnId;
    }

    String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    String getTxnRef() {
        return this.txnRef;
    }

    void setTxnRef(String txnRef) {
        this.txnRef = txnRef;
    }

    String getAuthCode() {
        return this.authCode;
    }

    void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    CardType getCardType() {
        return this.cardType;
    }

    void setCardType(CardType cardType) {
        this.cardType = cardType;
    }

    EftposStatus getStatus() {
        return this.status;
    }

    void setStatus(EftposStatus value) {
        this.status = value;
    }

    String getQuestion() {
        return this.question;
    }

    void setQuestion(String question) {
        this.question = question;
    }

    List<String> getQuestionOptions() {
        return this.questionOptions;
    }

    void setQuestionOptions(List<String> questionOptions) {
        this.questionOptions = questionOptions;
    }

    List<TyroReceipt> getReceipts() {
        return this.receipts;
    }

    void setReceipts(List<TyroReceipt> receipts) {
        this.receipts = receipts;
    }

    String getRrn() {
        return this.rrn;
    }

    void setRrn(String value) {
        this.rrn = value == null || value.trim().isEmpty() ? null : value;
    }

    public boolean isDone() {
        return !EftposStatus.PENDING.equals(this.status);
    }

    boolean isNonFatalError() {
        return this.nonFatal;
    }

    void setNonFatalError(boolean b) {
        this.nonFatal = true;
    }

    void setTipCompletion(String tipRef) {
        this.tipRef = tipRef;
    }

    public String getTipRef() {
        return this.tipRef;
    }

    void setTip(String value) {
        if (value == null) {
            this.tip = null;
        } else {
            try {
                Integer cents = Integer.parseInt(value);
                this.tip = new Price((double)cents.intValue() / 100.0, 0.01);
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.error("Cannot parse tip amount input. Should be the number of cents tipped.");
            }
        }
    }

    public Price getTip() {
        return this.tip;
    }

    void setSurcharge(String value) {
        if (value == null) {
            this.surcharge = null;
        } else {
            try {
                this.surcharge = new Price(value);
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.error("Cannot parse surcharge amount input.", (Throwable)ex);
            }
        }
    }

    public Price getSurcharge() {
        return this.surcharge;
    }

    void setCompletionRef(String value) {
        this.completionRef = value;
    }

    String getCompletionRef() {
        return this.completionRef;
    }

    public static enum CardType {
        EFTPOS("EFTPOS", "Savings Acc"),
        CHEQUE("EFTPOS Cheque", "Cheque Acc"),
        VISA("Visa", "Visa"),
        MASTERCARD("MasterCard", "Mastercard"),
        AMEX("AMEX", "AMEX"),
        AMERICAN_EXPRESS("American Express", "AMEX"),
        DINERS("Diners", "Diners"),
        DINERS_CLUB("Diners Club", "Diners"),
        JCB("JCB", "JCB"),
        ALIPAY("ALIPAY", "Alipay");

        private String tyroLabel;
        private String ourLabel;

        private CardType(String tyroLabel, String ourLabel) {
            this.tyroLabel = tyroLabel;
            this.ourLabel = ourLabel;
        }

        public String getTyroLabel() {
            return this.tyroLabel;
        }

        public String getOrderMateLabel() {
            return this.ourLabel;
        }

        public static CardType translate(String string) {
            if (string == null) {
                return null;
            }
            for (CardType type : CardType.values()) {
                if (!type.getTyroLabel().equalsIgnoreCase(string)) continue;
                return type;
            }
            OrderMate.LOG.warn("Unknown card type for string:" + string);
            return null;
        }
    }
}

