/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import ordermate.OrderMate;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebAction;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;
import ordermate.integration.webservice.RestHelper;

class TyroWebCancel
extends TyroWebAction {
    private String url;
    private WebResource resource;
    private int attemptsToCancel;
    private TyroCancelState state;
    private int code;
    private String message;

    TyroWebCancel(TyroWebContext context) {
        super(context);
        this.TIMEOUT = context.getTimeout();
        this.url = context.getBaseUrlBuilder().append("/transactions/").append(context.getTxnId()).toString();
        RestHelper helper = new RestHelper();
        this.resource = helper.getSslResource(this.url, TyroWebHelper.createTrustManager(context.getServer(), context.getGuiHandler()), this.TIMEOUT, this.TIMEOUT);
        this.resource = helper.addParameter(this.resource, "key", context.getKey());
    }

    public void doCancel() {
        this.state = null;
        OrderMate.LOG.info("Calling to Cancel Tyro Transaction:" + this.resource);
        try {
            WebResource.Builder builder = TyroWebHelper.addHeaderInfo(this.resource);
            OrderMate.LOG.info("Sending delete (cancel)");
            ClientResponse deleteOutput = (ClientResponse)builder.delete(ClientResponse.class);
            OrderMate.LOG.info("Received delete (cancel)");
            int responseCode = deleteOutput.getClientResponseStatus().getStatusCode();
            if (responseCode != 200) {
                OrderMate.LOG.warn("Cannot cancel, response is not 200:" + deleteOutput);
                this.setCode(responseCode);
                this.state = TyroCancelState.CANNOT_CANCEL;
            } else {
                this.state = TyroCancelState.DONE;
            }
            this.setCode(responseCode);
            OrderMate.LOG.info("ResponceCode : " + responseCode);
        }
        catch (UniformInterfaceException ex) {
            int code = ex.getResponse().getStatus();
            OrderMate.LOG.error("Couldn't cancel the transaction:", (Throwable)ex);
            this.setCode(code);
            this.state = TyroCancelState.CANNOT_CANCEL;
        }
        catch (ClientHandlerException ex) {
            OrderMate.LOG.error("Couldn't cancel the transaction, no connection: ", (Throwable)ex);
            this.state = TyroCancelState.ERROR;
            this.message = "Unable to cancel the transaction: no connection to the service";
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't cancel the transaction, manually terminating:", (Throwable)ex);
            this.state = TyroCancelState.ERROR;
            this.message = "Exception while terminating the transaction, please consult the logs.";
        }
    }

    public int getAttemptsToCancel() {
        return this.attemptsToCancel;
    }

    public void setAttemptsToCancel(int attemptsToCancel) {
        this.attemptsToCancel = attemptsToCancel;
    }

    public void incrementAttemptsToCancel(int i) {
        this.attemptsToCancel += i;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    void setCode(int code) {
        this.code = code;
    }

    public TyroCancelState getState() {
        return this.state;
    }

    void setState(TyroCancelState state) {
        this.state = state;
    }

    public static enum TyroCancelState {
        ERROR,
        CANNOT_CANCEL,
        DONE;

    }
}

