/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import au.com.ordermate.gui.GuiHandler;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;

public class TyroWebContext {
    private final EftposRequest request;
    private final PreauthRequest preauthRequest;
    private final String mid;
    private final String tid;
    private final String key;
    private final String server;
    private final boolean printReceipts;
    private String txnId;
    private Integer timeout;
    private EftposToolkit toolkit;

    public TyroWebContext(EftposToolkit yourToolkit, EftposRequest request, String server, String mid, String tid, String terminalKey, boolean receipts) {
        this.toolkit = yourToolkit;
        this.request = request;
        this.mid = mid;
        this.tid = tid;
        this.server = server;
        this.printReceipts = receipts;
        this.key = terminalKey;
        this.preauthRequest = null;
    }

    public TyroWebContext(EftposToolkit yourToolkit, PreauthRequest preauthRequest, String server, String mid, String tid, String terminalKey, boolean receipts) {
        this.toolkit = yourToolkit;
        this.preauthRequest = preauthRequest;
        this.mid = mid;
        this.tid = tid;
        this.server = server;
        this.printReceipts = receipts;
        this.key = terminalKey;
        this.request = null;
    }

    public IntegratedPaymentUI getUI() {
        return this.toolkit.getUI();
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    Integer getTimeout() {
        return this.timeout;
    }

    void setTxnId(String value) {
        this.txnId = value;
    }

    String getTxnId() {
        return this.txnId;
    }

    GuiHandler getGuiHandler() {
        return this.toolkit.getGuiHandler();
    }

    String getServer() {
        return this.server;
    }

    String getMid() {
        return this.mid;
    }

    String getTid() {
        return this.tid;
    }

    String getKey() {
        return this.key;
    }

    boolean isPrintReceipts() {
        return this.printReceipts;
    }

    EftposRequest getRequest() {
        return this.request;
    }

    PreauthRequest getPreauthRequest() {
        return this.preauthRequest;
    }

    public StringBuilder getBaseUrlBuilder() {
        return new StringBuilder(TyroWebHelper.getTerminalServerString(this.server, this.mid, this.tid));
    }
}

