/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import au.com.ordermate.gui.GuiHandler;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MediaType;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.tyro.webservice.TyroX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TyroWebHelper {
    static X509TrustManager trustManager;

    private TyroWebHelper() {
    }

    public static String getTerminalServerString(String server, String mid, String tid) {
        StringBuilder SB = new StringBuilder("");
        if (!server.startsWith("http")) {
            SB.append("https://");
        }
        SB.append(server);
        if (!server.endsWith("/")) {
            SB.append("/");
        }
        SB.append("terminals/").append(mid).append("/").append(tid);
        return SB.toString();
    }

    public static KXmlParser makeXmlParser(String response) throws XmlPullParserException, IOException {
        KXmlParser parser = new KXmlParser();
        parser.setInput((Reader)new StringReader(response));
        if (parser.getEventType() == 0) {
            parser.nextTag();
        }
        return parser;
    }

    public static String addHeaderAndGetXml(WebResource resource) {
        try {
            return (String)((WebResource.Builder)TyroWebHelper.addHeaderInfo(resource).accept(new MediaType[]{MediaType.TEXT_XML_TYPE})).get(String.class);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot get from webservice", (Throwable)ex);
            return null;
        }
    }

    public static <T> T addHeaderAndGetXml(WebResource resource, Class<T> returnClazz) {
        try {
            return (T)((WebResource.Builder)TyroWebHelper.addHeaderInfo(resource).accept(new MediaType[]{MediaType.TEXT_XML_TYPE})).get(returnClazz);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot get from webservice", (Throwable)ex);
            return null;
        }
    }

    public static String addHeaderAndPost(WebResource resource) {
        try {
            return (String)((WebResource.Builder)TyroWebHelper.addHeaderInfo(resource).accept(new MediaType[]{MediaType.TEXT_XML_TYPE})).post(String.class);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot post to webservice", (Throwable)ex);
            return null;
        }
    }

    public static WebResource.Builder addHeaderInfo(WebResource resource) {
        return (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.header("Pos-Product-Vendor", (Object)"VCSolutions").header("Pos-Product-Name", (Object)"OrderMatePOS")).header("Pos-Product-Version", (Object)"2.8.9")).header("User-Agent", (Object)"OrderMatePOS/2.8.9");
    }

    public static String convertMapToRequest(Map<String, String> map) {
        StringBuilder SB = new StringBuilder();
        for (String key : map.keySet()) {
            String value = map.get(key);
            if (value == null) continue;
            SB.append(key).append("=").append(value).append("&");
        }
        int length = SB.length();
        if (length > 0 && SB.charAt(length - 1) == '&') {
            SB.replace(length - 1, length, "");
        }
        return SB.toString();
    }

    public static X509TrustManager createTrustManager(String server, GuiHandler handler) {
        if (trustManager != null) {
            return trustManager;
        }
        try {
            return new TyroX509TrustManager(server, handler);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot instantiate X509TrustManager for Tyro", (Throwable)ex);
            return null;
        }
    }

    public static void resetTheServer(String URL2, String MID, String TID, VirtualEftpos eftpos) {
        RestHelper helper = new RestHelper();
        String url = TyroWebHelper.getTerminalServerString(URL2, MID, TID);
        WebResource resource = helper.getResource(url + "/transactions/reset");
        Long key = eftpos.getPairingMap().keySet().iterator().next();
        resource = helper.addParameter(resource, "key", eftpos.getPairingMap().get(key));
        try {
            String string = (String)TyroWebHelper.addHeaderInfo(resource).delete(String.class);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot delete from webservice", (Throwable)ex);
        }
    }
}

