/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import javax.ws.rs.core.MediaType;
import ordermate.OrderMate;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebAction;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;
import ordermate.integration.webservice.RestHelper;

class TyroWebOption
extends TyroWebAction {
    private WebResource resource;
    private TyroOptionState state;
    private String optionValue;
    private int code;
    private String message;

    TyroWebOption(TyroWebContext yourContext) {
        super(yourContext);
        this.TIMEOUT = yourContext.getTimeout();
        this.recreateRestHelper();
    }

    private void recreateRestHelper() {
        String url = this.context.getBaseUrlBuilder().append("/transactions/").append(this.context.getTxnId()).append("/input").toString();
        RestHelper helper = new RestHelper();
        this.resource = helper.getSslResource(url, TyroWebHelper.createTrustManager(this.context.getServer(), this.context.getGuiHandler()), this.TIMEOUT, this.TIMEOUT);
        this.resource = helper.addParameter(this.resource, "key", this.context.getKey());
    }

    public void doOption(String newOptionValue) {
        this.state = null;
        this.optionValue = newOptionValue;
        this.recreateRestHelper();
        Form form = new Form();
        form.add("input", this.optionValue);
        OrderMate.LOG.info("Sending Tyro response:" + this.optionValue);
        this.code = 200;
        ClientResponse response = null;
        try {
            OrderMate.LOG.info("Sending accept (option)");
            response = (ClientResponse)((WebResource.Builder)TyroWebHelper.addHeaderInfo(this.resource).accept(new MediaType[]{MediaType.TEXT_XML_TYPE})).post(ClientResponse.class, (Object)form);
            OrderMate.LOG.info("Received accept (option)");
            this.code = response.getStatus();
            if (this.code == 200) {
                this.state = TyroOptionState.DONE;
            } else if (this.isFatal(this.code)) {
                this.message = "Cannot send back input parameter. Fatal Error " + this.code;
                this.state = TyroOptionState.ERROR;
            } else {
                this.message = "Cannot send back input parameter. Unknown Error " + this.code;
                this.state = TyroOptionState.ERROR;
            }
        }
        catch (UniformInterfaceException ex) {
            response = ex.getResponse();
            OrderMate.LOG.error("Couldn't give input for the transaction:", (Throwable)ex);
            this.state = TyroOptionState.ASK_CANCEL;
        }
        catch (ClientHandlerException ex) {
            OrderMate.LOG.error("Couldn't give input for the transaction, no connection: ", (Throwable)ex);
            this.message = "Unable to send option for the transaction: no connection";
            this.state = TyroOptionState.ASK_CANCEL;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't give input for the transaction, manually terminating:", (Throwable)ex);
            this.message = "Exception while terminating the transaction, please consult the logs.";
            this.state = TyroOptionState.ASK_CANCEL;
        }
    }

    private boolean isFatal(int value) {
        return value == 400 || value == 403 || value == 404 || value == 410;
    }

    public int getCode() {
        return this.code;
    }

    void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public String getOptionValue() {
        return this.optionValue;
    }

    void setOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }

    public TyroOptionState getState() {
        return this.state;
    }

    public void setState(TyroOptionState state) {
        this.state = state;
    }

    public static enum TyroOptionState {
        ERROR,
        ASK_CANCEL,
        DONE;

    }
}

