/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.HtmlUtils;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebAction;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;
import ordermate.integration.webservice.RestHelper;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TyroWebPairing
extends TyroWebAction {
    private static final String KEY = "key";
    private static final String STATUS = "status";
    private static final String RESULT = "result";
    private final VirtualEftpos eftpos;
    private final Terminal terminal;

    public TyroWebPairing(TyroWebContext context, VirtualEftpos vEftpos, Terminal forTerminal) {
        super(context);
        if (context.getGuiHandler() == null) {
            throw new IllegalArgumentException("Cannot have a null gui handler when pairing");
        }
        this.eftpos = vEftpos;
        this.terminal = forTerminal;
    }

    public void performPairing() {
        String label = Long.toString(this.terminal.getID());
        if (this.isEmpty(label, "Terminal Label") || this.isEmpty(this.context.getServer(), "Server Location") || this.isEmpty(this.context.getMid(), "Merchant ID") || this.isEmpty(this.context.getTid(), "Terminal ID")) {
            return;
        }
        final AtomicReference<Object> ref = new AtomicReference<Object>(null);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        HtmlBuilder builder = new HtmlBuilder();
                        builder.append("Initiating pairing request...").appendLineBreak(2).append("Please go to the Tyro Terminal ID:").appendBold(TyroWebPairing.this.context.getTid()).append(" (").append(TyroWebPairing.this.eftpos.getLabel()).append(") and initiate Pairing.").appendLineBreak(2);
                        builder.append("On the Tyro Terminal:");
                        builder.appendRaw(HtmlUtils.orderedList(true, "Press <b>Menu</b>", "Select <b>Admin Menu</b>", "Enter your PIN for Tyro (If you do not know then ask a manager or call Tyro)", "Select <b>Config</b>", "Select <b>Pair with POS</b>", "If you are still experiencing issues connecting then please call Tyro Support"));
                        JPanel holder = new JPanel();
                        holder.setBorder(new EtchedBorder(1));
                        holder.add(new JLabel(builder.toString()));
                        ref.set(holder);
                    }
                });
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem with the pairing of Tyro", (Throwable)ex);
            }
        }
        this.context.getGuiHandler().displayBlockingDialog(ref.get());
        String result = null;
        try {
            result = this.sendPairingRequest(label);
            this.context.getGuiHandler().closeBlockingDialog(ref.get());
        }
        catch (UniformInterfaceException ex) {
            this.context.getGuiHandler().closeBlockingDialog(ref.get());
            this.handleCannotConnect(ex);
        }
        catch (Exception ex) {
            this.context.getGuiHandler().closeBlockingDialog(ref.get());
            this.handleGeneralError(ex);
            return;
        }
        OrderMate.LOG.info("Got Pairing Result:" + result);
        try {
            String key = this.parseResponse(result);
            if (key != null) {
                this.eftpos.addPairingKey(this.terminal, key);
                this.context.getGuiHandler().displayOkDialog("Terminal Paired!", "Terminal " + this.terminal.getLabel() + " has been paired.");
            } else {
                this.context.getGuiHandler().displayOkDialog("No Key", "There was no pairing key returned.");
            }
        }
        catch (Exception ex) {
            this.handleCannotParse(ex);
        }
    }

    private String sendPairingRequest(String label) throws UniformInterfaceException {
        String url = this.context.getBaseUrlBuilder().append("/key").toString();
        RestHelper helper = new RestHelper();
        WebResource resource = helper.getSslResource(url, TyroWebHelper.createTrustManager(this.context.getServer(), this.context.getGuiHandler()), this.TIMEOUT, this.TIMEOUT);
        resource = helper.addParameter(resource, "posname", label);
        OrderMate.LOG.info("Pairing to Tyro Terminal With:" + resource);
        return TyroWebHelper.addHeaderAndGetXml(resource);
    }

    String parseResponse(String response) throws XmlPullParserException, IOException {
        if (response == null) {
            return null;
        }
        StringReader reader = new StringReader(response);
        KXmlParser parser = new KXmlParser();
        parser.setInput((Reader)reader);
        if (parser.getEventType() == 0) {
            parser.nextTag();
        }
        boolean hasResult = false;
        String pairingKey = null;
        while (parser.getEventType() != 1) {
            int type = parser.getEventType();
            if (type == 2) {
                String name = parser.getName();
                if (KEY.equals(name)) {
                    String status = parser.getAttributeValue(null, STATUS);
                    if (!"COMPLETE".equals(status)) {
                        this.context.getGuiHandler().displayOkDialog("Not Paired", "Pairing was not completed");
                        return null;
                    }
                    hasResult = true;
                } else if (RESULT.equals(name)) {
                    parser.require(2, null, RESULT);
                    pairingKey = parser.nextText();
                    parser.nextTag();
                }
            }
            parser.nextToken();
        }
        if (hasResult) {
            return pairingKey;
        }
        return null;
    }

    private boolean isEmpty(String value, String name) {
        if (value == null || value.trim().isEmpty()) {
            this.context.getGuiHandler().displayOkDialog("Cannot Pair", "The field " + name + " cannot be empty.");
            return true;
        }
        return false;
    }

    private void handleGeneralError(Exception ex) {
        OrderMate.LOG.warn("Cannot pair Tyro Eftpos Err:", (Throwable)ex);
        this.context.getGuiHandler().displayOkDialog("Cannot Pair Device", "Check the server address.");
    }

    private void handleCannotConnect(UniformInterfaceException ex) {
        int status = ex.getResponse().getStatus();
        OrderMate.LOG.warn("Cannot pair Tyro Eftpos Err:" + status, (Throwable)ex);
        StringBuilder SB = new StringBuilder("<html>Cannot Pair Tyro Terminal:<br>");
        this.appendStatusString(status, SB);
        SB.append("<br><br>Please consult the logs for more details</html>");
        this.context.getGuiHandler().displayOkDialog("Cannot Pair Device", SB.toString());
    }

    private void handleCannotParse(Exception ex) {
        OrderMate.LOG.warn("Malformed XML for Pairing:", (Throwable)ex);
        StringBuilder SB = new StringBuilder("<html>Cannot Pair: The response was malformed.<br><br>");
        SB.append("Please contact OrderMate to resolve</html>");
        this.context.getGuiHandler().displayOkDialog("Malformed Response", SB.toString());
    }

    private void appendStatusString(int status, StringBuilder SB) {
        SB.append("<b>");
        if (status == 202) {
            SB.append("System not ready to receive requests (202)</b>");
        }
        if (status == 404) {
            SB.append("Terminal is not connected to Tyro (404)</b><br>Check that the Tyro Terminal is connected to the internet and switched on.");
        } else if (status == 400) {
            SB.append("Request does not conform to requirements (400)</b><br>Please contact Ordermate regarding this.");
        } else if (status == 409) {
            SB.append("Two or more POS systems tried to establish a key<br>for the Terminal at the same time (409)</br>");
        } else if (status == 504) {
            SB.append("Request timed out before response received from Terminal (504)</b>");
        } else {
            SB.append("Error in Tyro System - Please report these to Tyro (").append(status).append(")</b>");
        }
    }
}

