/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import com.sun.jersey.api.representation.Form;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroTxnStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebRequest;

public class TyroWebPreauthAllocation
extends TyroWebRequest<PreauthResult> {
    public TyroWebPreauthAllocation(TyroWebContext yourContext) {
        super(yourContext);
    }

    public PreauthResult doAllocation() {
        PreauthResult result = null;
        result = (PreauthResult)this.doRequest();
        return result;
    }

    @Override
    protected String getRequestType() {
        return "Performing Preauth Allocation";
    }

    @Override
    protected String getEndpoint() {
        return "/transactions";
    }

    @Override
    protected Form createForm() {
        PreauthRequest request = this.context.getPreauthRequest();
        PreauthTransaction txn = request.getTxn();
        Form form = new Form();
        form.add("key", this.context.getKey());
        form.add("type", "openTab");
        form.add("tabLimit", this.cents(txn.getAmount()));
        form.add("integratedReceipt", this.context.isPrintReceipts() ? "true" : "false");
        form.add("returnExtraDataOnCompletion", "true");
        return form;
    }

    @Override
    protected PreauthResult getCancelledResult(TyroTxnStatus cancelledStatus) {
        TyroTxnStatus.CardType type = cancelledStatus.getCardType();
        return new PreauthResult(this.context.getPreauthRequest(), EftposStatus.CANCELLED, "User Cancelled this request", type == null ? null : FinanceUnit.getUnitForName(type.getOrderMateLabel()));
    }

    @Override
    protected PreauthResult formEftposResult(TyroTxnStatus inputStatus) {
        TyroTxnStatus.CardType type = inputStatus.getCardType();
        PreauthRequest request = this.context.getPreauthRequest();
        PreauthTransaction txn = request.getTxn();
        if (txn.getIdentifier() != null) {
            txn.setIdentifier(this.context.getTxnId());
        }
        txn.setAuthCode(inputStatus.getAuthCode());
        txn.setRrn(inputStatus.getRrn());
        txn.setTxnReference(inputStatus.getTxnRef());
        txn.setCompletionRef(inputStatus.getCompletionRef());
        if (type != null) {
            txn.setCardType(type.name());
        }
        txn.save();
        String explicitError = this.txnStatus.getError() != null && !this.txnStatus.getError().isEmpty() ? this.txnStatus.getError() : null;
        PreauthResult result = new PreauthResult(this.context.getPreauthRequest(), inputStatus.getStatus(), explicitError, type == null ? null : FinanceUnit.getUnitForName(type.getOrderMateLabel()));
        return result;
    }
}

