/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.representation.Form;
import java.io.IOException;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroTxnStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebRequest;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TyroWebPreauthConsume
extends TyroWebRequest<PreauthResult> {
    public TyroWebPreauthConsume(TyroWebContext yourContext) {
        super(yourContext);
        if (yourContext.getPreauthRequest().getTxn().getReferredTxn() == null) {
            throw new IllegalStateException("A consuming request must have a referring transaction");
        }
        if (StringUtils.isEmpty(yourContext.getPreauthRequest().getTxn().getReferredTxn().getCompletionRef())) {
            throw new IllegalStateException("To close a preauth transaction, it must have a completion ref");
        }
    }

    public PreauthResult doConsume() {
        PreauthResult result = null;
        result = (PreauthResult)this.doRequest();
        return result;
    }

    @Override
    protected String getRequestType() {
        return "Performing Preauth Consumption";
    }

    @Override
    protected String getEndpoint() {
        return "/tabs/" + this.context.getPreauthRequest().getTxn().getReferredTxn().getCompletionRef();
    }

    @Override
    protected Form createForm() {
        PreauthRequest request = this.context.getPreauthRequest();
        PreauthTransaction txn = request.getTxn();
        Form form = new Form();
        form.add("key", this.context.getKey());
        form.add("tabAmount", this.cents(txn.getAmount()));
        return form;
    }

    @Override
    protected String parseResponse(String entity) throws XmlPullParserException, IOException {
        KXmlParser parser = TyroWebHelper.makeXmlParser(entity);
        parser.require(2, null, "close-tab");
        parser.nextTag();
        parser.require(2, null, "result");
        parser.next();
        String statusValue = parser.getText();
        parser.next();
        parser.require(3, null, "result");
        parser.nextTag();
        parser.require(3, null, "close-tab");
        return statusValue;
    }

    @Override
    protected PreauthResult postGoodResponse(String statusValue) {
        EftposStatus status = "OK".equals(statusValue) ? EftposStatus.APPROVED : EftposStatus.DECLINED;
        String error = null;
        if (!statusValue.equals("OK")) {
            if (statusValue.equals("AlreadyCompleted")) {
                error = "This Tab has already been closed.";
            } else if (statusValue.equals("AlreadyVoided")) {
                error = "This Tab has already been voided and cannot be closed.";
            } else if (statusValue.equals("UnknownTransaction")) {
                error = "There is no tab for the corresponding completion ID.";
            } else if (statusValue.equals("InvalidAmount")) {
                error = "The amount cannot be greater than the preallocated amount";
            } else {
                OrderMate.LOG.warn("Got unknown response for Preauth Completion:" + statusValue);
                error = "Tyro Error";
            }
        }
        PreauthResult result = new PreauthResult(this.context.getPreauthRequest(), status, error, FinanceUnit.getUnitForName(this.context.getPreauthRequest().getTxn().getCardType()));
        return result;
    }

    @Override
    protected PreauthResult formEftposResult(TyroTxnStatus inputStatus) {
        return null;
    }

    @Override
    protected PreauthResult getCancelledResult(TyroTxnStatus cancelledStatus) {
        TyroTxnStatus.CardType type = cancelledStatus.getCardType();
        return new PreauthResult(this.context.getPreauthRequest(), EftposStatus.CANCELLED, "User Cancelled this request", type == null ? null : FinanceUnit.getUnitForName(type.getOrderMateLabel()));
    }
}

