/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.representation.Form;
import java.io.IOException;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroTxnStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebRequest;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TyroWebPreauthVoid
extends TyroWebRequest<PreauthResult> {
    public TyroWebPreauthVoid(TyroWebContext yourContext) {
        super(yourContext);
        if (yourContext.getPreauthRequest().getTxn().getReferredTxn() == null) {
            throw new IllegalStateException("A void request must have a referring transaction");
        }
        if (StringUtils.isEmpty(yourContext.getPreauthRequest().getTxn().getReferredTxn().getCompletionRef())) {
            throw new IllegalStateException("To void a preauth transaction, it must have a completion ref");
        }
    }

    public PreauthResult doVoid() {
        PreauthResult result = null;
        result = (PreauthResult)this.doRequest();
        return result;
    }

    @Override
    protected String getMethod() {
        return "DELETE";
    }

    @Override
    protected String getRequestType() {
        return "Performing Preauth Void";
    }

    @Override
    protected String getEndpoint() {
        return "/tabs/" + this.context.getPreauthRequest().getTxn().getReferredTxn().getCompletionRef() + "?" + "key" + "=" + this.context.getKey();
    }

    @Override
    protected String parseResponse(String entity) throws XmlPullParserException, IOException {
        KXmlParser parser = TyroWebHelper.makeXmlParser(entity);
        parser.require(2, null, "void-tab");
        parser.nextTag();
        parser.require(2, null, "result");
        parser.next();
        String statusValue = parser.getText();
        parser.next();
        parser.require(3, null, "result");
        parser.nextTag();
        parser.require(3, null, "void-tab");
        return statusValue;
    }

    @Override
    protected PreauthResult postGoodResponse(String statusValue) {
        PreauthRequest request = this.context.getPreauthRequest();
        PreauthTransaction voidingTxn = request.getTxn();
        PreauthTransaction refTxn = this.context.getPreauthRequest().getTxn().getReferredTxn();
        voidingTxn.setReason(statusValue);
        EftposStatus eftposStatus = "OK".equals(statusValue) ? EftposStatus.APPROVED : EftposStatus.DECLINED;
        PreauthResult result = new PreauthResult(request, eftposStatus, statusValue, null);
        return result;
    }

    @Override
    protected Form createForm() {
        Form form = new Form();
        form.add("key", this.context.getKey());
        return form;
    }

    @Override
    protected PreauthResult formEftposResult(TyroTxnStatus inputStatus) {
        return null;
    }

    @Override
    protected PreauthResult getCancelledResult(TyroTxnStatus cancelledStatus) {
        TyroTxnStatus.CardType type = cancelledStatus.getCardType();
        return new PreauthResult(this.context.getPreauthRequest(), EftposStatus.CANCELLED, "User Cancelled this request", type == null ? null : FinanceUnit.getUnitForName(type.getOrderMateLabel()));
    }
}

