/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import au.com.ordermate.util.Price;
import com.sun.jersey.api.representation.Form;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroTxnStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebRequest;

public class TyroWebPurchase
extends TyroWebRequest<EftposResult> {
    public TyroWebPurchase(TyroWebContext context) {
        super(context);
    }

    @Override
    protected String getRequestType() {
        return "Performing Transaction";
    }

    @Override
    protected String getEndpoint() {
        return "/transactions";
    }

    public EftposResult doTransaction() {
        EftposResult result = null;
        result = (EftposResult)this.doRequest();
        return result;
    }

    @Override
    protected Form createForm() {
        EftposTransaction txn = this.context.getRequest().getTransaction();
        Form form = new Form();
        if (this.context.getRequest().getTransaction().getPaid().lessThan(Price.ZERO_DOLLAR) ^ this.context.getRequest().isReversal()) {
            form.add("type", "refund");
            form.add("refundAmount", this.cents(txn.getPaid().add(txn.getTip())));
        } else {
            form.add("type", "purchase");
            Price total = txn.getPaid().add(txn.getTip());
            form.add("purchaseAmount", this.cents(total));
            if (txn.getVirtualEftpos() != null && txn.getVirtualEftpos().isAutoSurcharge()) {
                form.add("enableSurcharge", "true");
            } else {
                form.add("enableSurcharge", "false");
            }
            if (txn.getCashOut() != null && !Price.ZERO_DOLLAR.equals(txn.getCashOut())) {
                form.add("cashoutAmount", this.cents(txn.getCashOut()));
            }
            form.add("returnExtraDataOnCompletion", "true");
            form.add("returnTipDataOnCompletion", "true");
        }
        form.add("key", this.context.getKey());
        form.add("integratedReceipt", this.context.isPrintReceipts() ? "true" : "false");
        return form;
    }

    @Override
    protected EftposResult formEftposResult(TyroTxnStatus inputStatus) {
        String explicitError;
        TyroTxnStatus.CardType type = inputStatus.getCardType();
        EftposTransaction eftTxn = this.context.getRequest().getTransaction();
        eftTxn.setAuthCode(inputStatus.getAuthCode());
        eftTxn.setTransactionReference(inputStatus.getTxnRef());
        eftTxn.setTipReference(inputStatus.getTipRef());
        Price surcharge = eftTxn.getSurcharge();
        Price paid = eftTxn.getPaid();
        VirtualEftpos vEft = eftTxn.getVirtualEftpos();
        if (vEft != null && vEft.isAutoSurcharge() && !this.context.getRequest().isReversal()) {
            surcharge = inputStatus.getSurcharge() == null ? Price.ZERO_DOLLAR : inputStatus.getSurcharge();
            paid = eftTxn.getPaid().add(surcharge);
        }
        eftTxn.setSurcharge(surcharge);
        eftTxn.setPaid(paid);
        eftTxn.setTendered(paid);
        Price cashout = eftTxn.getCashOut();
        Price tip = inputStatus.getTip() != null ? inputStatus.getTip() : eftTxn.getTip();
        String string = explicitError = this.txnStatus.getError() != null && !this.txnStatus.getError().isEmpty() ? this.txnStatus.getError() : null;
        if (this.context.getRequest().isReversal()) {
            paid = paid.negate();
            surcharge = surcharge != null ? surcharge.negate() : Price.ZERO_DOLLAR;
            tip = tip != null ? tip.negate() : Price.ZERO_DOLLAR;
            cashout = Price.ZERO_DOLLAR;
        }
        EftposResult result = new EftposResult(this.context.getRequest(), inputStatus.getStatus(), type == null ? null : FinanceUnit.getUnitForName(type.getOrderMateLabel()), paid, tip, surcharge, cashout, this.context.getTid(), explicitError);
        return result;
    }

    @Override
    protected EftposResult getCancelledResult(TyroTxnStatus cancelledStatus) {
        return EftposResult.adjustment(this.context.getRequest(), EftposStatus.CANCELLED);
    }
}

