/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.ws.rs.core.MediaType;
import ordermate.OrderMate;
import ordermate.database.hardware.eftpos.EftposPrintProcessor;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.integration.eftpos.tyro.TyroHelper;
import ordermate.integration.eftpos.tyro.webservice.TyroWebConstants;
import ordermate.integration.eftpos.tyro.webservice.TyroWebStatusTranslation;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroReceipt;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroTxnStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebAction;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebCancel;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebOption;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebTxnStatus;
import ordermate.integration.webservice.RestHelper;
import ordermate.services.hardware.physical.eftpos.EftposPrintProcessorFactory;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class TyroWebRequest<T>
extends TyroWebAction {
    private IntegratedPaymentUI tyroUI;
    private List<TyroReceipt> receipts = new ArrayList<TyroReceipt>();
    private int attempts = 0;
    private EftposPrintProcessor printProcessor;
    protected TyroWebTxnStatus txnStatus;
    private TyroTxnStatus status;
    private TyroTxnStatus prevStatus;
    private volatile TyroWebOption option;
    private volatile TyroWebCancel cancel;
    private AtomicBoolean userCancel = new AtomicBoolean(false);
    private Thread optionThread;
    private boolean ignoreResponse = false;
    String selectedQuestion;
    private volatile ButtonClicked buttonInput = null;

    TyroWebRequest(TyroWebContext yourContext) {
        super(yourContext);
        if (this.context.getGuiHandler() == null) {
            throw new IllegalArgumentException("Cannot make a Tyro Purchase without a Gui Handler");
        }
        if (this.context.getRequest() == null && this.context.getPreauthRequest() == null) {
            throw new IllegalArgumentException("Cannot make a transaction without a request");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.setupGui();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TyroWebRequest.this.setupGui();
                    }
                });
            }
            catch (InterruptedException ex) {
                OrderMate.LOG.error("Cannot instantiate gui panel for Tyro Web Eftpos", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                OrderMate.LOG.error("Cannot instantiate gui panel for Tyro Web Eftpos", (Throwable)ex);
            }
        }
    }

    private void setupGui() {
        this.tyroUI = this.context.getUI();
        this.tyroUI.getOptionSignal().connect(this, "gotOption");
        this.tyroUI.getCancelSignal().connect(this, "gotCancel");
        this.printProcessor = EftposPrintProcessorFactory.createEftposPrintProcessor();
    }

    protected abstract String getRequestType();

    protected abstract String getEndpoint();

    protected abstract Form createForm();

    protected abstract T formEftposResult(TyroTxnStatus var1);

    protected abstract T getCancelledResult(TyroTxnStatus var1);

    protected WebResource createEndpoint() {
        StringBuilder SB = this.context.getBaseUrlBuilder();
        SB.append(this.getEndpoint());
        WebResource resource = new RestHelper().getSslResource(SB.toString(), TyroWebHelper.createTrustManager(this.context.getServer(), this.context.getGuiHandler()), this.TIMEOUT, this.TIMEOUT);
        return resource;
    }

    protected T goodResponse(ClientResponse response) {
        this.tyroUI.setButtonsEnabled(true);
        String statusValue = null;
        try {
            String entity = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Received response:" + entity);
            int startIndex = entity.indexOf("<");
            if (startIndex >= 0) {
                entity = entity.substring(startIndex);
            }
            statusValue = this.parseResponse(entity);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in response from Tyro:" + response, (Throwable)ex);
        }
        return this.postGoodResponse(statusValue);
    }

    protected String parseResponse(String entity) throws XmlPullParserException, IOException {
        System.out.println("Parsing:\r\n" + entity);
        KXmlParser parser = TyroWebHelper.makeXmlParser(entity);
        parser.require(2, null, "transaction");
        String statusValue = parser.getAttributeValue(null, "status");
        this.context.setTxnId(parser.getAttributeValue(null, "id"));
        parser.nextTag();
        parser.require(3, null, "transaction");
        return statusValue;
    }

    protected T postGoodResponse(String statusValue) {
        if (this.context.getTxnId() != null && !this.context.getTxnId().isEmpty()) {
            OrderMate.LOG.info("Found response from Tyro, txnId:" + this.context.getTxnId() + " is " + statusValue);
            return this.waitForTransaction();
        }
        this.tyroUI.setMessage("Cannot read response from Tyro.", IntegratedPaymentUI.FeedbackStatus.ERROR);
        this.tyroUI.refreshBlockingInterface();
        return null;
    }

    protected String getMethod() {
        return "POST";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doRequest() {
        this.tyroUI.setHeaderText(this.getRequestType());
        this.tyroUI.setMessage(this.getRequestType(), IntegratedPaymentUI.FeedbackStatus.PROGRESS);
        this.tyroUI.setButtonsEnabled(false);
        this.tyroUI.displayBlockingInterface();
        WebResource resource = this.createEndpoint();
        Form form = this.createForm();
        try {
            OrderMate.LOG.info(this.getRequestType() + " :" + resource);
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)TyroWebHelper.addHeaderInfo(resource).accept(new MediaType[]{MediaType.TEXT_XML_TYPE})).entity((Object)form)).method(this.getMethod(), ClientResponse.class);
            if (response.getStatus() / 100 == 2) {
                T t = this.goodResponse(response);
                return t;
            }
            this.handleBadResponse(response);
        }
        catch (UniformInterfaceException ex) {
            this.handleConnectionError(ex);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot initiate " + this.getRequestType(), (Throwable)ex);
        }
        finally {
            this.cleanUp();
        }
        this.hangAbout(2000L);
        if (this.txnStatus != null && this.txnStatus.getError() != null) {
            this.showError(this.txnStatus.getError());
        }
        return null;
    }

    protected boolean isUserCancelled() {
        return this.userCancel.get() || this.cancel != null && TyroWebCancel.TyroCancelState.DONE.equals((Object)this.cancel.getState());
    }

    private TyroTxnStatus getStatus(TyroWebTxnStatus webTxnStatus) {
        return webTxnStatus.getStatus();
    }

    private boolean shouldProceed(boolean done) {
        return !done && !this.isUserCancelled();
    }

    private boolean isStatusDialogButtonClicked() {
        return this.buttonInput == null && this.isUserCancelled();
    }

    private boolean waitingOnAnswer() {
        OrderMate.LOG.info("TyroWebRequest:waitingOnAnswer() ButtonInput = " + (Object)((Object)this.buttonInput) + " option = " + this.option);
        if (this.buttonInput == null) {
            return false;
        }
        return this.buttonInput.equals((Object)ButtonClicked.QUESTION) && this.option.getOptionValue() == null;
    }

    private T waitForTransaction() {
        this.txnStatus = new TyroWebTxnStatus(this.context);
        this.option = new TyroWebOption(this.context);
        this.cancel = new TyroWebCancel(this.context);
        Timer timer = new Timer();
        this.scheduleTimeout(timer);
        boolean done = false;
        this.status = null;
        while (!done) {
            OrderMate.LOG.info("ButtonInput :: " + (this.buttonInput == null) + " isUserCancelled " + this.isUserCancelled());
            if (this.isStatusDialogButtonClicked() || !this.waitingOnAnswer()) {
                OrderMate.LOG.info("Starting transaction status...");
                this.status = this.getStatus(this.txnStatus);
                if (timer != null) {
                    OrderMate.LOG.info("STOP TIMER");
                    timer.cancel();
                    timer = null;
                }
                if (!this.ignoreResponse && this.handleStatusUpdate(this.status) && !this.status.isDone()) {
                    timer = new Timer();
                    OrderMate.LOG.info("START TIMER");
                    this.scheduleTimeout(timer);
                }
                this.prevStatus = this.status;
                done = this.status.isDone();
            } else {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.ignoreResponse = false;
        }
        OrderMate.LOG.info("Tyro Web transaction complete! Returning result.");
        this.status = this.getStatus(this.txnStatus);
        if (this.status != null && EftposStatus.APPROVED.equals(this.status.getStatus())) {
            this.printFinalReceipts();
        } else if (this.isUserCancelled() && EftposStatus.CANCELLED.equals(this.status.getStatus())) {
            OrderMate.LOG.info("User cancelled, returning \"cancelled\" result.");
            return this.getCancelledResult(this.status);
        }
        return this.formEftposResult(this.status);
    }

    protected void initiateCancel() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                OrderMate.LOG.info("Starting cancel...");
                if (TyroWebRequest.this.cancel == null) {
                    TyroWebRequest.this.cancel = new TyroWebCancel(TyroWebRequest.this.context);
                }
                TyroWebRequest.this.cancel.doCancel();
                TyroWebRequest.this.checkCancel(TyroWebRequest.this.cancel);
            }
        };
        Thread t = new Thread(r);
        t.setName("Tyro Web Cancel" + t.getName());
        t.start();
    }

    private void checkOption(TyroWebOption tWebOption) {
        TyroWebOption.TyroOptionState state = tWebOption.getState();
        int code = tWebOption.getCode();
        if (TyroWebOption.TyroOptionState.DONE.equals((Object)state)) {
            this.buttonInput = null;
            this.selectedQuestion = null;
            OrderMate.LOG.info("checkOption:" + (Object)((Object)TyroWebOption.TyroOptionState.DONE));
        } else if (TyroWebOption.TyroOptionState.ASK_CANCEL.equals((Object)state)) {
            this.selectedQuestion = null;
            this.buttonInput = null;
            OrderMate.LOG.info("checkOption:" + (Object)((Object)TyroWebOption.TyroOptionState.ASK_CANCEL));
            this.handleCannotOption(tWebOption.getCode(), this.option.getOptionValue());
        } else if (TyroWebOption.TyroOptionState.ERROR.equals((Object)state)) {
            this.selectedQuestion = null;
            this.buttonInput = null;
            OrderMate.LOG.info("checkOption:" + (Object)((Object)TyroWebOption.TyroOptionState.ERROR) + "\ncode:" + code);
            this.errorCancel(tWebOption.getMessage());
        } else {
            OrderMate.LOG.info("checkOption:" + (Object)((Object)TyroWebOption.TyroOptionState.ERROR) + "\nunknown error code:" + code);
            this.errorCancel(tWebOption.getMessage());
        }
    }

    private void checkCancel(TyroWebCancel tWebCancel) {
        TyroWebCancel.TyroCancelState state = tWebCancel.getState();
        OrderMate.LOG.info("Cancel State:" + (Object)((Object)state));
        if (TyroWebCancel.TyroCancelState.DONE.equals((Object)state)) {
            this.buttonInput = null;
            this.userCancel.set(true);
            OrderMate.LOG.info("buttonInput:" + (Object)((Object)this.buttonInput));
        } else if (TyroWebCancel.TyroCancelState.CANNOT_CANCEL.equals((Object)state)) {
            this.buttonInput = ButtonClicked.CANCEL;
            this.handleCannotCancel(tWebCancel.getCode());
        } else if (TyroWebCancel.TyroCancelState.ERROR.equals((Object)state)) {
            this.buttonInput = null;
            OrderMate.LOG.info("buttonInput:" + (Object)((Object)this.buttonInput));
            this.errorCancel(tWebCancel.getMessage());
        } else {
            this.buttonInput = null;
            this.userCancel.set(true);
            OrderMate.LOG.info("Marking as canceled");
        }
    }

    private void scheduleTimeout(final Timer timer) {
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                OrderMate.LOG.warn("Tyro " + TyroWebRequest.this.getRequestType() + " timed out.");
                if (TyroWebRequest.this.doNonFatalQuestion(TyroWebStatusTranslation.getHtmlError(408), 408)) {
                    OrderMate.LOG.info("Restarting timer...");
                    TyroWebRequest.this.scheduleTimeout(timer);
                } else {
                    OrderMate.LOG.warn("Terminating " + TyroWebRequest.this.getRequestType() + " due to time out.");
                    TyroWebRequest.this.errorCancel("The Transaction timed out");
                    TyroWebRequest.this.userCancel.set(true);
                    TyroWebRequest.this.buttonInput = null;
                    timer.cancel();
                    timer.purge();
                }
            }
        }, this.TIMEOUT.longValue() + TyroWebConstants.ADD_TIMEOUT.longValue());
    }

    private boolean handleStatusUpdate(TyroTxnStatus recentStatus) {
        boolean shouldTimeout = true;
        if (recentStatus.getReceipts() != null) {
            this.printReceipts(recentStatus.getReceipts());
        }
        if (recentStatus.getErrorCode() != 200) {
            if (this.isFatal(recentStatus.getErrorCode())) {
                this.tyroUI.setMessage(TyroWebStatusTranslation.getHtmlError(recentStatus.getErrorCode()), IntegratedPaymentUI.FeedbackStatus.ERROR);
                this.tyroUI.refreshBlockingInterface();
                this.hangAbout(2000L);
                return false;
            }
            if (recentStatus.getErrorCode() == 100) {
                recentStatus.setStatus(EftposStatus.PENDING);
            } else {
                recentStatus.setStatus(EftposStatus.PENDING);
                if (this.incrementAttempts(recentStatus.getMessage().substring(6))) {
                    this.tyroUI.setMessage("Acquiring Status...(" + this.attempts + ")", IntegratedPaymentUI.FeedbackStatus.PROGRESS);
                    this.tyroUI.refreshBlockingInterface();
                }
            }
        } else {
            if (recentStatus.getQuestion() != null) {
                OrderMate.LOG.info("recentStatus.gotQuestion : " + recentStatus.getQuestion() + "\nrecentStatus.getQuestionOptions : " + recentStatus.getQuestionOptions());
                if (this.prevStatus != null && this.prevStatus.getQuestion() != null && this.prevStatus.getQuestion().compareToIgnoreCase(recentStatus.getQuestion()) != 0) {
                    this.buttonInput = null;
                    this.selectedQuestion = null;
                    this.tyroUI.setQuestion(recentStatus.getQuestion(), recentStatus.getQuestionOptions());
                    this.tyroUI.refreshBlockingInterface();
                } else if (ButtonClicked.QUESTION.equals((Object)this.buttonInput)) {
                    this.tyroUI.setMessage("Approving Question Response...(" + this.attempts + ")", IntegratedPaymentUI.FeedbackStatus.PROGRESS);
                    this.tyroUI.refreshBlockingInterface();
                } else {
                    this.tyroUI.setQuestion(recentStatus.getQuestion(), recentStatus.getQuestionOptions());
                    this.tyroUI.refreshBlockingInterface();
                }
                this.tyroUI.setButtonsEnabled(!ButtonClicked.CANCEL.equals((Object)this.buttonInput));
                return false;
            }
            if (recentStatus.getMessage() != null) {
                IntegratedPaymentUI.FeedbackStatus feedback = IntegratedPaymentUI.FeedbackStatus.INFO;
                feedback = EftposStatus.ERROR.equals(recentStatus.getStatus()) ? IntegratedPaymentUI.FeedbackStatus.ERROR : (EftposStatus.PENDING.equals(recentStatus.getStatus()) ? IntegratedPaymentUI.FeedbackStatus.PROGRESS : IntegratedPaymentUI.FeedbackStatus.INFO);
                this.tyroUI.setMessage(recentStatus.getMessage(), feedback);
                this.tyroUI.refreshBlockingInterface();
            }
        }
        return shouldTimeout;
    }

    private boolean doNonFatalQuestion(String errorMessage, int errorCode) {
        final StringBuilder SB = new StringBuilder(HtmlUtils.html("The transaction has repeatedly returned with:<br>"));
        SB.append(errorMessage);
        this.attempts = 0;
        final AtomicBoolean keepTrying = new AtomicBoolean(false);
        if (SwingUtilities.isEventDispatchThread()) {
            keepTrying.set(this.context.getGuiHandler().displayForcedChoiceDialog("Tyro Error", SB.toString(), "Retry", "Cancel"));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    keepTrying.set(TyroWebRequest.this.context.getGuiHandler().displayForcedChoiceDialog("Tyro Error", SB.toString(), "Retry", "Cancel"));
                }
            });
        }
        if (keepTrying.get()) {
            this.cancel.setAttemptsToCancel(0);
            return true;
        }
        this.cancel.incrementAttemptsToCancel(1);
        return false;
    }

    private void printReceipts(List<TyroReceipt> newReceipts) {
        if (newReceipts.size() > this.receipts.size()) {
            for (int i = this.receipts.size(); i < newReceipts.size(); ++i) {
                this.receipts.add(newReceipts.get(i));
            }
        }
        for (TyroReceipt receipt : this.receipts) {
            if (receipt.isPrinted()) continue;
            boolean fine = true;
            if (receipt.sigReq) {
                String customerData;
                String merchantData = customerData = receipt.receiptData;
                StringBuilder SB = new StringBuilder(merchantData);
                TyroHelper.modifyDocket(SB, true);
                merchantData = SB.toString();
                merchantData = TyroHelper.appendMerchant(merchantData);
                customerData = TyroHelper.makeCustomer(customerData);
                fine = this.printProcessor.printEftposDocket(merchantData, this.context.getRequest(), false);
            } else {
                fine = this.printProcessor.printEftposDocket(receipt.receiptData, this.context.getRequest(), true);
            }
            receipt.printed = fine;
        }
    }

    private void printFinalReceipts() {
        for (TyroReceipt receipt : this.receipts) {
            if (!receipt.isPrinted() || !receipt.sigReq) continue;
            this.printProcessor.printEftposDocket(TyroHelper.makeCustomer(receipt.receiptData), this.context.getRequest(), true);
        }
    }

    private void handleBadResponse(ClientResponse response) {
        String payload;
        int statusCode = response.getStatus();
        String errorMessage = TyroWebStatusTranslation.getHtmlError(statusCode);
        if (statusCode == 501 && this.context.getRequest().isReversal()) {
            errorMessage = "The terminal has refunds disabled.";
        }
        if (!StringUtils.isEmpty(payload = (String)response.getEntity(String.class))) {
            errorMessage = errorMessage + "\r\n" + payload;
        }
        this.tyroUI.setMessage(errorMessage, IntegratedPaymentUI.FeedbackStatus.ERROR);
        this.tyroUI.refreshBlockingInterface();
        this.hangAbout(2000L);
        OrderMate.LOG.warn("Cannot initiate " + this.getRequestType() + ": " + errorMessage + ", reponse: " + response);
    }

    private void handleConnectionError(UniformInterfaceException ex) {
        this.tyroUI.setMessage("Network Communication Error to Tyro Webserver", IntegratedPaymentUI.FeedbackStatus.ERROR);
        this.tyroUI.refreshBlockingInterface();
        this.hangAbout(2000L);
        OrderMate.LOG.warn("Connection Error", (Throwable)ex);
    }

    protected String cents(Price value) {
        return Integer.toString(Math.abs(value.getNumCents()));
    }

    public void gotCancel() {
        this.buttonInput = ButtonClicked.CANCEL;
        this.ignoreResponse = this.status == null || this.status.getQuestion() == null;
        this.tyroUI.setMessage("Requesting Cancel...", IntegratedPaymentUI.FeedbackStatus.PROGRESS);
        this.tyroUI.setQuestion(null, null);
        this.tyroUI.setButtonsEnabled(false);
        this.tyroUI.refreshBlockingInterface();
        this.initiateCancel();
    }

    public void handleCannotCancel(int code) {
        if (this.isFatal(code)) {
            String error = HtmlUtils.html("Cannot call cancel. Manually Terminating" + HtmlUtils.newline(1) + TyroWebStatusTranslation.getHtmlError(code));
            this.errorCancel(error);
            this.buttonInput = null;
            OrderMate.LOG.info("buttonInput:" + (Object)((Object)this.buttonInput));
        } else {
            this.tyroUI.setMessage(HtmlUtils.html(HtmlUtils.boldColor("Cannot Cancel:", "black") + "<br>" + TyroWebStatusTranslation.getHtmlError(code)), IntegratedPaymentUI.FeedbackStatus.PROGRESS);
            this.tyroUI.refreshBlockingInterface();
            OrderMate.LOG.warn("Cannot cancel. Trying again :" + code + "\nAttempt: " + this.cancel.getAttemptsToCancel());
        }
    }

    public void handleCannotOption(int code, String optionValue) {
        String message = HtmlUtils.html("Cannot send response to tyro.<br>" + TyroWebStatusTranslation.getHtmlError(code).substring(6));
        this.tyroUI.setMessage(message, IntegratedPaymentUI.FeedbackStatus.WARNING);
        this.tyroUI.setButtonsEnabled(false);
        this.tyroUI.refreshBlockingInterface();
        this.hangAbout(2000L);
        this.tyroUI.setMessage("Reaquiring Status...", IntegratedPaymentUI.FeedbackStatus.PROGRESS);
        this.tyroUI.refreshBlockingInterface();
        this.tyroUI.setCancelEnabled(true);
        OrderMate.LOG.warn("Cound not send '" + optionValue + "' option. Code: " + code);
    }

    public void gotOption(String value) {
        if (this.txnStatus.getError() != null) {
            return;
        }
        this.buttonInput = ButtonClicked.QUESTION;
        OrderMate.LOG.info("buttonInput:" + (Object)((Object)this.buttonInput));
        this.selectedQuestion = value;
        if (this.optionThread == null || !this.optionThread.isAlive()) {
            this.optionThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    OrderMate.LOG.info("Starting option...");
                    if (TyroWebRequest.this.option == null) {
                        TyroWebRequest.this.option = new TyroWebOption(TyroWebRequest.this.context);
                    }
                    TyroWebRequest.this.option.doOption(TyroWebRequest.this.selectedQuestion);
                    TyroWebRequest.this.checkOption(TyroWebRequest.this.option);
                }
            });
            this.optionThread.setName("Tyro Option " + this.optionThread.getName());
            this.optionThread.start();
        }
    }

    public void setTimeout(Integer value) {
        if (value != null) {
            this.TIMEOUT = value;
        }
    }

    public void cleanUp() {
        if (this.tyroUI != null) {
            OrderMate.LOG.info("TyroWebRequest :: Starting TyroUI cleanup");
            this.tyroUI.setButtonsEnabled(false);
            this.tyroUI.closeBlockingInterface();
            this.tyroUI.setQuestion(null, null);
            this.tyroUI.getCancelSignal().disconnect(this);
            this.tyroUI.getOptionSignal().disconnect(this);
            OrderMate.LOG.info("TyroWebRequest :: TyroUI cleanup complete!");
        } else {
            OrderMate.LOG.warn("TyroWebRequest :: TyroUI clean up was not done because tyroUI was null!");
        }
    }

    public void errorCancel(String reason) {
        this.tyroUI.setMessage(reason, IntegratedPaymentUI.FeedbackStatus.ERROR);
        this.tyroUI.refreshBlockingInterface();
        this.txnStatus.cancel(reason);
        this.tyroUI.setButtonsEnabled(false);
    }

    private void showError(String reason) {
        StringBuilder SB = new StringBuilder("<html>There was a significant problem ");
        SB.append("with the Tyro Transaction:<br><br>").append(reason).append("<br><br>Please check<ol><li>All Tyro network connections</li>").append("<li>All OrderMate Network connections</li>").append("<li>Internet connectivity</li>").append("<li>The terminal has been properly paired.</li></ol><br>").append("Please consult OrderMate or Tyro directly if this persists.");
        this.context.getGuiHandler().displayOkDialog("Error with Transaction", SB.toString());
    }

    private boolean isFatal(int value) {
        return value == 400 || value == 403 || value == 404 || value == 410;
    }

    private void hangAbout(long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean incrementAttempts(String errorMessage) {
        ++this.attempts;
        if (this.attempts >= 3) {
            String msg = HtmlUtils.html("The transaction has repeatedly returned with:<br>" + errorMessage);
            this.tyroUI.setMessage(msg, IntegratedPaymentUI.FeedbackStatus.PROGRESS);
            this.tyroUI.refreshBlockingInterface();
            return false;
        }
        return true;
    }

    private static enum ButtonClicked {
        CANCEL,
        QUESTION,
        CANCEL_PENDING;

    }
}

