/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import ordermate.OrderMate;
import ordermate.integration.eftpos.tyro.webservice.RestErrorCode;
import ordermate.integration.eftpos.tyro.webservice.TyroTerminalStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebAction;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;
import ordermate.integration.webservice.RestHelper;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TyroWebTerminalStatus
extends TyroWebAction {
    private static final String TERMINAL = "terminal";
    private static final String NAME = "name";
    private static final String AVAIL = "available";
    private static final String VERSION = "version";

    public TyroWebTerminalStatus(TyroWebContext yourContext) {
        super(yourContext);
        this.TIMEOUT = 5000;
    }

    public TyroTerminalStatus getTyroStatus() {
        String url = TyroWebHelper.getTerminalServerString(this.context.getServer(), this.context.getMid(), this.context.getTid());
        RestHelper helper = new RestHelper();
        TyroTerminalStatus response = null;
        try {
            WebResource resource = helper.getSslResource(url, TyroWebHelper.createTrustManager(this.context.getServer(), this.context.getGuiHandler()), this.TIMEOUT, this.TIMEOUT);
            resource = helper.addParameter(resource, "key", this.context.getKey());
            ClientResponse res = TyroWebHelper.addHeaderAndGetXml(resource, ClientResponse.class);
            response = this.parseXml((String)res.getEntity(String.class));
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.info("Cannot retrieve status for Tyro Terminal:", (Throwable)ex);
            response = new TyroTerminalStatus(null, null, "false", RestErrorCode.getCode(ex.getResponse().getStatus()));
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Cannot retrieve status for Tyro Terminal:", (Throwable)ex);
            response = TyroTerminalStatus.getUnknown();
        }
        return response;
    }

    TyroTerminalStatus parseXml(String xmlString) {
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput((Reader)new StringReader(xmlString));
            if (parser.getEventType() == 0) {
                parser.nextTag();
            }
            parser.require(2, null, TERMINAL);
            parser.nextTag();
            String name = null;
            String version = null;
            String available = null;
            while (!TERMINAL.equals(parser.getName())) {
                if (NAME.equals(parser.getName())) {
                    name = this.getText(NAME, parser);
                    continue;
                }
                if (VERSION.equals(parser.getName())) {
                    version = this.getText(VERSION, parser);
                    continue;
                }
                if (AVAIL.equals(parser.getName())) {
                    available = this.getText(AVAIL, parser);
                    continue;
                }
                parser.nextToken();
            }
            parser.require(3, null, TERMINAL);
            return new TyroTerminalStatus(name, version, available, RestErrorCode.R200);
        }
        catch (Exception ex) {
            this.handleBadParse(ex);
            return TyroTerminalStatus.getUnknown();
        }
    }

    private String getText(String tagName, KXmlParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, tagName);
        String text = parser.nextText();
        parser.require(3, null, tagName);
        parser.nextTag();
        return text;
    }

    private void handleBadParse(Exception ex) {
        OrderMate.LOG.warn("Error connecting to tyro eftpos status:", (Throwable)ex);
        if (this.context != null && this.context.getGuiHandler() != null) {
            this.context.getGuiHandler().displayOkDialog("Cannot determine status", "There was a problem communicating with the Tyro Eftpos.");
        }
    }
}

