/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.ws.rs.core.MediaType;
import ordermate.OrderMate;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebAction;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;
import ordermate.integration.webservice.RestHelper;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TyroWebTipAdjust
extends TyroWebAction {
    private final String TIP_COMPLETION = "tip-completion";
    private final String RESULT_KEY = "result";

    public TyroWebTipAdjust(TyroWebContext context) {
        super(context);
    }

    public EftposResult doTransaction() {
        String url = this.context.getBaseUrlBuilder().append("/completions/").append(this.context.getRequest().getTransaction().getTipReference()).toString();
        RestHelper helper = new RestHelper();
        WebResource resource = helper.getResource(url, this.TIMEOUT, this.TIMEOUT);
        Form form = new Form();
        form.add("key", this.context.getKey());
        form.add("tipAmount", "" + this.context.getRequest().getTransaction().getTip().getNumCents());
        OrderMate.LOG.info("Attempting to adjust the tip amount of " + this.context.getRequest().getTransaction().getTipReference());
        EftposResult result = null;
        try {
            ClientResponse response = (ClientResponse)((WebResource.Builder)TyroWebHelper.addHeaderInfo(resource).accept(new MediaType[]{MediaType.TEXT_XML_TYPE})).post(ClientResponse.class, (Object)form);
            if (response == null) {
                OrderMate.LOG.warn("Cannot adjust tip amount:");
            } else {
                result = this.parseResponse((String)response.getEntity(String.class)) ? EftposResult.adjustment(this.context.getRequest(), EftposStatus.APPROVED) : EftposResult.adjustment(this.context.getRequest(), EftposStatus.DECLINED);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot adjust tip amount, bad request.", (Throwable)ex);
        }
        if (result == null) {
            EftposResult.adjustment(this.context.getRequest(), EftposStatus.ERROR);
        }
        return result;
    }

    boolean parseResponse(String response) throws XmlPullParserException, IOException {
        if (response == null) {
            return false;
        }
        StringReader reader = new StringReader(response);
        KXmlParser parser = new KXmlParser();
        parser.setInput((Reader)reader);
        if (parser.getEventType() == 0) {
            parser.nextTag();
        }
        boolean hasResult = false;
        String result = TyroTipAdjustState.SystemError.name();
        while (parser.getEventType() != 1) {
            int type = parser.getEventType();
            if (type == 2) {
                String name = parser.getName();
                if ("tip-completion".equals(name)) {
                    hasResult = true;
                    parser.nextToken();
                    name = parser.getName();
                }
                if ("result".equals(name) && hasResult) {
                    parser.require(2, null, "result");
                    result = parser.nextText();
                    parser.nextTag();
                }
            }
            parser.nextToken();
        }
        return this.handleResult(result);
    }

    boolean handleResult(String theResult) {
        OrderMate.LOG.info("Got response " + theResult + " for tip adjustment");
        TyroTipAdjustState state = null;
        try {
            state = TyroTipAdjustState.valueOf(theResult == null ? "null" : theResult);
        }
        catch (IllegalArgumentException ex) {
            OrderMate.LOG.error("Cannot parse returned value. Improper or unknown response:", (Throwable)ex);
            this.context.getGuiHandler().displayOkDialog("Tip Adjustment", "Unknown response from Tyro. Please inform OrderMate or Tyro immediately:" + theResult);
            return false;
        }
        String message = null;
        switch (state) {
            case OK: {
                message = "Transaction has been successfully adjusted";
                break;
            }
            case AlreadyCompleted: {
                message = "That transaction has already been completed. No further adjustments can be performed";
                break;
            }
            case AlreadyVoided: {
                message = "That transaction has already been voided. No adjustment can be performed.";
                break;
            }
            case SystemError: {
                message = "An unexpected problem has occurred, please contact Tyro";
                break;
            }
            case UnknownTransaction: {
                message = "That transaction reference number is unknown.";
            }
        }
        this.context.getGuiHandler().displayOkDialog("Tip Adjustment", message);
        return TyroTipAdjustState.OK.equals((Object)state);
    }

    static enum TyroTipAdjustState {
        OK,
        AlreadyCompleted,
        AlreadyVoided,
        UnknownTransaction,
        SystemError;

    }
}

