/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.tyro.webservice.actions;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.HashMap;
import ordermate.OrderMate;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroReceipt;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroTxnStatus;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebAction;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebHelper;
import ordermate.integration.webservice.RestHelper;
import org.kxml2.io.KXmlParser;

class TyroWebTxnStatus
extends TyroWebAction {
    private String url;
    private WebResource resource;
    private String error = null;

    TyroWebTxnStatus(TyroWebContext context) {
        super(context);
        this.url = context.getBaseUrlBuilder().append("/transactions/").append(context.getTxnId()).toString();
        RestHelper helper = new RestHelper();
        this.TIMEOUT = context.getTimeout();
        this.resource = helper.getSslResource(this.url, TyroWebHelper.createTrustManager(context.getServer(), context.getGuiHandler()), this.TIMEOUT, this.TIMEOUT);
        this.resource = helper.addParameter(this.resource, "key", context.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TyroTxnStatus getStatus() {
        TyroWebTxnStatus tyroWebTxnStatus = this;
        synchronized (tyroWebTxnStatus) {
            if (this.error != null) {
                TyroTxnStatus status = new TyroTxnStatus(EftposStatus.ERROR, this.context.getTxnId());
                status.setMessage(this.error);
                return status;
            }
        }
        try {
            OrderMate.LOG.info("Sending getResponse");
            ClientResponse response = TyroWebHelper.addHeaderAndGetXml(this.resource, ClientResponse.class);
            OrderMate.LOG.info("Received getResponse");
            OrderMate.LOG.info("URI: GET " + this.resource.getURI());
            if (response.getStatus() == 200) {
                OrderMate.LOG.info("Successful communication with Tyro Server for Transaction status:" + this.context.getTxnId());
                return this.translateResponse((String)response.getEntity(String.class));
            }
            throw new UniformInterfaceException(response);
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.error("Error communicating with Tyro Server for Transaction status:" + this.context.getTxnId(), (Throwable)ex);
            int statusCode = ex.getResponse().getStatus();
            TyroTxnStatus status = new TyroTxnStatus(EftposStatus.ERROR, this.context.getTxnId());
            status.setMessage("Error communicating with Tyro Server - Transaction " + this.context.getTxnId());
            this.error = "Cannot communicate with Tyro Server - Transaction " + this.context.getTxnId();
            return status;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot communicate with Tyro Server for Transaction status:" + this.context.getTxnId(), (Throwable)ex);
            TyroTxnStatus status = new TyroTxnStatus(EftposStatus.ERROR, this.context.getTxnId());
            status.setMessage("Cannot communicate with Tyro Server - Transaction " + this.context.getTxnId());
            this.error = "Cannot communicate with Tyro Server - Transaction " + this.context.getTxnId();
            return status;
        }
    }

    TyroTxnStatus translateResponse(String response) {
        OrderMate.LOG.info("TyroWebTxnStatus:translateResponse() Tyro response:" + response);
        TyroTxnStatus status = null;
        try {
            KXmlParser parser = TyroWebHelper.makeXmlParser(response);
            parser.require(2, null, "transaction");
            EftposStatus completion = EftposStatus.translate(parser.getAttributeValue(null, "status"));
            this.context.setTxnId(parser.getAttributeValue(null, "id"));
            status = new TyroTxnStatus(completion, this.context.getTxnId());
            parser.nextTag();
            this.handleMessages(parser, status);
            this.handleQuestions(parser, status);
            this.handleReceipts(parser, status);
            this.handleCompleteTxn(parser, status);
        }
        catch (Exception ex) {
            status = new TyroTxnStatus(EftposStatus.ERROR, this.context.getTxnId());
            status.setMessage("Error while receiving response from Tyro - bad xml.");
            OrderMate.LOG.error("Error while receiving response from Tyro - bad xml:", (Throwable)ex);
        }
        return status;
    }

    private void handleMessages(KXmlParser parser, TyroTxnStatus status) throws Exception {
        if ("display".equals(parser.getName())) {
            String lastMessage = null;
            parser.nextTag();
            while ("message".equals(parser.getName())) {
                lastMessage = parser.getAttributeValue(null, "text");
                parser.nextTag();
                parser.nextTag();
            }
            status.setMessage(lastMessage);
            parser.nextTag();
        }
    }

    private void handleQuestions(KXmlParser parser, TyroTxnStatus status) throws Exception {
        if ("question".equals(parser.getName())) {
            String qText = parser.getAttributeValue(null, "text");
            parser.nextTag();
            ArrayList<String> options = new ArrayList<String>();
            while ("option".equals(parser.getName())) {
                options.add(parser.getAttributeValue(null, "value"));
                parser.nextTag();
                parser.nextTag();
            }
            status.setQuestion(qText);
            status.setQuestionOptions(options);
            parser.require(3, null, "question");
            parser.nextTag();
        } else {
            status.setQuestion(null);
            status.setQuestionOptions(null);
        }
    }

    private void handleReceipts(KXmlParser parser, TyroTxnStatus status) throws Exception {
        if ("receipts".equals(parser.getName())) {
            parser.nextTag();
            ArrayList<TyroReceipt> receipts = new ArrayList<TyroReceipt>();
            while ("receipt".equals(parser.getName())) {
                boolean sigReq = Boolean.valueOf(parser.getAttributeValue(null, "signature-required"));
                String text = parser.nextText();
                TyroReceipt receipt = new TyroReceipt(sigReq, text);
                receipts.add(receipt);
                parser.nextTag();
            }
            status.setReceipts(receipts);
            parser.require(3, null, "receipts");
            parser.nextTag();
        }
    }

    private void handleCompleteTxn(KXmlParser parser, TyroTxnStatus status) throws Exception {
        if (EftposStatus.COMPLETE.equals(status.getStatus())) {
            HashMap<String, String> keyValueMap = new HashMap<String, String>();
            keyValueMap.put("card", null);
            keyValueMap.put("transaction-reference", null);
            keyValueMap.put("authorisation-code", null);
            keyValueMap.put("result", null);
            keyValueMap.put("tip-completion-reference", null);
            keyValueMap.put("tip-amount", null);
            keyValueMap.put("completion-reference", null);
            while (!"transaction".equals(parser.getName())) {
                String name = parser.getName();
                if (keyValueMap.containsKey(name)) {
                    if ("card".equals(name)) {
                        parser.nextTag();
                        parser.require(2, null, "type");
                        keyValueMap.put(name, parser.nextText());
                        parser.require(3, null, "type");
                        parser.nextTag();
                    } else {
                        keyValueMap.put(name, parser.nextText());
                    }
                    parser.require(3, null, name);
                    parser.nextTag();
                    continue;
                }
                if ("extra-data".equals(name)) {
                    this.handleExtraData(parser, status);
                    continue;
                }
                System.out.println("Not handling:" + name);
                if (parser.next() == 4) {
                    parser.nextTag();
                }
                parser.require(3, null, name);
                parser.nextTag();
            }
            status.setCardType(TyroTxnStatus.CardType.translate((String)keyValueMap.get("card")));
            status.setTxnRef((String)keyValueMap.get("transaction-reference"));
            status.setAuthCode((String)keyValueMap.get("authorisation-code"));
            status.setStatus(EftposStatus.translate((String)keyValueMap.get("result")));
            status.setTipCompletion((String)keyValueMap.get("tip-completion-reference"));
            status.setTip((String)keyValueMap.get("tip-amount"));
            status.setCompletionRef((String)keyValueMap.get("completion-reference"));
        }
    }

    private void handleExtraData(KXmlParser parser, TyroTxnStatus status) throws Exception {
        parser.require(2, null, "extra-data");
        parser.nextTag();
        String name = null;
        while (!"extra-data".equals(parser.getName())) {
            name = parser.getName();
            if ("rrn".equals(name)) {
                status.setRrn(parser.nextText());
                parser.require(3, null, "rrn");
            } else if ("card-type".equals(name)) {
                status.setCardType(TyroTxnStatus.CardType.translate(parser.nextText()));
                parser.require(3, null, "card-type");
            } else if ("surcharge-amount".equals(name)) {
                status.setSurcharge(parser.nextText());
                parser.require(3, null, "surcharge-amount");
            } else if (parser.next() == 4) {
                String text = parser.getText();
                parser.nextTag();
            }
            parser.require(3, null, name);
            parser.nextTag();
        }
        parser.require(3, null, "extra-data");
        parser.nextTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(String reason) {
        TyroWebTxnStatus tyroWebTxnStatus = this;
        synchronized (tyroWebTxnStatus) {
            this.error = reason;
        }
    }

    String getError() {
        return this.error;
    }
}

