/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.exportmapping;

import java.util.ArrayList;
import java.util.List;

public abstract class ExportTemplate {
    List fields = new ArrayList(this.getFieldsNumber());
    List requiredFieldIndexes = new ArrayList();
    int fieldCount = 0;

    public abstract int getFieldsNumber();

    protected ExportTemplate() {
    }

    public Field getField(int index) {
        if (index < 0 || index >= this.getFieldsNumber()) {
            throw new IndexOutOfBoundsException();
        }
        return (Field)this.fields.get(index);
    }

    public Field getField(String name) {
        return null;
    }

    public int getIndex(Field field) {
        for (int index = 0; index < this.fields.size(); ++index) {
            if (!this.fields.get(index).equals(field)) continue;
            return index;
        }
        throw new IllegalArgumentException("Field: " + field + " not found in this template.");
    }

    public List getFields() {
        return this.fields;
    }

    protected Field addField(Field field) {
        this.fields.add(this.fieldCount, field);
        ++this.fieldCount;
        return field;
    }

    protected Field addField(int index, Field field) {
        if (index < this.fields.size() && this.fields.get(index) != null) {
            throw new IllegalArgumentException("a field has already been added at this index : " + index + "  " + this.fields.get(index));
        }
        this.fields.add(index, field);
        ++this.fieldCount;
        return field;
    }

    public boolean hasField(Field field) {
        return this.fields.contains(field);
    }

    protected boolean checkFieldCount() {
        if (this.fieldCount >= this.getFieldsNumber()) {
            throw new IndexOutOfBoundsException("Too many fields for this template: index " + this.fieldCount);
        }
        return true;
    }

    protected Field addConditionalField(Field field) {
        if (!this.checkFieldCount()) {
            return null;
        }
        this.requiredFieldIndexes.add(new Integer(this.fieldCount));
        this.addField(field);
        return field;
    }

    protected boolean validate() {
        if (this.fieldCount != this.getFieldsNumber()) {
            throw new IllegalStateException("Field count " + this.fieldCount + " does not match number of fields " + this.getFieldsNumber() + " in report template.");
        }
        return true;
    }

    public static class FieldType {
        public static final FieldType STRING = new FieldType();
        public static final FieldType DATE = new FieldType();
        public static final FieldType DECIMAL = new FieldType();
        public static final FieldType GL_CODE = new FieldType();
        public static final FieldType BOOLEAN = new FieldType();

        private FieldType() {
        }
    }

    public static class Field {
        String label;
        FieldType type;
        int length = 0;
        boolean required;

        public Field(String name, FieldType newType, int newLength, boolean newRequired) {
            this.label = name;
            this.type = newType;
            this.length = newLength;
            this.required = newRequired;
        }

        public Field(String name, FieldType newType, boolean newRequired) {
            if (newType != FieldType.GL_CODE && newType != FieldType.DATE && newType != FieldType.BOOLEAN) {
                throw new IllegalArgumentException("Fields of this type must specify a length");
            }
            this.label = name;
            this.type = newType;
            this.required = newRequired;
        }

        public Field(String name, FieldType newType, int newLength) {
            this(name, newType, newLength, false);
        }

        public Field(String name, FieldType newType) {
            this(name, newType, false);
        }

        public String toString() {
            return this.label;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

