/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.exportmapping;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ordermate.integration.exportmapping.ExportTemplate;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.NotImplementedException;

public abstract class ImportExportMapping
implements Iterator {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    protected boolean initialized = false;
    private HashMap<ExportTemplate.Field, Format> fieldFormatMap = new HashMap();

    protected abstract void initMapping();

    protected abstract ExportTemplate getTemplate();

    protected abstract Class getBusinessObjectClass();

    public abstract List getHeader();

    public abstract int size();

    public ImportExportMapping(boolean initialize) {
        if (initialize) {
            this.initMapping();
            this.initialized = true;
            this.checkInitialized();
        }
    }

    public ImportExportMapping() {
        this(true);
    }

    public void addMapping(Map map, ExportTemplate.Field field, PropertiedObject.Property property) {
        map.put(field, property);
    }

    public void addMapping(Map map, ExportTemplate.Field field, Method method) {
        map.put(field, method);
    }

    public void addMapping(Map map, ExportTemplate.Field field, String literal) {
        map.put(field, literal);
    }

    protected PropertiedObject.Property getPropertyForField(Map map, ExportTemplate.Field field) {
        if (!this.checkTemplateHasField(field)) {
            return null;
        }
        Object value = map.get(field);
        if (value instanceof PropertiedObject.Property) {
            return (PropertiedObject.Property)value;
        }
        return null;
    }

    protected Method getMethodForField(Map map, ExportTemplate.Field field) {
        if (!this.checkTemplateHasField(field)) {
            return null;
        }
        Object value = map.get(field);
        if (value instanceof Method) {
            return (Method)value;
        }
        return null;
    }

    protected String getLiteralForField(Map map, ExportTemplate.Field field) {
        Object value = map.get(field);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected String[] getLineEntry(Map map, Object object) {
        this.checkInitialized();
        String[] lineEntry = new String[this.getTemplate().getFieldsNumber()];
        for (int i = 0; i < this.getTemplate().getFieldsNumber(); ++i) {
            lineEntry[i] = this.getValueForField(map, this.getTemplate().getField(i), object);
        }
        return lineEntry;
    }

    protected String getValueForField(Map map, ExportTemplate.Field field, Object object) {
        PropertiedObject.Property property;
        Object value = null;
        Method getterMethod = null;
        this.checkInitialized();
        if (this.getLiteralForField(map, field) != null) {
            return this.getLiteralForField(map, field);
        }
        if (object instanceof PersistentObject && (property = this.getPropertyForField(map, field)) != null) {
            if (!PropertyUtils.isReadable((Object)object, (String)property.getName())) {
                throw new IllegalStateException("Property " + property + " contains no getter");
            }
            try {
                getterMethod = PropertyUtils.getReadMethod((PropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)object, (String)property.getName()));
                value = getterMethod.invoke(object, null);
            }
            catch (Exception ex) {
                getterMethod = null;
                throw new IllegalStateException("Property " + property + " contains no getter", ex);
            }
        }
        if (getterMethod == null && (getterMethod = this.getMethodForField(map, field)) != null) {
            try {
                value = getterMethod.getDeclaringClass().equals(object.getClass()) ? getterMethod.invoke(object, new Object[0]) : getterMethod.invoke((Object)this, object);
            }
            catch (Exception ex) {
                value = null;
                throw new IllegalStateException(ex);
            }
        }
        return this.formatValue(field, value);
    }

    protected String formatValue(ExportTemplate.Field field, Object value) {
        if (this.fieldFormatMap.containsKey(field)) {
            return this.fieldFormatMap.get(field).format(value);
        }
        if (value != null) {
            if (value instanceof Date) {
                return this.dateFormat.format((Date)value);
            }
            return value.toString();
        }
        return "";
    }

    private boolean checkTemplateHasField(ExportTemplate.Field field) {
        if (!this.getTemplate().hasField(field)) {
            throw new IllegalArgumentException("Template does not contain this field: " + field);
        }
        return true;
    }

    public boolean checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Import mapping has not been successfully initialized");
        }
        return true;
    }

    protected Method createAccessor(String methodName) {
        Class<?> clazz = this.getClass();
        try {
            return clazz.getMethod(methodName, this.getBusinessObjectClass());
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Method not found when initializing import mapping for " + clazz.getName() + ".  Method Name: " + methodName);
        }
    }

    protected Method createBusinessObjectAccessor(String methodName) {
        Class clazz = this.getBusinessObjectClass();
        try {
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Method not found when initializing import mapping for " + clazz.getName() + ".  Method Name: " + methodName);
        }
    }

    @Override
    public void remove() {
        throw new NotImplementedException("Remove - Optional iterator operation not implemented for MYOBImportMapping.");
    }

    protected void setFormat(ExportTemplate.Field field, Format format) {
        if (field == null) {
            return;
        }
        if (format == null) {
            this.fieldFormatMap.remove(field);
        } else {
            this.fieldFormatMap.put(field, format);
        }
    }

    public boolean isEmptyLineBetweenSets() {
        return true;
    }

    public char getSeperatorChar() {
        return ',';
    }

    public char getQuoteChar() {
        return '\"';
    }

    public String getLineEnd() {
        return "\r\n";
    }

    public void doBeforeWrittingMappings(Writer writer) throws IOException {
    }
}

