/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.exportmapping;

import au.com.ordermate.persistence.PropertiedObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.exportmapping.ImportExportMapping;

public abstract class SimpleMapping
extends ImportExportMapping {
    protected Map entryMap;
    protected List businessObjects;
    protected int index = 0;

    public SimpleMapping(List newBusinessObjects, boolean initialize) {
        super(initialize);
        this.businessObjects = newBusinessObjects;
    }

    public SimpleMapping(List newBusinessObjects) {
        super(true);
        this.businessObjects = newBusinessObjects;
    }

    @Override
    protected void initMapping() {
        this.entryMap = new HashMap();
        this.initialized = true;
    }

    public Object next() {
        if (this.index >= this.businessObjects.size()) {
            throw new NoSuchElementException();
        }
        return this.getLineEntry(this.entryMap, this.businessObjects.get(this.index++));
    }

    @Override
    public boolean hasNext() {
        return this.index < this.businessObjects.size();
    }

    @Override
    public int size() {
        return this.businessObjects.size();
    }

    public void addMapping(ExportTemplate.Field field, PropertiedObject.Property property) {
        this.addMapping(this.entryMap, field, property);
    }

    public void addMapping(ExportTemplate.Field field, Method method) {
        this.addMapping(this.entryMap, field, method);
    }

    public void addMapping(ExportTemplate.Field field, String literal) {
        super.addMapping(this.entryMap, field, literal);
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> header = new ArrayList<String>(this.getTemplate().getFieldsNumber());
        for (int i = 0; i < this.getTemplate().getFieldsNumber(); ++i) {
            if (this.entryMap.get(this.getTemplate().getField(i)) != null) {
                header.add(i, this.getTemplate().getField(i).toString());
                continue;
            }
            header.add(i, new String(""));
        }
        return header;
    }

    protected Map getMapping() {
        return this.entryMap;
    }
}

