/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.gui.GuiHandler;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.database.integration.accounting.settings.QuickbooksConfiguration;
import ordermate.database.users.User;
import ordermate.integration.finance.AccountingExporter;
import ordermate.integration.finance.myob.MYOBExporter;
import ordermate.integration.finance.quickbooks.QuickbooksExporter;
import ordermate.integration.finance.xero.XeroExporter;

public class AccountingExportManager {
    protected static AccountingExportManager instance = null;

    protected AccountingExportManager() {
    }

    public static AccountingExportManager getInstance() {
        if (instance == null) {
            instance = new AccountingExportManager();
        }
        return instance;
    }

    public AccountingExporter getAccountingIntegrationExporter() {
        return this.getAccountingIntegrationExporter(null, null);
    }

    public AccountingExporter getAccountingIntegrationExporter(GuiHandler guiHandler, EventContext context) {
        if (guiHandler == null) {
            guiHandler = new DummyGUIHandler();
        }
        if (context == null) {
            context = new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser());
        }
        switch (AccountingIntegrationConfig.getInstance().getType()) {
            case MYOB: {
                return new MYOBExporter(guiHandler, context);
            }
            case Quickbooks: {
                return new QuickbooksExporter(guiHandler, context);
            }
            case Xero: {
                return new XeroExporter(guiHandler, context);
            }
        }
        return null;
    }

    public BaseAccountingConfiguration getAccountingSettings() {
        switch (AccountingIntegrationConfig.getInstance().getType()) {
            case Quickbooks: {
                return QuickbooksConfiguration.getInstance();
            }
        }
        return BaseAccountingConfiguration.getInstance();
    }
}

