/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;

public class AccountingExportParams {
    private Date startDate;
    private Date endDate;
    private String fileName;
    private List<Integer> invoiceIDs;
    private List<AbstractDebtor> debtorsToExport;
    private AbstractDebtor customer;
    private DebtorGroup forGroup;

    public AccountingExportParams(Date startDate, Date endDate) {
        this(startDate, endDate, null, Collections.EMPTY_LIST);
    }

    public AccountingExportParams(Date startDate, Date endDate, List<Integer> invoiceIDs) {
        this(startDate, endDate, null, invoiceIDs);
    }

    public AccountingExportParams(Date startDate, Date endDate, String fileName) {
        this(startDate, endDate, fileName, Collections.EMPTY_LIST);
    }

    public AccountingExportParams(Date startDate, Date endDate, String fileName, List<Integer> invoiceIDs) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.fileName = fileName;
        this.invoiceIDs = invoiceIDs;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<AbstractDebtor> getDebtorsToExport() {
        return this.debtorsToExport;
    }

    public void setDebtorsToExport(List<AbstractDebtor> debtorsToExport) {
        this.debtorsToExport = debtorsToExport;
    }

    public AbstractDebtor getCustomer() {
        return this.customer;
    }

    public void setCustomer(AbstractDebtor customer) {
        this.customer = customer;
    }

    public DebtorGroup getForGroup() {
        return this.forGroup;
    }

    public void setForGroup(DebtorGroup forGroup) {
        this.forGroup = forGroup;
    }

    public void setInvoiceIDs(List<Integer> invoiceIDs) {
        this.invoiceIDs = invoiceIDs;
    }

    public List<Integer> getInvoiceIDs() {
        return Collections.unmodifiableList(this.invoiceIDs);
    }
}

