/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance;

import au.com.ordermate.persistence.PersistentEnumeration;
import java.util.Map;

public enum AccountingExportType {
    CUSTOMER_ACCOUNTS("Customer Accounts"),
    INVOICES("Invoices"),
    TAKINGS("Takings"),
    SALES_INCOME("Sales Income"),
    TRADE_DEBTORS("Trade Debtors"),
    PRICE_ADJUSTMENTS("Price Adjustments"),
    RECONCILIATION("Reconciliation"),
    STOCK_MOVEMENTS("Stock Movements"),
    LIABILITIES("Liabilities");

    private String description;
    public static final Map<String, AccountingExportType> register;

    private AccountingExportType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static AccountingExportType getEnumForDescription(String desc) {
        for (AccountingExportType type : AccountingExportType.values()) {
            if (!type.getDescription().equals(desc)) continue;
            return type;
        }
        throw new IllegalArgumentException();
    }

    static {
        register = PersistentEnumeration.buildRegister(AccountingExportType.values());
    }
}

