/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.users.User;
import ordermate.integration.finance.AccountingExportFunction;
import ordermate.integration.finance.AccountingExportParams;
import ordermate.integration.finance.SalesAndFinanceEntryType;
import ordermate.integration.finance.SalesAndFinanceReport;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;

public abstract class AccountingExporter {
    protected static final String RECONCILIATION_FILE_STR = "_Reconciliation";
    private GuiHandler guiHandler;
    private EventContext context;
    private ReportFormat reportFormat;
    private SalesAndFinanceReport salesAndFinanceReport;
    private static final String DEFAULT_REASON = "Something Wrong during Accounting Exporting";

    public AccountingExporter(GuiHandler guiHandler, EventContext context) {
        this.guiHandler = guiHandler;
        this.context = context == null ? new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()) : context;
        this.reportFormat = this.createReportFormat();
    }

    public String export(AccountingExportFunction toExport, AccountingExportParams param) {
        block10: {
            try {
                switch (toExport) {
                    case SALES_AND_TAKINGS: {
                        return this.exportSalesAndTakings(param);
                    }
                    case INVOICES: {
                        return this.exportStockInvoices(param);
                    }
                    case ACCOUNT_SETUP: {
                        return this.exportAccountSetup(param);
                    }
                    case CUSTOMER_ACCOUNTS: {
                        return this.exportCustomerAccounts(param);
                    }
                    case CUSTOMERS: {
                        return this.exportCustomers(param);
                    }
                    case PAYROLL: {
                        return this.exportPayRoll(param);
                    }
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error occurred export accounting data.", (Throwable)ex);
                if (this.guiHandler == null) break block10;
                this.guiHandler.displayErrorDialog("Cannot Export", "Could not export, please see error and logs", ex.getMessage());
            }
        }
        return DEFAULT_REASON;
    }

    protected String exportSalesAndTakings(AccountingExportParams param) {
        OrderMate.LOG.info("AccountingExporter - Exporting Sales And Takings For: " + DateTimeUtils.getShortDateFormat().format(param.getStartDate()) + " to " + DateTimeUtils.getShortDateFormat().format(param.getEndDate()));
        this.salesAndFinanceReport = new SalesAndFinanceReport(param.getStartDate(), param.getEndDate(), this.getReportFormat());
        String reason = null;
        if (!this.salesAndFinanceReport.hasData()) {
            OrderMate.LOG.info("No data for the period to export.");
            reason = "There were no finance or sales transactions for that date range.";
            if (this.getGuiHandler() != null) {
                this.getGuiHandler().displayOkDialog("No finance and sales data", reason);
            }
        } else if (!this.salesAndFinanceReport.isBalanced()) {
            OrderMate.LOG.info("Unbalanced finance and sales date.  List should both contain elements Sales Report size: " + this.salesAndFinanceReport.getSalesReports().size() + ", Finance report size: " + this.salesAndFinanceReport.getFinanceReports().size());
            reason = "There were finance transactions but no sales transactions, or vice versa.  Export cannot proceed.";
            if (this.getGuiHandler() != null) {
                this.getGuiHandler().displayOkDialog("Unbalanced sales and finance data", reason);
            }
        }
        return reason;
    }

    protected abstract String exportStockInvoices(AccountingExportParams var1);

    protected abstract String exportPayRoll(AccountingExportParams var1);

    protected abstract String exportCustomers(AccountingExportParams var1);

    protected abstract String exportAccountSetup(AccountingExportParams var1);

    protected abstract String exportCustomerAccounts(AccountingExportParams var1);

    public abstract boolean isSetup();

    protected abstract ReportFormat createReportFormat();

    protected void addUnknownReport(AccountingReport report) {
        OrderMate.LOG.error("Error exporting finance report object, unknown type: " + report);
    }

    public ReportFormat getReportFormat() {
        if (this.reportFormat == null) {
            this.reportFormat = this.createReportFormat();
        }
        return this.reportFormat;
    }

    protected boolean checkPropertyNotNullOrEmpty(String propValue) {
        return propValue != null && !propValue.isEmpty();
    }

    public GuiHandler getGuiHandler() {
        return this.guiHandler;
    }

    public EventContext getContext() {
        return this.context;
    }

    public SalesAndFinanceReport getSalesAndFinanceReport() {
        return this.salesAndFinanceReport;
    }

    public boolean isExportToFile() {
        return true;
    }

    public boolean supportsNegativeEntries() {
        return true;
    }

    public boolean supportsNegativeEntries(SalesAndFinanceEntryType entryType) {
        return true;
    }

    protected List<AccountingReport> getAndStripReconciliationEntries(List<AccountingReport> salesAndFinanceReportList) {
        ArrayList<AccountingReport> reconciliationReports = new ArrayList<AccountingReport>();
        for (AccountingReport report : salesAndFinanceReportList) {
            if (!report.isReconciliationEntry()) continue;
            reconciliationReports.add(report);
        }
        salesAndFinanceReportList.removeAll(reconciliationReports);
        return reconciliationReports;
    }

    protected String getReconciliationFileName(String fileName, AccountingExportParams param) {
        int idx = param.getFileName().lastIndexOf(".");
        return idx != -1 ? param.getFileName().substring(0, idx) + RECONCILIATION_FILE_STR + param.getFileName().substring(idx) : param.getFileName() + RECONCILIATION_FILE_STR;
    }

    public abstract List<AccountingExportFunction> getAccountingExportFunctions();

    public abstract FinanceExportStyle getFinanceExportStyle();
}

