/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.AccountingIntegrationExportFrequency;
import ordermate.database.integration.accounting.AccountingRetryExportType;
import ordermate.database.integration.accounting.ConfigRetryExportTasks;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.User;
import ordermate.integration.finance.AccountingExportParams;
import ordermate.integration.finance.AccountingExporter;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.integration.finance.xero.XeroExporter;
import ordermate.scheduler.Task;

public class AccountingIntegrationExportTask
implements Task {
    public static final String NAME = "Accounting Integration Export Task";
    private static final Semaphore exportLock = new Semaphore(1);

    @Override
    public void run() {
        if (!exportLock.tryAcquire()) {
            OrderMate.LOG.warn("AccountingIntegrationExportTask: Lock already in use");
            return;
        }
        try {
            this.runExport();
        }
        finally {
            exportLock.release();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void runExport() {
        Date startExportDate = AccountingIntegrationConfig.getInstance().getLastExportDate();
        if (startExportDate != null) {
            if (!DateTimeUtils.dateIsBeforeToday(startExportDate) || DateTimeUtils.dateIsToday(startExportDate)) {
                OrderMate.LOG.info("AccountingIntegrationExportTask: Last export date is equal to current date, nothing to export.");
                return;
            }
            Date endExportDate = Calendar.getInstance().getTime();
            AccountingExporter exporter = this.getAccountingExporter();
            if (exporter != null) {
                String stockDataExportedReason = null;
                String salesDataExportedReason = null;
                if (AccountingIntegrationConfig.getInstance().isExportSalesData()) {
                    salesDataExportedReason = exporter.exportSalesAndTakings(new AccountingExportParams(startExportDate, endExportDate));
                }
                if (AccountingIntegrationConfig.getInstance().isExportStockData()) {
                    stockDataExportedReason = exporter.exportStockInvoices(new AccountingExportParams(startExportDate, endExportDate));
                }
                if (salesDataExportedReason != null) {
                    this.saveOrUpdateRetryTask(salesDataExportedReason, AccountingRetryExportType.Sales, TradingDay.getCurrentTradingDay());
                }
                if (stockDataExportedReason != null) {
                    this.saveOrUpdateRetryTask(stockDataExportedReason, AccountingRetryExportType.Stock, TradingDay.getCurrentTradingDay());
                }
                if (!AccountingIntegrationConfig.getInstance().getExportFrequency().equals((Object)AccountingIntegrationExportFrequency.Manually)) {
                    AccountingIntegrationConfig.getInstance().setLastExportDate(Calendar.getInstance().getTime());
                    AccountingIntegrationConfig.getInstance().save();
                } else {
                    OrderMate.LOG.info("AccountingIntegrationExportTask: LastExportDate was not update as export was manually run");
                }
                if (salesDataExportedReason != null || stockDataExportedReason != null) {
                    OrderMate.LOG.info("AccountingIntegrationExportTask: LastExportDate was not updated as and error occurred");
                }
            } else {
                OrderMate.LOG.info("AccountingIntegrationExportTask: AccountingExporter could not be found for " + (Object)((Object)AccountingIntegrationConfig.getInstance().getType()));
            }
        } else {
            OrderMate.LOG.info("AccountingIntegrationExportTask: Last export date was not set, nothing to export.");
        }
    }

    @Override
    public void setData(Object data) {
    }

    private void saveOrUpdateRetryTask(String failureReason, AccountingRetryExportType type, TradingDay tradingDay) {
        ConfigRetryExportTasks configRetryExportTasks = ConfigRetryExportTasks.getRetryExportTasksListByTradingDaysAndType(tradingDay, type);
        if (configRetryExportTasks != null) {
            configRetryExportTasks.setLastAttempt(new Date());
            configRetryExportTasks.setFailureReason(failureReason);
            configRetryExportTasks.save();
        } else {
            ConfigRetryExportTasks stockConfigRetryExportTasks = new ConfigRetryExportTasks();
            stockConfigRetryExportTasks.setTradingDay(TradingDay.getCurrentTradingDay());
            stockConfigRetryExportTasks.setType(type);
            stockConfigRetryExportTasks.setExportDate(TradingDay.getCurrentTradingDay().getDate());
            stockConfigRetryExportTasks.setLastAttempt(new Date());
            stockConfigRetryExportTasks.setRetryCount(1);
            stockConfigRetryExportTasks.setRetrySuccess(false);
            stockConfigRetryExportTasks.setFailureReason(failureReason);
            stockConfigRetryExportTasks.save();
        }
    }

    protected AccountingExporter getAccountingExporter() {
        if (FinanceExportStyle.Xero.equals((Object)AccountingIntegrationConfig.getInstance().getType())) {
            return new XeroExporter(new DummyGUIHandler(), new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
        }
        return null;
    }
}

