/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance;

import au.com.ordermate.gui.DummyGUIHandler;
import java.util.Date;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.AccountingRetryExportType;
import ordermate.database.integration.accounting.ConfigRetryExportTasks;
import ordermate.database.users.User;
import ordermate.integration.finance.AccountingExportParams;
import ordermate.integration.finance.AccountingExporter;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.integration.finance.xero.XeroExporter;
import ordermate.scheduler.Task;

public class RetryExportTask
implements Task {
    public static final String NAME = "Retry Export Task";
    private static final Semaphore exportLock = new Semaphore(1);

    @Override
    public void run() {
        if (!exportLock.tryAcquire()) {
            OrderMate.LOG.warn("RetryExportTask: Lock already in use");
            return;
        }
        try {
            this.runExport();
        }
        finally {
            exportLock.release();
        }
    }

    private void runExport() {
        AccountingExporter accountingExporter = this.getAccountingExporter();
        if (accountingExporter == null) {
            return;
        }
        for (ConfigRetryExportTasks configRetryExportTasks : ConfigRetryExportTasks.getFailedRetryExportTasksListWithinRetryDays()) {
            String stockDataExportedReason = null;
            String salesDataExportedReason = null;
            if (configRetryExportTasks.getType().equals((Object)AccountingRetryExportType.Sales)) {
                salesDataExportedReason = accountingExporter.exportSalesAndTakings(new AccountingExportParams(configRetryExportTasks.getTradingDay().getOpenDateTime(), configRetryExportTasks.getTradingDay().getCloseDate()));
                configRetryExportTasks.setFailureReason(salesDataExportedReason);
            } else if (configRetryExportTasks.getType().equals((Object)AccountingRetryExportType.Stock)) {
                stockDataExportedReason = accountingExporter.exportStockInvoices(new AccountingExportParams(configRetryExportTasks.getTradingDay().getOpenDateTime(), configRetryExportTasks.getTradingDay().getCloseDate()));
                configRetryExportTasks.setFailureReason(stockDataExportedReason);
            }
            configRetryExportTasks.setRetryCount(configRetryExportTasks.getRetryCount() + 1);
            if (salesDataExportedReason != null || stockDataExportedReason != null) {
                configRetryExportTasks.setLastAttempt(new Date());
            } else {
                configRetryExportTasks.setLastAttempt(new Date());
                configRetryExportTasks.setRetrySuccess(true);
            }
            configRetryExportTasks.save();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
    }

    private AccountingExporter getAccountingExporter() {
        if (FinanceExportStyle.Xero.equals((Object)AccountingIntegrationConfig.getInstance().getType())) {
            return new XeroExporter(new DummyGUIHandler(), new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
        }
        return null;
    }
}

