/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.formats.DefaultReportFormat;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingDebtorReport;
import ordermate.database.integration.accounting.reports.AccountingDebtorReportHashMap;
import ordermate.database.integration.accounting.reports.AccountingFinanceReport;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.reports.AccountingSalesReport;
import ordermate.database.integration.accounting.reports.AccountingTipsReportMaker;
import ordermate.database.integration.accounting.reports.AccountingVoucherReport;
import ordermate.database.integration.accounting.reports.AccountingVoucherReportMaker;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.misc.SystemProperty;
import ordermate.integration.finance.AccountingExportManager;
import ordermate.integration.finance.AccountingHelper;
import ordermate.integration.finance.SalesAndFinanceEntryType;
import ordermate.maps.integration.finance.AccountingFinanceReportMap;
import ordermate.maps.integration.finance.AccountingSalesReportMap;

public class SalesAndFinanceReport {
    private static final String EXP_FEAT_ADJUSTMENTS_NO_TAX = "Accounting Export - Force N-T for Adjustments";
    private int creditIndex = 0;
    private int debitIndex = 0;
    private Price totalDiscountsIncludedInSales;
    private Price totalSurchargesIncludedInSales;
    private Price currentBalance;
    private Map<Long, AccountingDebtorReport> debtorReport;
    private Map<Long, List<AccountingVoucherReport>> voucherReport;
    private Map<Long, List<AccountingSalesReport>> tipsReport;
    private List<AccountingFinanceReport> financeReportDebitEntries;
    private List<AccountingSalesReport> salesReportCreditEntries;
    private List<AccountingReport> orderedReportObjects;
    private AccountingSalesReport lastAccountingSalesReport;
    private AccountingReport lastAccountingReport;
    private ReportFormat reportFormat;
    static final double SURCHARGE_AMOUNT_LIMIT = 0.005;

    public SalesAndFinanceReport(Date startDate, Date endDate) {
        this(startDate, endDate, new DefaultReportFormat());
    }

    public SalesAndFinanceReport(Date startDate, Date endDate, ReportFormat reportFormat) {
        if (startDate != null && endDate != null) {
            this.orderedReportObjects = new ArrayList<AccountingReport>();
            this.reportFormat = reportFormat;
            this.initialize(startDate, endDate);
        }
    }

    protected void initialize(Date startDate, Date endDate) {
        if (!endDate.before(startDate)) {
            this.clearReportingPreviousData();
            Shift startShift = Shift.getFirstShiftForDate(startDate);
            Shift endShift = Shift.getLastShiftClosedInBetween(startDate, endDate);
            if (startShift == null) {
                throw new IllegalStateException("Could not initialize report, date " + startDate + " has no shifts.");
            }
            if (endShift == null) {
                throw new IllegalStateException("Could not export report, dates " + startDate + " to " + endDate + " aren't closed yet.");
            }
            if (endShift.getTradingDay().getDate().before(startShift.getTradingDay().getDate())) {
                throw new IllegalStateException("Could not initialize report, end shift date is before start one.");
            }
            this.salesReportCreditEntries = AccountingSalesReportMap.getSalesReport(startShift, endShift);
            this.financeReportDebitEntries = AccountingFinanceReportMap.getReportList(startShift, endShift);
            this.sortReportEntries(this.getComparator());
            this.debtorReport = new AccountingDebtorReportHashMap(startShift, endShift);
            this.voucherReport = new AccountingVoucherReportMaker().makeVoucherReports(startShift, endShift);
            ExperimentalFeature feature = ExperimentalFeature.find("Tips In Accounting");
            if (feature != null && Boolean.TRUE.equals(feature.getBooleanValue(Boolean.FALSE))) {
                this.tipsReport = new AccountingTipsReportMaker().makeTipsReports(startShift, endShift);
            }
        } else {
            throw new IllegalStateException("Could not initialize report, end date is before start date :" + startDate + " - " + endDate);
        }
    }

    private void clearReportingPreviousData() {
        if (this.orderedReportObjects != null) {
            this.orderedReportObjects.clear();
        }
        if (this.salesReportCreditEntries != null) {
            this.salesReportCreditEntries.clear();
        }
        if (this.financeReportDebitEntries != null) {
            this.financeReportDebitEntries.clear();
        }
    }

    private void addReport(AccountingReport report) {
        if (report.getGlAccountOrDefault().isExported()) {
            if (report.getGlAccountOrDefault().isGrouped()) {
                OrderMate.LOG.info("Adding report: " + report.getAllocationMemo() + ", " + report.getTotal());
                AccountingReport groupedAccReport = this.getExistingAccountingReport(report);
                if (groupedAccReport == null) {
                    if (report instanceof AccountingFinanceReport) {
                        ((AccountingFinanceReport)report).setShowPaymentAndCashdrawer(false);
                    }
                    report.setAllocationMemoPrefix(report.getGlAccountOrDefault().getName());
                    this.orderedReportObjects.add(report);
                } else {
                    OrderMate.LOG.info("Merging with report: " + groupedAccReport.getAllocationMemo());
                    this.mergeReports(groupedAccReport, report);
                }
            } else {
                this.orderedReportObjects.add(report);
            }
        }
    }

    private void mergeReports(AccountingReport groupedAccReport, AccountingReport report) {
        groupedAccReport.addReport(report);
    }

    private AccountingReport getExistingAccountingReport(AccountingReport reportToGroup) {
        return this.getExistingAccountingReport(reportToGroup.getGlAccountOrDefault(), reportToGroup.getShift(), reportToGroup.getTaxCode());
    }

    private boolean checkReportExists(AccountingReport report, GLAccount code, Shift shift, TaxCode taxCode) {
        boolean reportFound = true;
        reportFound = reportFound && report.getGlAccountOrDefault().equals(code) && report.getShift().equals(shift);
        ExperimentalFeature feature = ExperimentalFeature.find("Compare Accounting Export Tax Code");
        if (feature == null || feature.getBooleanValue(true).booleanValue()) {
            reportFound = reportFound && report.getTaxCode().equals(taxCode);
        }
        return reportFound;
    }

    private AccountingReport getExistingAccountingReport(GLAccount code, Shift shift, TaxCode taxCode) {
        for (AccountingReport report : this.orderedReportObjects) {
            if (!this.checkReportExists(report, code, shift, taxCode)) continue;
            return report;
        }
        return null;
    }

    private boolean checkLastReport(AccountingReport report) {
        AccountingSalesReport accountingSalesReport = null;
        ExperimentalFeature feature = ExperimentalFeature.find("Merge Reports Multiple Tax");
        if (feature == null || !feature.getBooleanValue(false).booleanValue()) {
            return true;
        }
        if (report instanceof AccountingSalesReport) {
            accountingSalesReport = (AccountingSalesReport)report;
            if (this.lastAccountingSalesReport == null) {
                this.lastAccountingSalesReport = accountingSalesReport;
                return true;
            }
            if (this.lastAccountingSalesReport.getGlAccountCode().equals(accountingSalesReport.getGlAccountCode()) && this.lastAccountingSalesReport.getTotal().equals(accountingSalesReport.getTotal()) && this.lastAccountingSalesReport.getAllocationMemo().equals(accountingSalesReport.getAllocationMemo()) && this.lastAccountingSalesReport.getTaxCode().getExtAccID().equals(accountingSalesReport.getTaxCode().getExtAccID()) && this.lastAccountingSalesReport.getInventoryGroup().equals(accountingSalesReport.getInventoryGroup())) {
                return false;
            }
            this.lastAccountingSalesReport = accountingSalesReport;
            return true;
        }
        if (this.lastAccountingReport == null) {
            this.lastAccountingReport = report;
            return true;
        }
        if (this.lastAccountingReport.getGlAccountCode().equals(report.getGlAccountCode()) && this.lastAccountingReport.getTotal().equals(report.getTotal()) && this.lastAccountingReport.getAllocationMemo().equals(report.getAllocationMemo()) && this.lastAccountingReport.getTaxCode().getExtAccID().equals(report.getTaxCode().getExtAccID())) {
            return false;
        }
        this.lastAccountingReport = report;
        return true;
    }

    private void getDebitEntry(AccountingReport report, boolean addToReports) {
        if (this.checkLastReport(report)) {
            this.currentBalance = this.currentBalance == null ? this.reportFormat.getNettAmountInc(report.getTotal(), report.getTaxCode()) : this.currentBalance.add(this.reportFormat.getNettAmountInc(report.getTotal(), report.getTaxCode()));
        }
        if (addToReports) {
            this.addReport(report);
        }
    }

    private void getDebitEntry(AccountingReport report) {
        this.getDebitEntry(report, true);
    }

    private void getCreditEntry(AccountingReport report) {
        AccountingSalesReport theReportItem = (AccountingSalesReport)report;
        if (this.checkLastReport(theReportItem)) {
            this.currentBalance = this.currentBalance.subtract(this.reportFormat.getNettAmountInc(theReportItem.getTotal(), theReportItem.getTaxCode()));
        }
        this.addReport(report);
        if (theReportItem.hasDiscount()) {
            Price discount = this.reportFormat.getNettAmountInc(theReportItem.getDiscount(), report.getTaxCode());
            AccountingSalesReport discountReportItem = theReportItem.getCopy();
            discountReportItem.setNettSales(discount);
            discountReportItem.removeDiscountsAndSurcharges();
            discountReportItem.setAllocationMemoPrefix("Discounts:");
            discountReportItem.setTaxCode(TaxCode.getNotTaxable());
            discountReportItem.setTaxAmount(Price.ZERO_DOLLAR);
            this.totalDiscountsIncludedInSales = this.totalDiscountsIncludedInSales.add(discount);
            if (this.isExperimentalFeatureActive()) {
                discountReportItem.setTaxCode(TaxCode.getNotTaxable());
            }
            if (AccountingIntegrationConfig.getInstance().isIncludeDiscountEntries()) {
                this.addReport(discountReportItem);
            }
        }
        if (theReportItem.hasSurcharge()) {
            Price surcharge = this.reportFormat.getNettAmountInc(theReportItem.getSurcharge(), report.getTaxCode());
            if (surcharge.lessThan(Price.ZERO_DOLLAR) && !AccountingExportManager.getInstance().getAccountingIntegrationExporter().supportsNegativeEntries(SalesAndFinanceEntryType.Surcharge)) {
                surcharge = surcharge.negate();
            }
            this.totalSurchargesIncludedInSales = this.totalSurchargesIncludedInSales.add(surcharge);
            if (AccountingIntegrationConfig.getInstance().isIncludeSurchargeEntries()) {
                AccountingSalesReport surchargeReportItem = theReportItem.getCopy();
                surchargeReportItem.setNettSales(surcharge);
                surchargeReportItem.removeDiscountsAndSurcharges();
                surchargeReportItem.setAllocationMemoPrefix("Surcharges:");
                surchargeReportItem.setTaxCode(TaxCode.getNotTaxable());
                surchargeReportItem.setTaxAmount(Price.ZERO_DOLLAR);
                this.addReport(surchargeReportItem);
            }
        }
    }

    private boolean hasNext() {
        if (this.salesReportCreditEntries.size() > this.creditIndex && this.financeReportDebitEntries.size() > this.debitIndex) {
            return true;
        }
        if (this.salesReportCreditEntries.size() == this.creditIndex && this.financeReportDebitEntries.size() == this.debitIndex) {
            return false;
        }
        throw new IllegalStateException("Mapping out of synch.  Debit objects and credit objects should finish at the same time.");
    }

    private void processNext() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Mapping does not have next");
        }
        long thisRecordID = this.financeReportDebitEntries.get(this.debitIndex).getRecordID();
        while (thisRecordID == this.financeReportDebitEntries.get(this.debitIndex).getRecordID()) {
            AccountingReport debitObject = this.financeReportDebitEntries.get(this.debitIndex++);
            this.getDebitEntry(debitObject);
            if (this.debitIndex != this.financeReportDebitEntries.size()) continue;
            break;
        }
        for (int i = 0; i < this.salesReportCreditEntries.size(); ++i) {
            if (this.creditIndex >= this.salesReportCreditEntries.size()) {
                this.creditIndex = 0;
            }
            if (this.salesReportCreditEntries.get(this.creditIndex).getRecordID() == thisRecordID) break;
            ++this.creditIndex;
        }
        while (this.creditIndex < this.salesReportCreditEntries.size() && thisRecordID == this.salesReportCreditEntries.get(this.creditIndex).getRecordID()) {
            this.getCreditEntry(this.salesReportCreditEntries.get(this.creditIndex++));
        }
    }

    public List<AccountingReport> generateReport() {
        this.orderedReportObjects.clear();
        while (this.hasNext()) {
            PersistentObject roundingAdjustment;
            this.totalDiscountsIncludedInSales = new Price(0.0, 0.0);
            this.totalSurchargesIncludedInSales = new Price(0.0, 0.0);
            this.currentBalance = new Price(0.0, 0.0);
            AccountingFinanceReport financeReport = (AccountingFinanceReport)this.getCurrentDebitObject();
            AccountingSalesReport salesReport = (AccountingSalesReport)this.getCurrentCreditObject();
            AccountingFinanceReport firstFinanceEntry = financeReport.getCopy();
            AccountingSalesReport firstSalesEntry = salesReport.getCopy();
            Price accountDiscount = salesReport.getAccountDiscount();
            Price accountSurcharge = salesReport.getAccountSurcharge();
            this.processNext();
            this.doDiscountDebitEntry(firstFinanceEntry, this.totalDiscountsIncludedInSales.doubleValue() + accountDiscount.doubleValue());
            this.doSurchargeDebitEntry(firstFinanceEntry, this.totalSurchargesIncludedInSales.doubleValue() + accountSurcharge.doubleValue());
            this.setFirstEntriesLocation(firstFinanceEntry, firstSalesEntry);
            this.doDebtorsCreditEntry(firstSalesEntry);
            this.doDebtorsDebitEntry(firstFinanceEntry);
            this.doVoucherReport(firstSalesEntry.getShift().getID());
            this.doTipsReport(firstSalesEntry.getShift().getID());
            this.currentBalance = this.currentBalance.subtract(this.totalDiscountsIncludedInSales).subtract(this.totalSurchargesIncludedInSales);
            if (this.currentBalance.toBigDecimal().compareTo(BigDecimal.ZERO) > 0) {
                roundingAdjustment = firstSalesEntry.getCopy();
                ((AccountingSalesReport)roundingAdjustment).removeDiscountsAndSurcharges();
                ((AccountingSalesReport)roundingAdjustment).setNettSales(this.currentBalance);
                ((AccountingSalesReport)roundingAdjustment).setTaxCode(TaxCode.getNotTaxable());
                ((AccountingSalesReport)roundingAdjustment).setTaxAmount(Price.ZERO_DOLLAR);
                ((AccountingSalesReport)roundingAdjustment).setAllocationMemoPrefix("Adjustment for balance");
                ((AccountingSalesReport)roundingAdjustment).setGroupName("");
                ((AccountingSalesReport)roundingAdjustment).setGLAccount(AccountingExportManager.getInstance().getAccountingSettings().getBalanceAdjustmentGLCode());
                this.addReport((AccountingReport)((Object)roundingAdjustment));
            } else if (this.currentBalance.lessThan(Price.ZERO_DOLLAR)) {
                roundingAdjustment = firstFinanceEntry.getCopy();
                ((AccountingFinanceReport)roundingAdjustment).setAmount(this.currentBalance.negate());
                ((AccountingFinanceReport)roundingAdjustment).setAmountEx(this.currentBalance.negate());
                ((AccountingFinanceReport)roundingAdjustment).setGLAccount(AccountingExportManager.getInstance().getAccountingSettings().getBalanceAdjustmentGLCode());
                ((AccountingFinanceReport)roundingAdjustment).setPaymentMethod("Adjustment");
                ((AccountingFinanceReport)roundingAdjustment).setTaxCode(TaxCode.getNotTaxable());
                this.addReport((AccountingReport)((Object)roundingAdjustment));
            }
            this.doVarianceFromReconciliation(firstFinanceEntry);
        }
        if (!AccountingIntegrationConfig.getInstance().isIncludeZeroEntries()) {
            this.removeZeroEntries();
        }
        this.lastAccountingReport = null;
        this.lastAccountingSalesReport = null;
        return this.orderedReportObjects;
    }

    private void setFirstEntriesLocation(AccountingFinanceReport firstFinanceEntry, AccountingSalesReport firstSalesEntry) {
        if (firstSalesEntry.getSalesLocation() == null && firstFinanceEntry.getSalesLocation() != null) {
            firstSalesEntry.setSalesLocation(firstFinanceEntry.getSalesLocation());
        } else if (firstFinanceEntry.getSalesLocation() == null && firstSalesEntry.getSalesLocation() != null) {
            firstFinanceEntry.setSalesLocation(firstSalesEntry.getSalesLocation());
        }
    }

    private void removeZeroEntries() {
        ArrayList<AccountingReport> nonZeroReports = new ArrayList<AccountingReport>(0);
        for (AccountingReport report : this.orderedReportObjects) {
            if (report.getTotal().isZero()) continue;
            nonZeroReports.add(report);
        }
        this.orderedReportObjects.clear();
        this.orderedReportObjects.addAll(nonZeroReports);
    }

    private void doDiscountDebitEntry(AccountingFinanceReport financeEntry, double discountAmount) {
        if (discountAmount > 0.005) {
            AccountingFinanceReport report = new AccountingFinanceReport(financeEntry);
            Price amount = new Price(discountAmount, 0.01);
            report.setAmount(amount);
            report.setAmountEx(amount);
            report.setTaxCode(TaxCode.getNotTaxable());
            report.setGLAccount(AccountingExportManager.getInstance().getAccountingSettings().getDefaultDiscountCogsGLCode());
            report.setPaymentMethod("DISCOUNT");
            if (this.isExperimentalFeatureActive()) {
                report.setAmountEx(amount);
                report.setTaxCode(TaxCode.getNotTaxable());
            }
            this.getDebitEntry(report, AccountingIntegrationConfig.getInstance().isIncludeDiscountEntries());
        }
    }

    private void doSurchargeDebitEntry(AccountingFinanceReport financeEntry, double surchargeAmount) {
        if (this.isSurchargeEntryAllowed(surchargeAmount)) {
            AccountingFinanceReport report = new AccountingFinanceReport(financeEntry);
            Price amount = new Price(surchargeAmount, 0.01);
            report.setAmount(amount);
            report.setAmountEx(amount);
            report.setTaxCode(TaxCode.getNotTaxable());
            report.setGLAccount(AccountingExportManager.getInstance().getAccountingSettings().getDefaultSalesSurchargeGLCode());
            report.setPaymentMethod("SURCHARGE");
            if (this.isExperimentalFeatureActive()) {
                report.setAmountEx(amount);
                report.setTaxCode(TaxCode.getNotTaxable());
            }
            this.getDebitEntry(report, AccountingIntegrationConfig.getInstance().isIncludeSurchargeEntries());
        }
    }

    boolean getNegativeSurchargeAllowed() {
        return AccountingExportManager.getInstance().getAccountingIntegrationExporter().supportsNegativeEntries(SalesAndFinanceEntryType.Surcharge);
    }

    boolean isSurchargeEntryAllowed(double surchargeAmount) {
        boolean negativeSurchargeAllowed = this.getNegativeSurchargeAllowed();
        return surchargeAmount < -0.005 && negativeSurchargeAllowed || surchargeAmount > 0.005;
    }

    private void doDebtorsCreditEntry(AccountingSalesReport reportEntry) {
        AccountingDebtorReport reportItem = this.debtorReport.get(reportEntry.getRecordID());
        if (reportItem != null) {
            AccountingSalesReport debtorReportEntry;
            if (reportItem.hasAmountPaid()) {
                debtorReportEntry = reportEntry.getCopy();
                debtorReportEntry.setNettSales(reportItem.getAmountPaid());
                debtorReportEntry.removeDiscountsAndSurcharges();
                debtorReportEntry.setAllocationMemoPrefix("Paid from Debtor");
                debtorReportEntry.setGroupName("");
                debtorReportEntry.setGLAccount(reportItem.getGlAccount());
                debtorReportEntry.setTaxCode(TaxCode.getNotTaxable());
                debtorReportEntry.setTaxAmount(Price.ZERO_DOLLAR);
                this.getCreditEntry(debtorReportEntry);
            }
            if (reportItem.hasAmountDiscounted()) {
                debtorReportEntry = reportEntry.getCopy();
                debtorReportEntry.removeDiscountsAndSurcharges();
                debtorReportEntry.setGroupName("");
                debtorReportEntry.setNettSales(reportItem.getAmountDiscounted());
                debtorReportEntry.setAllocationMemoPrefix("Discounted from debtor");
                debtorReportEntry.setGLAccount(reportItem.getGlAccount());
                debtorReportEntry.setTaxCode(TaxCode.getNotTaxable());
                debtorReportEntry.setTaxAmount(Price.ZERO_DOLLAR);
                this.getCreditEntry(debtorReportEntry);
            }
            if (reportItem.hasAmountSurcharged()) {
                debtorReportEntry = reportEntry.getCopy();
                debtorReportEntry.removeDiscountsAndSurcharges();
                debtorReportEntry.setGroupName("");
                debtorReportEntry.setNettSales(reportItem.getAmountSurcharged());
                debtorReportEntry.setAllocationMemoPrefix("Surcharges to debtor");
                debtorReportEntry.setGLAccount(reportItem.getGlAccount());
                debtorReportEntry.setTaxCode(TaxCode.getGstCode());
                this.getCreditEntry(debtorReportEntry);
            }
        }
    }

    private void doDebtorsDebitEntry(AccountingFinanceReport reportEntry) {
        AccountingDebtorReport reportItem = this.debtorReport.get(reportEntry.getRecordID());
        if (reportItem != null) {
            AccountingFinanceReport debtorReportEntry;
            if (reportItem.hasAmountAdded()) {
                debtorReportEntry = reportEntry.getCopy();
                debtorReportEntry.setAmount(reportItem.getAmountAdded());
                debtorReportEntry.setAmountEx(reportItem.getAmountAdded());
                debtorReportEntry.setAllocationMemoPrefix("Added to Debtor ");
                debtorReportEntry.setGLAccount(reportItem.getGlAccount());
                debtorReportEntry.setPaymentMethod("Account");
                debtorReportEntry.setTaxCode(TaxCode.getNotTaxable());
                this.getDebitEntry(debtorReportEntry);
            }
            if (reportItem.hasAmountDiscounted()) {
                debtorReportEntry = reportEntry.getCopy();
                debtorReportEntry.setAllocationMemoPrefix("Discounts to debtors ");
                debtorReportEntry.setPaymentMethod("Discount");
                debtorReportEntry.setGLAccount(reportItem.getGlAccount());
                debtorReportEntry.setAmount(reportItem.getAmountDiscounted());
                debtorReportEntry.setAmountEx(FinanceUtils.removeTax(reportItem.getAmountDiscounted(), SystemProperty.getInstance().getBaseTaxRate()));
                debtorReportEntry.setTaxCode(TaxCode.getGstCode());
                this.getDebitEntry(debtorReportEntry);
            }
            if (reportItem.hasAmountSurcharged()) {
                debtorReportEntry = reportEntry.getCopy();
                debtorReportEntry.setAllocationMemoPrefix("Surcharges to debtors ");
                debtorReportEntry.setPaymentMethod("Surcharge");
                debtorReportEntry.setGLAccount(reportItem.getGlAccount());
                debtorReportEntry.setAmount(reportItem.getAmountSurcharged());
                debtorReportEntry.setAmountEx(reportItem.getAmountSurcharged());
                debtorReportEntry.setTaxCode(TaxCode.getNotTaxable());
                this.getDebitEntry(debtorReportEntry);
            }
            if (reportItem.hasAmountPreviousTxn()) {
                debtorReportEntry = reportEntry.getCopy();
                debtorReportEntry.setAmount(reportItem.getAmountPreviousTxn());
                debtorReportEntry.setAmountEx(reportItem.getAmountPreviousTxn());
                debtorReportEntry.setAllocationMemoPrefix("Applied Previous Transactions ");
                debtorReportEntry.setGLAccount(reportItem.getGlAccount());
                debtorReportEntry.setPaymentMethod("Account");
                debtorReportEntry.setTaxCode(TaxCode.getNotTaxable());
                this.getDebitEntry(debtorReportEntry);
                FinanceTransaction txn = debtorReportEntry.getFinanceTransaction();
                if (debtorReportEntry.getShift().equals(txn.getShift())) {
                    AccountingSalesReport debtorCreditEntry = AccountingSalesReport.generateBlankReport(txn.getShift());
                    debtorCreditEntry.setSalesLocation(txn.getSalesLocation());
                    debtorCreditEntry.setNettSales(reportItem.getAmountPreviousTxn());
                    debtorCreditEntry.removeDiscountsAndSurcharges();
                    debtorCreditEntry.setAllocationMemoPrefix("Paid from Debtor");
                    debtorCreditEntry.setGroupName("");
                    debtorCreditEntry.setGLAccount(reportItem.getGlAccount());
                    debtorCreditEntry.setTaxCode(TaxCode.getNotTaxable());
                    debtorCreditEntry.setTaxAmount(Price.ZERO_DOLLAR);
                    this.getCreditEntry(debtorCreditEntry);
                    OrderMate.LOG.info("Adding same-day debtor payment for moved payment of " + debtorCreditEntry.getNettSales());
                }
            }
        }
    }

    private void doVoucherReport(Long shiftId) {
        if (this.voucherReport == null) {
            OrderMate.LOG.warn("The voucher report is not initialised, please call initialise before generating the report");
            return;
        }
        for (AccountingVoucherReport report : this.voucherReport.get(shiftId)) {
            if (Price.ZERO_DOLLAR.equals(report.getAmount())) continue;
            if (report.isTopup()) {
                AccountingSalesReport salesReport = AccountingSalesReport.generateBlankReport(report.getShift());
                salesReport.setGLAccount(report.getGlAccount());
                salesReport.setDiscount(Price.ZERO_DOLLAR);
                salesReport.setSurcharge(Price.ZERO_DOLLAR);
                salesReport.setNettSales(report.getTotal());
                salesReport.setGrossSales(report.getTotal());
                salesReport.setTaxCode(report.getTaxCode());
                salesReport.setReconciliationEntry(false);
                salesReport.setMemo(report.getMemo());
                this.addReport(salesReport);
                this.currentBalance = this.currentBalance.subtract(salesReport.getTotal());
                continue;
            }
            AccountingFinanceReport financeReport = AccountingFinanceReport.generateBlankReport(report.getShift());
            financeReport.setGLAccount(report.getGlAccount());
            financeReport.setAmount(report.getTotal());
            financeReport.setAmountEx(report.getTotal());
            financeReport.setPaymentMethod("Voucher Redemption" + (report.isReversal() ? " Reversal" : ""));
            financeReport.setShowPaymentAndCashdrawer(true);
            this.addReport(financeReport);
            this.currentBalance = this.currentBalance.add(financeReport.getTotal());
        }
    }

    private void doTipsReport(long shiftId) {
        List<AccountingSalesReport> reports;
        ExperimentalFeature feature = ExperimentalFeature.find("Tips In Accounting");
        if (feature != null && Boolean.TRUE.equals(feature.getBooleanValue(Boolean.FALSE)) && (reports = this.tipsReport.get(shiftId)) != null && !reports.isEmpty()) {
            for (AccountingSalesReport report : reports) {
                this.addReport(report);
                this.currentBalance = this.currentBalance.subtract(report.getTotal());
            }
        }
    }

    private void doVarianceFromReconciliation(AccountingFinanceReport reportEntry) {
        ShiftReconciliation shiftRec = PersistenceManager.getObject(ShiftReconciliation.class, Query.select(ShiftReconciliation.class).equals(ShiftReconciliation.Properties.SHIFT, reportEntry.getShift()).toString(), null);
        if (shiftRec != null && shiftRec.isCompleted() && this.reportFormat.isOutputReconciliationReports()) {
            if (AccountingIntegrationConfig.getInstance().isBreakdownVariationByType()) {
                this.addReconciliationVarianceByTypeIfRequired(reportEntry, shiftRec);
            } else {
                this.addReconciliationVarianceIfRequired(reportEntry, shiftRec);
            }
            this.addOverringVarianceIfRequired(reportEntry, shiftRec);
            this.addPettyCash(reportEntry, shiftRec);
        }
    }

    private void addReconciliationVarianceIfRequired(AccountingFinanceReport reportEntry, ShiftReconciliation shiftRec) {
        if (AccountingHelper.isGLCodeSet(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationVarianceGLCode())) {
            Price variance = shiftRec.getTotal().subtract(shiftRec.getSystemTotal());
            AccountingFinanceReport varianceReportEntry = reportEntry.getCopy();
            varianceReportEntry.setShowPaymentAndCashdrawer(false);
            varianceReportEntry.setAmount(variance);
            varianceReportEntry.setAmountEx(variance);
            varianceReportEntry.setAllocationMemoPrefix("Reconciliation Variance (Assets)");
            varianceReportEntry.setGLAccount(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationVarianceGLCode());
            varianceReportEntry.setPaymentMethod("");
            varianceReportEntry.setTaxCode(TaxCode.getNotTaxable());
            varianceReportEntry.setReconciliationEntry(true);
            this.getDebitEntry(varianceReportEntry);
            if (AccountingHelper.isGLCodeSet(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationVarianceCounterbalanceGLCode())) {
                AccountingSalesReport varianceCounterbalanceReportEntry = AccountingSalesReport.generateBlankReport(shiftRec.getShift());
                varianceCounterbalanceReportEntry.setGLAccount(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationVarianceCounterbalanceGLCode());
                varianceCounterbalanceReportEntry.setNettSales(variance);
                varianceCounterbalanceReportEntry.setAllocationMemoPrefix("Reconciliation Variance (Income)");
                varianceCounterbalanceReportEntry.setTaxCode(TaxCode.getNotTaxable());
                varianceCounterbalanceReportEntry.setReconciliationEntry(true);
                this.getCreditEntry(varianceCounterbalanceReportEntry);
            }
        }
    }

    private void addOverringVarianceIfRequired(AccountingFinanceReport reportEntry, ShiftReconciliation shiftRec) {
        if (AccountingHelper.isGLCodeSet(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationOverringGLCode())) {
            Price overringTotal = shiftRec.getOverringTotal();
            AccountingFinanceReport overringVarianceReportEntry = reportEntry.getCopy();
            overringVarianceReportEntry.setShowPaymentAndCashdrawer(false);
            overringVarianceReportEntry.setAmount(overringTotal);
            overringVarianceReportEntry.setAmountEx(overringTotal);
            overringVarianceReportEntry.setAllocationMemoPrefix("Overring Total (Assets)");
            overringVarianceReportEntry.setGLAccount(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationVarianceGLCode());
            overringVarianceReportEntry.setPaymentMethod("");
            overringVarianceReportEntry.setTaxCode(TaxCode.getNotTaxable());
            overringVarianceReportEntry.setReconciliationEntry(true);
            this.getDebitEntry(overringVarianceReportEntry);
            if (AccountingHelper.isGLCodeSet(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationOverringCounterbalanceGLCode())) {
                AccountingSalesReport overringVarianceCounterbalanceReportEntry = AccountingSalesReport.generateBlankReport(shiftRec.getShift());
                overringVarianceCounterbalanceReportEntry.setGLAccount(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationOverringCounterbalanceGLCode());
                overringVarianceCounterbalanceReportEntry.setNettSales(overringTotal);
                overringVarianceCounterbalanceReportEntry.setAllocationMemoPrefix("Overring Total (Income)");
                overringVarianceCounterbalanceReportEntry.setTaxCode(TaxCode.getNotTaxable());
                overringVarianceCounterbalanceReportEntry.setReconciliationEntry(true);
                this.getCreditEntry(overringVarianceCounterbalanceReportEntry);
            }
        }
    }

    private void addReconciliationVarianceFor(String allocMemo, GLAccount glCode, GLAccount glCodeCounterBalance, Price variance, AccountingFinanceReport reportEntry, ShiftReconciliation shiftRec) {
        if (!variance.isZero() && (AccountingHelper.isGLCodeSet(glCode) || AccountingHelper.isGLCodeSet(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationVarianceGLCode()))) {
            AccountingFinanceReport varianceReportEntry = reportEntry.getCopy();
            varianceReportEntry.setShowPaymentAndCashdrawer(false);
            varianceReportEntry.setAmount(variance);
            varianceReportEntry.setAmountEx(variance);
            varianceReportEntry.setAllocationMemoPrefix(allocMemo + " (Assets)");
            varianceReportEntry.setGLAccount(glCode != null ? glCode : AccountingExportManager.getInstance().getAccountingSettings().getReconciliationVarianceGLCode());
            varianceReportEntry.setPaymentMethod("");
            varianceReportEntry.setTaxCode(TaxCode.getNotTaxable());
            varianceReportEntry.setReconciliationEntry(true);
            this.getDebitEntry(varianceReportEntry);
            if (AccountingHelper.isGLCodeSet(glCodeCounterBalance) || AccountingHelper.isGLCodeSet(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationVarianceCounterbalanceGLCode())) {
                AccountingSalesReport varianceCounterbalanceReportEntry = AccountingSalesReport.generateBlankReport(shiftRec.getShift());
                varianceCounterbalanceReportEntry.setGLAccount(glCodeCounterBalance != null ? glCodeCounterBalance : AccountingExportManager.getInstance().getAccountingSettings().getReconciliationVarianceCounterbalanceGLCode());
                varianceCounterbalanceReportEntry.setNettSales(variance);
                varianceCounterbalanceReportEntry.setAllocationMemoPrefix(allocMemo + " (Income)");
                varianceCounterbalanceReportEntry.setTaxCode(TaxCode.getNotTaxable());
                varianceCounterbalanceReportEntry.setReconciliationEntry(true);
                this.getCreditEntry(varianceCounterbalanceReportEntry);
            }
        }
    }

    private void addReconciliationVarianceByTypeIfRequired(AccountingFinanceReport reportEntry, ShiftReconciliation shiftRec) {
        this.addReconciliationVarianceFor("Reconciliation Cash Variance", AccountingExportManager.getInstance().getAccountingSettings().getReconciliationCashVarianceGLCode(), AccountingExportManager.getInstance().getAccountingSettings().getReconciliationCashVarianceCounterbalanceGLCode(), shiftRec.getTotalCashVariance(), reportEntry, shiftRec);
        this.addReconciliationVarianceFor("Reconciliation Credit Variance", AccountingExportManager.getInstance().getAccountingSettings().getReconciliationCreditVarianceGLCode(), AccountingExportManager.getInstance().getAccountingSettings().getReconciliationCreditVarianceCounterbalanceGLCode(), shiftRec.getTotalCreditVariance(), reportEntry, shiftRec);
        this.addReconciliationVarianceFor("Reconciliation Web Variance", AccountingExportManager.getInstance().getAccountingSettings().getReconciliationWebVarianceGLCode(), AccountingExportManager.getInstance().getAccountingSettings().getReconciliationWebVarianceCounterbalanceGLCode(), shiftRec.getTotalWebVariance(), reportEntry, shiftRec);
        this.addReconciliationVarianceFor("Reconciliation Cash Out Variance", AccountingExportManager.getInstance().getAccountingSettings().getReconciliationCashOutVarianceGLCode(), AccountingExportManager.getInstance().getAccountingSettings().getReconciliationCashOutVarianceCounterbalanceGLCode(), shiftRec.getTotalCashOutVariance(), reportEntry, shiftRec);
    }

    private void addPettyCash(AccountingFinanceReport reportEntry, ShiftReconciliation shiftRec) {
        if (AccountingHelper.isGLCodeSet(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationPettyCashGLCode())) {
            Price totalPettyCash = Price.ZERO_DOLLAR;
            for (CashdrawerReconciliation cashRec : shiftRec.getCashDrawerReconciliations()) {
                totalPettyCash = totalPettyCash.add(cashRec.getPettyCashTotal());
            }
            AccountingFinanceReport pettyCashReportEntry = reportEntry.getCopy();
            pettyCashReportEntry.setShowPaymentAndCashdrawer(false);
            pettyCashReportEntry.setAmount(totalPettyCash);
            pettyCashReportEntry.setAmountEx(totalPettyCash);
            pettyCashReportEntry.setAllocationMemoPrefix("Petty Cash");
            pettyCashReportEntry.setGLAccount(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationPettyCashGLCode());
            pettyCashReportEntry.setPaymentMethod("");
            pettyCashReportEntry.setTaxCode(TaxCode.getNotTaxable());
            pettyCashReportEntry.setReconciliationEntry(true);
            this.addReport(pettyCashReportEntry);
            if (AccountingHelper.isGLCodeSet(AccountingExportManager.getInstance().getAccountingSettings().getReconciliationPettyCashCounterbalanceGLCode())) {
                GLAccount pettyCashCounter = AccountingExportManager.getInstance().getAccountingSettings().getReconciliationPettyCashCounterbalanceGLCode();
                AccountingReport protoType = this.getExistingAccountingReport(pettyCashCounter, reportEntry.getShift(), reportEntry.getTaxCode());
                ExperimentalFeature pettyCashToOtherGL = ExperimentalFeature.find("Petty Cash Counter to Cash");
                boolean doAsFinance = pettyCashToOtherGL != null && Boolean.TRUE.equals(pettyCashToOtherGL.getBooleanValue(Boolean.FALSE));
                boolean bl = doAsFinance = doAsFinance && protoType != null && protoType instanceof AccountingFinanceReport;
                if (!doAsFinance) {
                    AccountingSalesReport pettyCashCounterBalanceEntry = AccountingSalesReport.generateBlankReport(shiftRec.getShift());
                    pettyCashCounterBalanceEntry.setGLAccount(pettyCashCounter);
                    pettyCashCounterBalanceEntry.setNettSales(totalPettyCash);
                    pettyCashCounterBalanceEntry.setAllocationMemoPrefix("Petty Cash Counterbalance");
                    pettyCashCounterBalanceEntry.setTaxCode(TaxCode.getNotTaxable());
                    pettyCashCounterBalanceEntry.setReconciliationEntry(true);
                    this.addReport(pettyCashCounterBalanceEntry);
                } else {
                    AccountingFinanceReport pettyCashCounterBalanceEntry = AccountingFinanceReport.generateBlankReport(shiftRec.getShift());
                    pettyCashCounterBalanceEntry.setGLAccount(pettyCashCounter);
                    pettyCashCounterBalanceEntry.setAmount(totalPettyCash.negate());
                    pettyCashCounterBalanceEntry.setAmountEx(totalPettyCash.negate());
                    pettyCashCounterBalanceEntry.setAllocationMemoPrefix("Petty Cash Counterbalance");
                    pettyCashCounterBalanceEntry.setTaxCode(TaxCode.getNotTaxable());
                    pettyCashCounterBalanceEntry.setReconciliationEntry(true);
                    this.addReport(pettyCashCounterBalanceEntry);
                }
            }
        }
    }

    private Comparator<AccountingReport> getComparator() {
        Comparator<AccountingReport> comparator = new Comparator<AccountingReport>(){

            @Override
            public int compare(AccountingReport o1, AccountingReport o2) {
                if (o1.getRecordID() < o2.getRecordID()) {
                    return -1;
                }
                if (o1.getRecordID() > o2.getRecordID()) {
                    return 1;
                }
                return 0;
            }
        };
        return comparator;
    }

    private void sortReportEntries(Comparator<AccountingReport> comp) {
        Collections.sort(this.salesReportCreditEntries, comp);
        Collections.sort(this.financeReportDebitEntries, comp);
    }

    private AccountingReport getCurrentCreditObject() {
        return this.salesReportCreditEntries.size() == this.creditIndex ? null : (AccountingReport)this.salesReportCreditEntries.get(this.creditIndex);
    }

    private AccountingReport getCurrentDebitObject() {
        return this.financeReportDebitEntries.get(this.debitIndex);
    }

    public boolean hasData() {
        return this.salesReportCreditEntries != null && this.financeReportDebitEntries != null && (this.salesReportCreditEntries.size() != 0 || this.financeReportDebitEntries.size() != 0);
    }

    public boolean isBalanced() {
        return this.salesReportCreditEntries.size() != 0 && this.financeReportDebitEntries.size() != 0;
    }

    public List<AccountingSalesReport> getSalesReports() {
        return new ArrayList<AccountingSalesReport>(this.salesReportCreditEntries);
    }

    public List<AccountingFinanceReport> getFinanceReports() {
        return new ArrayList<AccountingFinanceReport>(this.financeReportDebitEntries);
    }

    protected List<AccountingSalesReport> getCreditEntries() {
        return this.salesReportCreditEntries;
    }

    protected void setCreditEntries(List<AccountingSalesReport> creditEntries) {
        this.salesReportCreditEntries = creditEntries;
    }

    protected List<AccountingFinanceReport> getDebitEntries() {
        return this.financeReportDebitEntries;
    }

    protected void setDebitEntries(List<AccountingFinanceReport> debitEntries) {
        this.financeReportDebitEntries = debitEntries;
    }

    protected Map<Long, AccountingDebtorReport> getDebtorEntries() {
        return this.debtorReport;
    }

    protected void setDebtorEntries(HashMap<Long, AccountingDebtorReport> debtorMap) {
        this.debtorReport = debtorMap;
    }

    private boolean isExperimentalFeatureActive() {
        ExperimentalFeature feature = ExperimentalFeature.find(EXP_FEAT_ADJUSTMENTS_NO_TAX);
        return feature != null && feature.getBooleanValue(Boolean.FALSE) != false;
    }
}

