/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.common;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.reports.stock.StockAreaReport;
import ordermate.database.stock.StockSupplier;
import ordermate.integration.finance.common.ShiftLineWrapper;
import ordermate.integration.finance.common.StockMovementWrapper;
import ordermate.integration.finance.common.StockOrderWrapper;
import ordermate.integration.jaxb.webservice.accounting.AccountExportList;
import ordermate.integration.jaxb.webservice.accounting.StockReport;
import ordermate.integration.jaxb.webservice.accounting.Supplier;
import ordermate.jaxb.exporter.XMLHelper;
import ordermate.reports.accounting.InvoiceReport;

public enum AccountingConverter {
    INSTANCE;


    public AccountExportList transformSuppliers(List<StockSupplier> supplierList) {
        AccountExportList acctExportList = new AccountExportList();
        for (StockSupplier stockSupplier : supplierList) {
            acctExportList.getStockSuppliers().add(this.transform(stockSupplier));
        }
        return acctExportList;
    }

    private Supplier transform(StockSupplier input) {
        Supplier supplier = new Supplier();
        supplier.setName(input.getName());
        supplier.setAccountNumber(input.getAccountNumber());
        supplier.setAddress1(input.getAddress1());
        supplier.setAddress2(input.getAddress2());
        supplier.setEmail(input.getEmail());
        supplier.setPhone(input.getPhone());
        supplier.setFax(input.getFax());
        supplier.setOmId(input.getID());
        supplier.setUpdateDate(XMLHelper.getDateType(input.getUpdateDate()));
        supplier.setSystemState("DELETED".equals(input.getSystemState()) ? Integer.valueOf(0) : Integer.valueOf(1));
        return supplier;
    }

    public AccountExportList transformSalesAndFinance(List<AccountingReport> reportList) {
        ShiftLineWrapper shiftLineWrapper;
        AccountExportList acctExportList = new AccountExportList();
        if (reportList != null && !reportList.isEmpty() && !(shiftLineWrapper = new ShiftLineWrapper(reportList)).getShiftLineItems().isEmpty()) {
            acctExportList.getShiftLineItems().addAll(shiftLineWrapper.getShiftLineItems());
        }
        return acctExportList;
    }

    public AccountExportList transformInvoices(List<? extends InvoiceReport> reportList) {
        StockOrderWrapper orderWrapper;
        AccountExportList acctExportList = new AccountExportList();
        if (reportList != null && !reportList.isEmpty() && !(orderWrapper = new StockOrderWrapper(reportList)).getStockOrders().isEmpty()) {
            acctExportList.getStockOrders().addAll(orderWrapper.getStockOrders());
        }
        return acctExportList;
    }

    public AccountExportList transformStockMovements(List<PeriodStockAreaReportItem> reportList, Date dateOfLastStockTake) {
        StockMovementWrapper movementWrapper;
        AccountExportList acctExportList = new AccountExportList();
        if (reportList != null && !reportList.isEmpty() && !(movementWrapper = new StockMovementWrapper(reportList, dateOfLastStockTake)).getStockMovements().isEmpty()) {
            acctExportList.getStockMovements().addAll(movementWrapper.getStockMovements());
        }
        return acctExportList;
    }

    public AccountExportList transformStockAreaReport(List<StockAreaReport> areaReports) {
        AccountExportList acctExportList = new AccountExportList();
        if (areaReports != null) {
            for (StockAreaReport report : areaReports) {
                acctExportList.getStockReports().add(this.transform(report));
            }
        }
        return acctExportList;
    }

    private StockReport transform(StockAreaReport input) {
        StockReport report = new StockReport();
        report.setStockArea(input.getStockArea());
        report.setCogs(input.getCogs() != null ? input.getCogs().toBigDecimal() : BigDecimal.ZERO);
        return report;
    }
}

