/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.common;

import au.com.ordermate.persistence.PersistenceManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.queries.stock.StockAreaQueries;
import ordermate.database.queries.stock.StockSupplierQueries;
import ordermate.database.queries.stock.StockTakeQueries;
import ordermate.database.reports.periodstock.PeriodStockAreaReportCreator;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.reports.stock.StockAreaReport;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.StockTake;
import ordermate.integration.finance.SalesAndFinanceReport;
import ordermate.integration.finance.common.AccountExportInput;
import ordermate.integration.finance.common.AccountingConverter;
import ordermate.integration.finance.common.AccountingExportStrategy;
import ordermate.integration.jaxb.webservice.accounting.AccountExportList;
import ordermate.integration.jaxb.webservice.accounting.AccountExportType;
import ordermate.jaxb.exporter.XMLHelper;
import ordermate.reports.accounting.InvoiceReport;

public enum AccountingWebExport implements AccountingExportStrategy
{
    SHIFT_LINE_ITEM{

        @Override
        public AccountExportList getAccountExportList(AccountExportInput input) {
            AccountExportList exportList = new AccountExportList();
            SalesAndFinanceReport report = new SalesAndFinanceReport(input.getFrom(), input.getTo());
            if (this.isReportTransformable(input, report)) {
                exportList = AccountingConverter.INSTANCE.transformSalesAndFinance(report.generateReport());
                AccountingWebExport.setExportListHeader(exportList, AccountExportType.SHIFT_LINE_ITEM, input);
            }
            return exportList;
        }

        private boolean isReportTransformable(AccountExportInput input, SalesAndFinanceReport report) {
            if (report == null) {
                return false;
            }
            if (!report.isBalanced()) {
                throw new IllegalStateException("Unbalanced finance and sales date.  List should both contain elements Sales Report size: " + report.getSalesReports().size() + ", Finance report size: " + report.getFinanceReports().size());
            }
            return true;
        }
    }
    ,
    STOCK_MOVEMENT{

        @Override
        public AccountExportList getAccountExportList(AccountExportInput input) {
            AccountExportList exportList = new AccountExportList();
            StockTake firstTake = PersistenceManager.getObject(StockTake.class, StockTakeQueries.getFirstCompletedStockTake(input.getFrom()).toString());
            StockTake lastTake = PersistenceManager.getObject(StockTake.class, StockTakeQueries.getLastCompletedStockTake(input.getTo()).toString());
            if (firstTake != null) {
                PeriodStockAreaReportCreator creator;
                List<PeriodStockAreaReportItem> reports;
                if (lastTake != null && !firstTake.equals(lastTake) && (reports = (creator = new PeriodStockAreaReportCreator()).createAndCompileReports(firstTake, lastTake)) != null) {
                    exportList = AccountingConverter.INSTANCE.transformStockMovements(new ArrayList<PeriodStockAreaReportItem>(reports), lastTake.getDate());
                }
            } else {
                throw new IllegalStateException("There should be at least one completed stock take greater than the given date: " + input.getFrom());
            }
            AccountingWebExport.setExportListHeader(exportList, AccountExportType.STOCK_MOVEMENT, input);
            return exportList;
        }
    }
    ,
    ORDER{

        @Override
        public AccountExportList getAccountExportList(AccountExportInput input) {
            AccountExportList exportList = new AccountExportList();
            InvoiceReport report = new InvoiceReport(input.getFrom(), input.getTo());
            List<? extends InvoiceReport> reportList = report.generateReport(false, false, false, false, input.getTypes());
            if (reportList != null) {
                exportList = AccountingConverter.INSTANCE.transformInvoices(reportList);
                AccountingWebExport.setExportListHeader(exportList, AccountExportType.ORDER, input);
            }
            return exportList;
        }
    }
    ,
    SUPPLIER{

        @Override
        public AccountExportList getAccountExportList(AccountExportInput input) {
            AccountExportList exportList = new AccountExportList();
            List<StockSupplier> supplierList = PersistenceManager.getObjectList(StockSupplier.class, StockSupplierQueries.getChangedSuppliers(input.getFrom()).toString());
            if (supplierList != null) {
                exportList = AccountingConverter.INSTANCE.transformSuppliers(supplierList);
                AccountingWebExport.setExportListHeader(exportList, AccountExportType.SUPPLIER, input);
            }
            return exportList;
        }
    }
    ,
    CUSTOMER{

        @Override
        public AccountExportList getAccountExportList(AccountExportInput input) {
            throw new UnsupportedOperationException("Customer export is not supported!");
        }
    }
    ,
    STOCK_REPORT{

        @Override
        public AccountExportList getAccountExportList(AccountExportInput input) {
            AccountExportList exportList = new AccountExportList();
            List<StockAreaReport> reports = StockAreaQueries.getStockAreaReports(new Timestamp(input.getFrom().getTime()), new Timestamp(input.getTo().getTime()));
            if (reports != null) {
                exportList = AccountingConverter.INSTANCE.transformStockAreaReport(reports);
            }
            AccountingWebExport.setExportListHeader(exportList, AccountExportType.STOCK_REPORT, input);
            return exportList;
        }
    };


    private static void setExportListHeader(AccountExportList exportList, AccountExportType exportType, AccountExportInput input) {
        exportList.setExportType(exportType);
        exportList.setFromDate(XMLHelper.getDateType(input.getFrom()));
        exportList.setToDate(XMLHelper.getDateType(input.getTo() != null ? input.getTo() : new Date()));
    }
}

