/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.common;

import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.misc.TradingDay;

public final class ShiftLineKey {
    private final Shift shift;
    private final TradingDay tradingDay;
    private final SalesLocation salesLocation;

    private ShiftLineKey(ShiftLineKeyBuilder builder) {
        this.shift = builder.shift;
        this.tradingDay = builder.tradingDay;
        this.salesLocation = builder.salesLocation;
    }

    public Shift getShift() {
        return this.shift;
    }

    public TradingDay getTradingDay() {
        return this.tradingDay;
    }

    public SalesLocation getSalesLocation() {
        return this.salesLocation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.shift == null ? 0 : this.shift.hashCode());
        result = 31 * result + (this.tradingDay == null ? 0 : this.tradingDay.hashCode());
        result = 31 * result + (this.salesLocation == null ? 0 : this.salesLocation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShiftLineKey other = (ShiftLineKey)obj;
        if (this.shift == null ? other.shift != null : !this.shift.equals(other.shift)) {
            return false;
        }
        if (this.tradingDay == null ? other.tradingDay != null : !this.tradingDay.equals(other.tradingDay)) {
            return false;
        }
        return !(this.salesLocation == null ? other.salesLocation != null : !this.salesLocation.equals(other.salesLocation));
    }

    public static class ShiftLineKeyBuilder {
        private final Shift shift;
        private final TradingDay tradingDay;
        private final SalesLocation salesLocation;

        public ShiftLineKeyBuilder(Shift shiftValue, TradingDay day, SalesLocation location) {
            this.shift = shiftValue;
            this.tradingDay = day;
            this.salesLocation = location;
        }

        public ShiftLineKey build() {
            return new ShiftLineKey(this);
        }
    }
}

