/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.common;

import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.integration.accounting.reports.AccountingDebtorReport;
import ordermate.database.integration.accounting.reports.AccountingFinanceReport;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.reports.AccountingSalesReport;
import ordermate.integration.finance.common.ShiftLineKey;
import ordermate.integration.jaxb.webservice.accounting.GlLineItem;
import ordermate.integration.jaxb.webservice.accounting.GlLineType;
import ordermate.integration.jaxb.webservice.accounting.ShiftLineItem;
import ordermate.jaxb.exporter.XMLHelper;

public class ShiftLineWrapper {
    private Map<ShiftLineKey, ShiftLineItem> shiftLineMap = new HashMap<ShiftLineKey, ShiftLineItem>();

    public ShiftLineWrapper(List<AccountingReport> reportList) {
        for (AccountingReport report : reportList) {
            this.addSalesAndFinanceReport(report);
        }
    }

    public List<ShiftLineItem> getShiftLineItems() {
        return new ArrayList<ShiftLineItem>(this.shiftLineMap.values());
    }

    private void addSalesAndFinanceReport(AccountingReport report) {
        if (report instanceof AccountingFinanceReport) {
            this.addFinanceReport((AccountingFinanceReport)report);
        } else if (report instanceof AccountingSalesReport) {
            this.addSalesReport((AccountingSalesReport)report);
        } else {
            if (report instanceof AccountingDebtorReport) {
                throw new IllegalArgumentException("Do we really get AccountingDebtorReport instance???");
            }
            OrderMate.LOG.error("Error exporting sales & finance report object, invalid report type: " + report);
        }
    }

    private void addFinanceReport(AccountingFinanceReport report) {
        if (report.getAmount() == null || report.getAmount().equals(Price.ZERO_DOLLAR)) {
            return;
        }
        ShiftLineItem shiftLineItem = this.getShiftLineItem(report);
        GlLineItem lineItem = new GlLineItem();
        lineItem.setValue(report.getAmount() != null ? report.getAmount().toBigDecimal() : BigDecimal.ZERO);
        lineItem.setTax(report.getTaxAmount() != null ? report.getTaxAmount().toBigDecimal() : BigDecimal.ZERO);
        lineItem.setTaxCode(report.getTaxCode().getLabel());
        lineItem.setGl(report.getGlAccountCode());
        lineItem.setGlLineType(GlLineType.DEBIT);
        lineItem.setCashDrawer(report.getCashDrawerName());
        lineItem.setPaymentMethod(report.getPaymentMethod());
        lineItem.setUnitType(report.getUnitType());
        lineItem.setDescription(report.getAllocationMemo());
        shiftLineItem.getGlLineItems().add(lineItem);
    }

    private void addSalesReport(AccountingSalesReport report) {
        if (report.getNettSales() == null || report.getNettSales().equals(Price.ZERO_DOLLAR)) {
            return;
        }
        ShiftLineItem shiftLineItem = this.getShiftLineItem(report);
        GlLineItem lineItem = new GlLineItem();
        lineItem.setValue(report.getNettSales() != null ? report.getNettSales().toBigDecimal() : BigDecimal.ZERO);
        lineItem.setTax(report.getTaxAmount() != null ? report.getTaxAmount().toBigDecimal() : BigDecimal.ZERO);
        lineItem.setTaxCode(report.getTaxCode().getLabel());
        lineItem.setGl(report.getGlAccountCode());
        lineItem.setGlLineType(GlLineType.CREDIT);
        lineItem.setDescription(report.getAllocationMemo());
        shiftLineItem.getGlLineItems().add(lineItem);
    }

    private ShiftLineItem getShiftLineItem(AccountingReport report) {
        ShiftLineKey shiftLineKey = this.getShiftLineKey(report);
        ShiftLineItem shiftLineItem = this.shiftLineMap.get(shiftLineKey);
        if (shiftLineItem == null) {
            shiftLineItem = this.getNewShiftLineItem(shiftLineKey);
            this.shiftLineMap.put(shiftLineKey, shiftLineItem);
        }
        return shiftLineItem;
    }

    private ShiftLineKey getShiftLineKey(AccountingReport report) {
        if (report instanceof AccountingFinanceReport) {
            AccountingFinanceReport financeReport = (AccountingFinanceReport)report;
            return new ShiftLineKey.ShiftLineKeyBuilder(financeReport.getShift(), financeReport.getTradingDay(), financeReport.getSalesLocation()).build();
        }
        if (report instanceof AccountingSalesReport) {
            AccountingSalesReport salesReport = (AccountingSalesReport)report;
            return new ShiftLineKey.ShiftLineKeyBuilder(salesReport.getShift(), salesReport.getTradingDay(), salesReport.getSalesLocation()).build();
        }
        throw new IllegalArgumentException("SalesFinanceMapper#getShiftLineKey: Accounting report type is INVALID! " + report);
    }

    private ShiftLineItem getNewShiftLineItem(ShiftLineKey lineKey) {
        ShiftLineItem shiftLine = new ShiftLineItem();
        shiftLine.setShiftId(lineKey.getShift().getID());
        shiftLine.setShiftName(lineKey.getShift().getName());
        shiftLine.setTradingDay(XMLHelper.getDateType(lineKey.getTradingDay().getDate()));
        shiftLine.setLocation(this.getTerminalLocationText(lineKey));
        return shiftLine;
    }

    private String getTerminalLocationText(ShiftLineKey lineKey) {
        if (lineKey.getSalesLocation() != null) {
            return lineKey.getSalesLocation().getLabelNoFormat();
        }
        if (TerminalLocation.getDefaultLocation() != null) {
            return TerminalLocation.getDefaultLocation().getLabelNoFormat();
        }
        return "";
    }
}

