/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.common;

import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.stock.StockArea;
import ordermate.integration.jaxb.webservice.accounting.GlLineItem;
import ordermate.integration.jaxb.webservice.accounting.StockMovement;
import ordermate.jaxb.exporter.XMLHelper;
import ordermate.reports.accounting.GLType;

public class StockMovementWrapper {
    private Map<StockArea, StockMovement> movementsMap = new HashMap<StockArea, StockMovement>();
    private final Date lastStockTakeDate;

    public StockMovementWrapper(List<PeriodStockAreaReportItem> reportList, Date dateOfLastStockTake) {
        if (dateOfLastStockTake == null) {
            throw new IllegalArgumentException("The date of last stocktake should not be empty!");
        }
        this.lastStockTakeDate = dateOfLastStockTake;
        for (PeriodStockAreaReportItem report : reportList) {
            this.addStockMovement(report);
        }
    }

    public List<StockMovement> getStockMovements() {
        return new ArrayList<StockMovement>(this.movementsMap.values());
    }

    private void addStockMovement(PeriodStockAreaReportItem report) {
        StockMovement stockMovement = this.getStockMovement(report);
        this.addCOGsGL(report, stockMovement);
        this.addTransferGL(report, stockMovement);
        this.addWastageGL(report, stockMovement);
        this.addAdjustmentGL(report, stockMovement);
    }

    private void addWastageGL(PeriodStockAreaReportItem report, StockMovement stockMovement) {
        if (report.getWastage() != null && !report.getWastage().equals(Price.ZERO_DOLLAR)) {
            GLAccount glAccount = report.getArea().getGLAccountByType(GLType.Wastage);
            if (glAccount == null) {
                glAccount = BaseAccountingConfiguration.getInstance().getDefaultStockWastageGLCode();
            }
            stockMovement.getGlLineItems().add(this.getGlLineItem(GLType.Wastage, report.getWastage().toBigDecimal(), glAccount.getGlCode()));
        }
    }

    private void addTransferGL(PeriodStockAreaReportItem report, StockMovement stockMovement) {
        if (report.getTransfers() != null && !report.getTransfers().equals(Price.ZERO_DOLLAR)) {
            GLAccount glAccount = report.getArea().getGLAccountByType(GLType.Transfer);
            if (glAccount == null) {
                glAccount = BaseAccountingConfiguration.getInstance().getDefaultStockTransferGLCode();
            }
            stockMovement.getGlLineItems().add(this.getGlLineItem(GLType.Transfer, report.getTransfers().toBigDecimal(), glAccount.getGlCode()));
        }
    }

    private void addAdjustmentGL(PeriodStockAreaReportItem report, StockMovement stockMovement) {
        if (report.getAdjustments() != null && !report.getAdjustments().equals(Price.ZERO_DOLLAR)) {
            GLAccount glAccount = report.getArea().getGLAccountByType(GLType.Adjustment);
            if (glAccount == null) {
                glAccount = BaseAccountingConfiguration.getInstance().getDefaultStockAdjustmentGLCode();
            }
            stockMovement.getGlLineItems().add(this.getGlLineItem(GLType.Adjustment, report.getAdjustments().toBigDecimal(), glAccount.getGlCode()));
        }
    }

    private void addCOGsGL(PeriodStockAreaReportItem report, StockMovement stockMovement) {
        if (report.getCoGs() != null && !report.getCoGs().equals(Price.ZERO_DOLLAR)) {
            GLAccount glAccount = report.getArea().getGLAccountByType(GLType.COGS);
            if (glAccount == null) {
                glAccount = BaseAccountingConfiguration.getInstance().getDefaultStockCOGsGLCode();
            }
            stockMovement.getGlLineItems().add(this.getGlLineItem(GLType.COGS, report.getCoGs().toBigDecimal(), glAccount.getGlCode()));
        }
    }

    private GlLineItem getGlLineItem(GLType glType, BigDecimal amount, String glCode) {
        GlLineItem lineItem = new GlLineItem();
        lineItem.setGl(glCode);
        lineItem.setValue(amount);
        lineItem.setDescription(glType.toString());
        return lineItem;
    }

    private StockMovement getStockMovement(PeriodStockAreaReportItem report) {
        StockMovement movement = this.movementsMap.get(report.getArea());
        if (movement == null) {
            movement = this.getNewStockMovement(report);
            this.movementsMap.put(report.getArea(), movement);
        }
        return movement;
    }

    private StockMovement getNewStockMovement(PeriodStockAreaReportItem report) {
        StockMovement movement = new StockMovement();
        movement.setStockArea(report.getStockAreaLabel());
        movement.setStocktakeDate(XMLHelper.getDateType(this.lastStockTakeDate));
        movement.setOpeningStock(report.getOpeningStock().toBigDecimal());
        movement.setClosingStock(report.getClosingStock().toBigDecimal());
        return movement;
    }
}

