/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.integration.jaxb.webservice.accounting.StockOrder;
import ordermate.integration.jaxb.webservice.accounting.StockOrderItem;
import ordermate.integration.jaxb.webservice.accounting.StockOrderType;
import ordermate.jaxb.exporter.XMLHelper;
import ordermate.reports.accounting.InvoiceReport;

public class StockOrderWrapper {
    private Map<Long, StockOrder> ordersMap = new HashMap<Long, StockOrder>();

    public StockOrderWrapper(List<? extends InvoiceReport> reportList) {
        for (InvoiceReport invoiceReport : reportList) {
            this.addInvoice(invoiceReport);
        }
    }

    public List<StockOrder> getStockOrders() {
        return new ArrayList<StockOrder>(this.ordersMap.values());
    }

    private void addInvoice(InvoiceReport report) {
        StockOrder stockOrder = this.getStockOrder(report);
        StockOrderItem orderItem = new StockOrderItem();
        orderItem.setValue(report.getItemAmount().toBigDecimal());
        orderItem.setTax(report.getItemTax().toBigDecimal());
        orderItem.setGl(report.getGlAccountCode());
        orderItem.setName(report.getStockItemName());
        orderItem.setQty(BigDecimal.valueOf(report.getNumReceived()));
        orderItem.setBonusQty(BigDecimal.valueOf(report.getBonusReceived()));
        orderItem.setStockGroup(report.getStockGroup().getName());
        stockOrder.getStockOrderItems().add(orderItem);
    }

    private StockOrder getStockOrder(InvoiceReport report) {
        Long invoiceId = report.getInvoiceId();
        StockOrder order = this.ordersMap.get(invoiceId);
        if (order == null) {
            order = this.getNewStockOrder(report);
            this.ordersMap.put(invoiceId, order);
        }
        return order;
    }

    private StockOrder getNewStockOrder(InvoiceReport report) {
        StockOrder order = new StockOrder();
        order.setSupplierId(report.getStockSupplier() != null ? report.getStockSupplier().getID() : 0L);
        order.setSupplierName(report.getSupplierName());
        order.setInvoiceNumber(report.getSupplierInvoiceNumber());
        order.setOmId(report.getInvoiceId());
        order.setOrderNumber(report.getOrderNumber());
        order.setStockArea(report.getStockArea().getLabel());
        order.setOrderType(this.getOrderType(report.getInvoiceType()));
        order.setInvoiceDate(XMLHelper.getDateType(report.getInvoiceDate()));
        order.setDiscount(report.getDiscountAmount() != null ? report.getDiscountAmount().toBigDecimal() : BigDecimal.ZERO);
        order.setAdminCost(report.getAdminCostAmount() != null ? report.getAdminCostAmount().toBigDecimal() : BigDecimal.ZERO);
        order.setFreightCost(report.getFreightAmount() != null ? report.getFreightAmount().toBigDecimal() : BigDecimal.ZERO);
        return order;
    }

    private StockOrderType getOrderType(String invoiceType) {
        if ("Purchase Order".equals(invoiceType)) {
            return StockOrderType.PURCHASE;
        }
        if ("Credit Note".equals(invoiceType)) {
            return StockOrderType.CREDIT;
        }
        if ("Invoice".equals(invoiceType)) {
            return StockOrderType.INVOICE;
        }
        if ("Delivery Note".equals(invoiceType)) {
            return StockOrderType.DELIVERY;
        }
        throw new IllegalArgumentException("Invalid invoice type! " + invoiceType);
    }
}

