/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.myob;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.Price;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.OfficeMateEventLog;
import ordermate.database.queries.finance.debtors.DebtorQueries;
import ordermate.database.users.User;
import ordermate.integration.csv.CSVExporter;
import ordermate.integration.finance.myob.mapping.DebtorSalesMYOBServiceSalesMapping;
import ordermate.maps.finance.debtors.DebtorSaleMap;

public class Export {
    private static IOException thrownException = null;

    public static void exportCustomerAccount(String filename, User user, List<AbstractDebtor> debtors, AbstractDebtor customer, DebtorGroup forGroup, Date from, Date to, GuiHandler guiHandler) {
        List<DebtorSale> debtorSales;
        DebtorSalesMYOBServiceSalesMapping mapping;
        CSVExporter integrator;
        List<AbstractDebtor> debtorsToExport = debtors;
        if (debtors == null || debtors.size() < 1) {
            debtorsToExport = new ArrayList<AbstractDebtor>();
            if (customer != null) {
                debtorsToExport.add(customer);
            } else if (forGroup != null) {
                debtorsToExport.addAll(forGroup.getDebtors());
            } else {
                debtorsToExport = DebtorQueries.getAllCustomerAccountDebtors();
            }
        }
        if (debtorsToExport.size() == 0) {
            if (guiHandler != null) {
                guiHandler.displayOkDialog("No debtors to export", "There are no debtors in the current selection to export");
            } else {
                throw new IllegalArgumentException("No debtors to export: " + debtorsToExport.size());
            }
        }
        if ((integrator = new CSVExporter(mapping = DebtorSalesMYOBServiceSalesMapping.createDebtorSalesMYOBServiceSalesMapping(debtorSales = DebtorSaleMap.getSalesBetweenDatesForDebtors(from, to, debtorsToExport)))).createExportFile(filename)) {
            Iterator<DebtorSale> it = debtorSales.iterator();
            HashMap salesMap = new HashMap();
            while (it.hasNext()) {
                DebtorSale currentSale = it.next();
                if (!salesMap.containsKey(currentSale.getDebtor())) {
                    salesMap.put(currentSale.getDebtor(), new ArrayList());
                }
                ((List)salesMap.get(currentSale.getDebtor())).add(currentSale);
                currentSale.setExported(true);
                currentSale.saveChild();
            }
            for (AbstractDebtor currentDebtor : salesMap.keySet()) {
                Price total = Export.totalSales((List)salesMap.get(currentDebtor));
                DebtorPaymentAgent agent = new DebtorPaymentAgent(currentDebtor, (List)salesMap.get(currentDebtor));
                agent.addExportTransaction(total, new EventContext(Terminal.getServerMateTerminal(), user));
                agent.pay();
                Export.logExport(currentDebtor, total, filename, from, to, user);
            }
        } else if (guiHandler != null) {
            guiHandler.displayOkDialog("Unable to export accounts", "An error occurred when exporting accounts.  No sales have been marked as exported.");
        } else {
            throw new RuntimeException(integrator.getError());
        }
    }

    private static Price totalSales(List<DebtorSale> sales) {
        Price price = Price.ZERO_DOLLAR;
        for (DebtorSale sale : sales) {
            price = price.add(sale.getAmountOutstanding());
        }
        return price;
    }

    private static void logExport(AbstractDebtor debtor, Price pricePaid, String filename, Date from, Date to, User user) {
        if (debtor == null) {
            return;
        }
        DebtorGroup tabGroup = debtor.getGroup();
        Price balance = pricePaid;
        if (balance == null) {
            balance = Price.ZERO_DOLLAR;
        }
        OfficeMateEventLog.logExportCustomerAccounts(user, debtor, balance, filename, from, to, tabGroup);
        StringBuilder SB = new StringBuilder("Customer account data successfully exported into ").append(filename).append(":").append("\nCustomer: ").append(debtor.getLabel()).append("\nTotal: ").append(balance).append("\nFile: \"").append(filename).append("\"").append("\nDate range: ").append(new DateDMY(from)).append(" to ").append(new DateDMY(to)).append("\nAcct group: ").append(tabGroup);
        OrderMate.LOG.info(SB.toString());
    }

    private static String filterForCSV(String field) {
        return "\"" + field.replaceAll("\"", "\"\"") + "\"";
    }

    public static void exportAllCustomers(String filename) throws IOException {
        Object[][] allCustomers = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT 0 AS Spending, config_customer_group.Name, sales_customer.title, sales_customer.first_name, sales_customer.last_name, sales_customer.occupation, sales_customer.company, sales_customer.primary_phone, sales_customer.secondary_phone, sales_customer.email, DAYOFMONTH(sales_customer.dob) AS Dob_Day, MONTH(sales_customer.dob) AS Dob_Month, YEAR(sales_customer.dob) AS Dob_Year, sales_customer.house_number, sales_customer.street_name, sales_customer.street_type, sales_customer.suburb, sales_customer.postcode, sales_customer.state, sales_customer.street_directory_ref, sales_customer_points.total_points, sales_customer.card_id, sales_customer.comments, sales_customer.ID FROM sales_customer \tLEFT JOIN config_customer_group \t\tON sales_customer.FK_config_customer_group = config_customer_group.ID  LEFT JOIN sales_customer_points ON sales_customer_points.fk_sales_customer = sales_customer.id WHERE sales_customer.system_state = 'ACTIVE' ORDER BY sales_customer.last_name, \tsales_customer.first_name, \tsales_customer.ID ", null);
        Object[][] customersWithSpending = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT sales_customer.ID, SUM(sales_component.unit_price * sales_item_quantity.Quantity) AS Spending, sales_customer.last_name, sales_customer.first_name FROM sales_customer, sales_item, sales_component, sales_item_quantity WHERE sales_item.FK_sales_customer = sales_customer.ID AND sales_item_quantity.FK_sales_item = sales_item.ID AND sales_component.FK_sales_item = sales_item.ID AND sales_customer.system_state = 'ACTIVE' GROUP BY sales_customer.ID ORDER BY sales_customer.last_name, sales_customer.first_name, sales_customer.ID ", null);
        String[] fields = new String[]{"Spending", "Group", "Title", "First name", "Last name", "Occupation", "Company", "Primary Phone", "Secondary Phone", "Email Address", "DOB Day", "DOB Month", "DOB Year", "House Number", "Street Name", "Street Type", "Suburb", "Postcode", "State", "Street Directory Ref", "Loyalty Points", "Card ID", "Comments"};
        FileWriter writer = new FileWriter(filename);
        try {
            for (int f = 0; f < fields.length; ++f) {
                if (f != 0) {
                    writer.write(",");
                }
                writer.write(fields[f]);
            }
            writer.write("\r\n");
            int j = 0;
            for (int i = 0; i < allCustomers.length; ++i) {
                int spendingCustomerID;
                Object[] rowFields = allCustomers[i];
                int customerID = ((Number)rowFields[rowFields.length - 1]).intValue();
                if (j < customersWithSpending.length && customerID == (spendingCustomerID = ((Number)customersWithSpending[j][0]).intValue())) {
                    Double cost = (Double)customersWithSpending[j][1];
                    rowFields[0] = cost;
                    ++j;
                }
                for (int f = 0; f < fields.length; ++f) {
                    if (f != 0) {
                        writer.write(",");
                    }
                    String fieldStr = rowFields[f] != null ? rowFields[f].toString() : "";
                    writer.write(Export.filterForCSV(fieldStr));
                }
                writer.write("\r\n");
            }
        }
        catch (IOException e) {
            thrownException = e;
        }
        writer.flush();
        writer.close();
        IOException e = thrownException;
        thrownException = null;
        if (e != null) {
            throw e;
        }
    }
}

