/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.myob;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.GuiHandler;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.formats.DefaultReportFormat;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.stock.StockInvoice;
import ordermate.integration.csv.CSVExporter;
import ordermate.integration.finance.AccountingExportFunction;
import ordermate.integration.finance.AccountingExportParams;
import ordermate.integration.finance.AccountingExporter;
import ordermate.integration.finance.SalesAndFinanceEntryType;
import ordermate.integration.finance.myob.Export;
import ordermate.integration.finance.myob.MYOBReportFormat;
import ordermate.integration.finance.myob.mapping.AccountsSetupMapping;
import ordermate.integration.finance.myob.mapping.DoubleEntryMapping;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.integration.finance.myob.mapping.MYOBMultiTaxSalesAndFinanceMapping;
import ordermate.integration.finance.myob.mapping.PreferredSalesAndFinanceMapping;
import ordermate.integration.finance.myob.mapping.SalesAndFinanceMapping;
import ordermate.integration.finance.myob.mapping.StockInvoiceMYOBServicePurchasesMapping;
import ordermate.reports.accounting.InvoiceReport;

public class MYOBExporter
extends AccountingExporter {
    public MYOBExporter() {
        this(null, null);
    }

    public MYOBExporter(GuiHandler guiHandler, EventContext context) {
        super(guiHandler, context);
    }

    @Override
    protected String exportSalesAndTakings(AccountingExportParams param) {
        DoubleEntryMapping mapping;
        CSVExporter exporter;
        String reason = super.exportSalesAndTakings(param);
        if (reason != null) {
            return reason;
        }
        List<AccountingReport> salesAndFinanceReportList = this.getSalesAndFinanceReport().generateReport();
        if (AccountingIntegrationConfig.getInstance().isExportReconciliationSeparately()) {
            List<AccountingReport> reconciliationReportList = this.getAndStripReconciliationEntries(salesAndFinanceReportList);
            DoubleEntryMapping mapping2 = this.getMappings(reconciliationReportList);
            CSVExporter exporter2 = new CSVExporter(mapping2);
            exporter2.createExportFile(this.getReconciliationFileName(param.getFileName(), param));
        }
        if ((exporter = new CSVExporter(mapping = this.getMappings(salesAndFinanceReportList))).createExportFile(param.getFileName())) {
            return null;
        }
        return "create Export File fails ";
    }

    private DoubleEntryMapping getMappings(List<AccountingReport> salesAndFinanceReportList) {
        ExperimentalFeature feature = ExperimentalFeature.find("MYOB Multi Tax");
        if (feature != null && Boolean.TRUE.equals(feature.getBooleanValue(Boolean.FALSE))) {
            return new MYOBMultiTaxSalesAndFinanceMapping(salesAndFinanceReportList, new MYOBReportFormat());
        }
        if ("V2011+".equals(AccountingIntegrationConfig.getInstance().getApiVersion())) {
            return new PreferredSalesAndFinanceMapping(salesAndFinanceReportList, new DefaultReportFormat());
        }
        return new SalesAndFinanceMapping(salesAndFinanceReportList, new DefaultReportFormat());
    }

    @Override
    protected String exportStockInvoices(AccountingExportParams param) {
        DefaultReportFormat reportFormat;
        InvoiceReport report = new InvoiceReport(param.getStartDate(), param.getEndDate());
        List<? extends InvoiceReport> reportList = report.generateReport((reportFormat = new DefaultReportFormat()).isFreightShownInvoiceReports(), reportFormat.isAdminChargeShownInvoiceReports(), reportFormat.isDiscountReportsShownInvoiceReports(), reportFormat.isInvoiceDiscountNegative(), StockInvoice.getAccountableInvoiceTypes());
        StockInvoiceMYOBServicePurchasesMapping mapping = new StockInvoiceMYOBServicePurchasesMapping(reportList, new DefaultReportFormat());
        CSVExporter exporter = new CSVExporter(mapping);
        if (exporter.createExportFile(param.getFileName())) {
            return null;
        }
        return "create Export File fails ";
    }

    @Override
    public boolean isSetup() {
        return true;
    }

    @Override
    protected ReportFormat createReportFormat() {
        return new MYOBReportFormat();
    }

    @Override
    protected String exportPayRoll(AccountingExportParams param) {
        return "Export PayRoll fails";
    }

    @Override
    protected String exportCustomers(AccountingExportParams param) {
        try {
            Export.exportAllCustomers(param.getFileName());
        }
        catch (Exception ex) {
            String reason = "Error while exporting Customer data.";
            OrderMate.LOG.error(reason, (Throwable)ex);
            return reason;
        }
        return null;
    }

    @Override
    protected String exportAccountSetup(AccountingExportParams param) {
        AccountsSetupMapping mapping = new AccountsSetupMapping(GLAccount.getGLAccounts());
        CSVExporter integrator = new CSVExporter(mapping);
        if (integrator.createExportFile(param.getFileName())) {
            return null;
        }
        return "create Export File fails ";
    }

    @Override
    protected String exportCustomerAccounts(AccountingExportParams param) {
        Export.exportCustomerAccount(param.getFileName(), GuiApp.getAppComplex().getApplicationSecurity().getUser(), param.getDebtorsToExport(), param.getCustomer(), param.getForGroup(), param.getStartDate(), param.getEndDate(), null);
        return null;
    }

    @Override
    public List<AccountingExportFunction> getAccountingExportFunctions() {
        ArrayList<AccountingExportFunction> supportedList = new ArrayList<AccountingExportFunction>();
        supportedList.add(AccountingExportFunction.SALES_AND_TAKINGS);
        supportedList.add(AccountingExportFunction.INVOICES);
        supportedList.add(AccountingExportFunction.ACCOUNT_SETUP);
        supportedList.add(AccountingExportFunction.CUSTOMERS);
        supportedList.add(AccountingExportFunction.CUSTOMER_ACCOUNTS);
        return supportedList;
    }

    @Override
    public FinanceExportStyle getFinanceExportStyle() {
        return FinanceExportStyle.MYOB;
    }

    @Override
    public boolean supportsNegativeEntries() {
        return AccountingIntegrationConfig.getInstance().getApiVersion().equals("V2011+");
    }

    @Override
    public boolean supportsNegativeEntries(SalesAndFinanceEntryType entryType) {
        if (entryType.equals((Object)SalesAndFinanceEntryType.Surcharge) && "V2011+".equals(AccountingIntegrationConfig.getInstance().getApiVersion())) {
            return false;
        }
        return super.supportsNegativeEntries(entryType);
    }
}

