/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.myob.mapping;

import java.util.List;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.exportmapping.SingleEntryMapping;
import ordermate.integration.finance.myob.templates.MYOBAccountsTemplate;

public class AccountsSetupMapping
extends SingleEntryMapping {
    private MYOBAccountsTemplate template;

    public AccountsSetupMapping(List<GLAccount> accountList) {
        super(accountList);
        if (accountList.get(0).getClass() != this.getBusinessObjectClass()) {
            throw new IllegalArgumentException("Account list should contain GLAccounts");
        }
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.template = new MYOBAccountsTemplate();
        this.addMapping(this.template.accountNumber, this.createAccessor("getAccountNumber"));
        this.addMapping(this.template.accountName, this.createAccessor("getAccountName"));
        this.addMapping(this.template.classificationForCashFlow, this.createAccessor("getClassification"));
        this.addMapping(this.template.taxCode, this.createAccessor("getTaxCode"));
        this.addMapping(this.template.accountType, this.createAccessor("getAccountType"));
    }

    @Override
    protected Class getBusinessObjectClass() {
        return GLAccount.class;
    }

    @Override
    protected ExportTemplate getTemplate() {
        return this.template;
    }

    public String getAccountNumber(GLAccount account) {
        return account.getGlCode();
    }

    public String getAccountName(GLAccount account) {
        return account.getName();
    }

    public String getClassification(GLAccount account) {
        return "";
    }

    public String getTaxCode(GLAccount account) {
        return "";
    }

    public String getAccountType(GLAccount account) {
        return account.getType().toString();
    }

    @Override
    protected String getRecordID(Object obj) {
        return this.getAccountNumber((GLAccount)obj);
    }
}

