/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.myob.mapping;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.sales.SalesItem;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.exportmapping.SingleEntryMapping;
import ordermate.integration.finance.AccountingExportManager;
import ordermate.integration.finance.myob.templates.MYOBServiceSalesTemplate;

public class DebtorSalesMYOBServiceSalesMapping
extends SingleEntryMapping {
    MYOBServiceSalesTemplate template;

    public static DebtorSalesMYOBServiceSalesMapping createDebtorSalesMYOBServiceSalesMapping(List debtorSales) {
        ArrayList<DebtorSaleItem> debtorSaleItems = new ArrayList<DebtorSaleItem>();
        for (DebtorSale currentSale : debtorSales) {
            for (SalesItem currentItem : currentSale.getSaleAccount().getItemHelper().getSalesItems()) {
                debtorSaleItems.add(new DebtorSaleItem(currentSale, currentItem));
            }
        }
        return new DebtorSalesMYOBServiceSalesMapping(debtorSaleItems);
    }

    public DebtorSalesMYOBServiceSalesMapping(List debtorSaleItems) {
        super(debtorSaleItems);
    }

    @Override
    protected String getRecordID(Object obj) {
        return this.getInvoiceNumber((DebtorSaleItem)obj);
    }

    @Override
    protected Class getBusinessObjectClass() {
        return DebtorSaleItem.class;
    }

    @Override
    protected ExportTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.template = new MYOBServiceSalesTemplate();
        this.addMapping(this.template.accountNum, this.createAccessor("getAccountNumber"));
        this.addMapping(this.template.lastName, this.createAccessor("getDebtorName"));
        this.addMapping(this.template.invoiceNum, this.createAccessor("getInvoiceNumber"));
        this.addMapping(this.template.date, this.createAccessor("getDate"));
        this.addMapping(this.template.amount, this.createAccessor("getAmountExTax"));
        this.addMapping(this.template.incTaxAmount, this.createAccessor("getAmountIncTax"));
        this.addMapping(this.template.journalMemo, AccountingExportManager.getInstance().getAccountingSettings().getCustomerAccountJournalMemo());
        this.addMapping(this.template.taxCode, this.createAccessor("getTaxCode"));
        this.addMapping(this.template.inclusive, "X");
        this.addMapping(this.template.description, this.createAccessor("getDescription"));
        this.addMapping(this.template.amountPaid, this.createAccessor("getTotalPaid"));
    }

    public String getAccountNumber(DebtorSaleItem item) {
        String glCode = item.getItem().getComponentList().get(0).getInventoryItem().getSafeCategory().getGlAccountCode();
        return glCode;
    }

    public String getDebtorName(DebtorSaleItem item) {
        return item.getDebtorSale().getDebtor().getLabel();
    }

    public String getInvoiceNumber(DebtorSaleItem item) {
        String invoiceNumber = Integer.toString(item.getDebtorSale().getInvoiceNumber());
        if (invoiceNumber.length() > 6) {
            invoiceNumber = invoiceNumber.substring(invoiceNumber.length() - 6);
        }
        return AccountingIntegrationConfig.getInstance().getExportPrefix() + invoiceNumber;
    }

    public Price getAmountExTax(DebtorSaleItem item) {
        SalesItem salesItem = item.getItem();
        return salesItem.getPrice().subtract(salesItem.getTax());
    }

    public Price getAmountIncTax(DebtorSaleItem item) {
        SalesItem salesItem = item.getItem();
        return salesItem.getPrice();
    }

    public String getTaxCode(DebtorSaleItem item) {
        if (item.getItem().getTax().doubleValue() > 0.005) {
            return "GST";
        }
        return "FRE";
    }

    public String getDescription(DebtorSaleItem item) {
        SalesItem salesItem = item.getItem();
        String description = salesItem.getQuantity() + " x " + salesItem.getLabel() + " @ " + salesItem.getPricePerItem();
        return description;
    }

    public Price getTotalPaid(DebtorSaleItem item) {
        return item.getDebtorSale().getSaleAccount().getPaid();
    }

    public Date getDate(DebtorSaleItem item) {
        DebtorSale sale = item.getDebtorSale();
        return sale.getSaleAccount().getCreationDateTime();
    }

    protected static class DebtorSaleItem {
        DebtorSale sale;
        SalesItem item;

        public DebtorSaleItem(DebtorSale newSale, SalesItem newItem) {
            this.sale = newSale;
            this.item = newItem;
        }

        public DebtorSale getDebtorSale() {
            return this.sale;
        }

        public SalesItem getItem() {
            return this.item;
        }
    }
}

