/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.myob.mapping;

import au.com.ordermate.persistence.PropertiedObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.integration.accounting.reports.AccountingFinanceReport;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.exportmapping.ImportExportMapping;

public abstract class DoubleEntryMapping
extends ImportExportMapping {
    private Map debitMap;
    private Map creditMap;
    private List<AccountingReport> reportList;
    private int index = 0;

    protected DoubleEntryMapping(List<AccountingReport> reportList, boolean initialise) {
        super(initialise);
        this.reportList = reportList;
    }

    @Override
    public int size() {
        return this.reportList.size();
    }

    @Override
    protected void initMapping() {
        this.creditMap = new HashMap();
        this.debitMap = new HashMap();
    }

    public void addCreditMapping(ExportTemplate.Field field, PropertiedObject.Property property) {
        this.addMapping(this.creditMap, field, property);
    }

    public void addCreditMapping(ExportTemplate.Field field, Method method) {
        this.addMapping(this.creditMap, field, method);
    }

    public void addCreditMapping(ExportTemplate.Field field, String literal) {
        super.addMapping(this.creditMap, field, literal);
    }

    public void addDebitMapping(ExportTemplate.Field field, PropertiedObject.Property property) {
        this.addMapping(this.debitMap, field, property);
    }

    public void addDebitMapping(ExportTemplate.Field field, Method method) {
        this.addMapping(this.debitMap, field, method);
    }

    public void addDebitMapping(ExportTemplate.Field field, String literal) {
        super.addMapping(this.debitMap, field, literal);
    }

    @Override
    public boolean hasNext() {
        return this.reportList.size() > this.index;
    }

    public List<String[]> next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Mapping does not have next");
        }
        this.checkInitialized();
        ArrayList<String[]> recordList = new ArrayList<String[]>();
        long thisRecordID = this.reportList.get(this.index).getRecordID();
        while (thisRecordID == this.reportList.get(this.index).getRecordID()) {
            AccountingReport report;
            if ((report = this.reportList.get(this.index++)) instanceof AccountingFinanceReport) {
                recordList.addAll(this.getDebitEntry(report));
            } else {
                recordList.addAll(this.getCreditEntry(report));
            }
            if (this.index != this.reportList.size()) continue;
            break;
        }
        return recordList;
    }

    public List<String[]> getDebitEntry(AccountingReport object) {
        ArrayList<String[]> items = new ArrayList<String[]>(1);
        items.add(this.getLineEntry(this.debitMap, object));
        return items;
    }

    public List<String[]> getCreditEntry(AccountingReport object) {
        ArrayList<String[]> items = new ArrayList<String[]>(1);
        items.add(this.getLineEntry(this.creditMap, object));
        return items;
    }

    @Override
    public List getHeader() {
        ArrayList<String> header = new ArrayList<String>(this.getTemplate().getFieldsNumber());
        for (int i = 0; i < this.getTemplate().getFieldsNumber(); ++i) {
            if (this.creditMap.get(this.getTemplate().getField(i)) != null || this.debitMap.get(this.getTemplate().getField(i)) != null) {
                header.add(i, this.getTemplate().getField(i).toString());
                continue;
            }
            header.add(i, new String(""));
        }
        return header;
    }
}

