/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.myob.mapping;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingDebtorReport;
import ordermate.database.integration.accounting.reports.AccountingFinanceReport;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.reports.AccountingSalesReport;
import ordermate.database.integration.accounting.reports.AccountingVoucherReport;
import ordermate.integration.finance.myob.mapping.PreferredSalesAndFinanceMapping;

public class MYOBMultiTaxSalesAndFinanceMapping
extends PreferredSalesAndFinanceMapping {
    public MYOBMultiTaxSalesAndFinanceMapping(List<AccountingReport> allReports, ReportFormat reportFormatter) {
        super(allReports, reportFormatter);
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.addCreditMapping(this.template.amount, this.createAccessor("getAmount"));
        this.addCreditMapping(this.template.taxAmount, "0.00");
        this.addDebitMapping(this.template.amount, this.createAccessor("getAmount"));
        this.addDebitMapping(this.template.taxAmount, "0.00");
    }

    public Price getAmount(AccountingReport report) {
        if (report instanceof AccountingSalesReport) {
            Price value = ((AccountingSalesReport)report).getNettSales();
            if (value == null || value.lessThan(Price.ZERO_DOLLAR)) {
                value = ((AccountingSalesReport)report).getNettSalesNeg();
            }
            return value;
        }
        if (report instanceof AccountingFinanceReport) {
            return ((AccountingFinanceReport)report).getAmount().abs();
        }
        if (report instanceof AccountingDebtorReport) {
            return ((AccountingDebtorReport)report).getTotal().abs();
        }
        if (report instanceof AccountingVoucherReport) {
            return ((AccountingVoucherReport)report).getAmount().abs();
        }
        OrderMate.LOG.warn("Unknown kind of Accounting Report:" + report);
        throw new IllegalArgumentException("Unknown Accounting Report for Credit:" + report);
    }

    @Override
    public String isCredit(AccountingReport report) {
        if (report instanceof AccountingSalesReport) {
            Price amount = report.isReconciliationEntry() ? ((AccountingSalesReport)report).getTotal() : ((AccountingSalesReport)report).getGrossSales();
            return amount.greaterThan(Price.ZERO_DOLLAR) ? "Y" : "N";
        }
        if (report instanceof AccountingFinanceReport) {
            return ((AccountingFinanceReport)report).getAmount().greaterThan(Price.ZERO_DOLLAR) ? "N" : "Y";
        }
        if (report instanceof AccountingDebtorReport) {
            return ((AccountingDebtorReport)report).getTotal().greaterThan(Price.ZERO_DOLLAR) ? "N" : "Y";
        }
        if (report instanceof AccountingVoucherReport) {
            return ((AccountingVoucherReport)report).getAmount().greaterThan(Price.ZERO_DOLLAR) ? "Y" : "N";
        }
        return "N";
    }
}

