/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.myob.mapping;

import au.com.ordermate.util.Price;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingFinanceReport;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.reports.AccountingSalesReport;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.finance.myob.mapping.DoubleEntryMapping;
import ordermate.integration.finance.myob.mapping.FinancePriceFormat;
import ordermate.integration.finance.myob.mapping.FinanceTaxCodeFormat;
import ordermate.integration.finance.myob.templates.MYOBPreferredJournalTemplate;

public class PreferredSalesAndFinanceMapping
extends DoubleEntryMapping {
    protected MYOBPreferredJournalTemplate template;

    public PreferredSalesAndFinanceMapping(List<AccountingReport> allReports, ReportFormat reportFormatter) {
        super(allReports, false);
        this.initMapping();
        this.initialized = true;
        this.checkInitialized();
        FinancePriceFormat priceFormat = new FinancePriceFormat(reportFormatter.getPriceFormat());
        this.setFormat(this.template.amount, priceFormat);
        this.setFormat(this.template.taxAmount, priceFormat);
        this.setFormat(this.template.taxCode, new FinanceTaxCodeFormat());
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.template = new MYOBPreferredJournalTemplate();
        this.addCreditMapping(this.template.journalNumber, this.createAccessor("getJournalNumber"));
        this.addCreditMapping(this.template.date, AccountingSalesReport.Properties.DATE);
        this.addCreditMapping(this.template.memo, this.createAccessor("getMemo"));
        this.addCreditMapping(this.template.gstBasReporting, "S");
        this.addCreditMapping(this.template.inclusive, "1");
        this.addCreditMapping(this.template.accountNumber, this.createAccessor("getGLCode"));
        this.addCreditMapping(this.template.isCredit, this.createAccessor("isCredit"));
        this.addCreditMapping(this.template.amount, AccountingSalesReport.Properties.NETT_SALES_EX);
        this.addCreditMapping(this.template.taxCode, AccountingSalesReport.Properties.TAX_CODE);
        this.addCreditMapping(this.template.taxAmount, AccountingSalesReport.Properties.TAX_AMOUNT);
        this.addCreditMapping(this.template.allocationMemo, this.createAccessor("getAllocationMemo"));
        this.addDebitMapping(this.template.journalNumber, this.createAccessor("getJournalNumber"));
        this.addDebitMapping(this.template.date, AccountingFinanceReport.Properties.DATE);
        this.addDebitMapping(this.template.memo, this.createAccessor("getMemo"));
        this.addDebitMapping(this.template.gstBasReporting, "S");
        this.addDebitMapping(this.template.inclusive, "1");
        this.addDebitMapping(this.template.accountNumber, this.createAccessor("getGLCode"));
        this.addDebitMapping(this.template.isCredit, this.createAccessor("isCredit"));
        this.addDebitMapping(this.template.amount, AccountingFinanceReport.Properties.AMOUNT);
        this.addDebitMapping(this.template.taxCode, this.createAccessor("getTaxCode"));
        this.addDebitMapping(this.template.taxAmount, this.createAccessor("getTaxAmount"));
        this.addDebitMapping(this.template.allocationMemo, this.createAccessor("getAllocationMemo"));
    }

    @Override
    protected ExportTemplate getTemplate() {
        return this.template;
    }

    public String getJournalNumber(AccountingReport obj) {
        return AccountingIntegrationConfig.getInstance().getExportPrefix() + obj.getRecordID();
    }

    public String getMemo(AccountingReport obj) {
        return obj.getMemo();
    }

    public String getGLCode(AccountingReport obj) {
        return obj.getGlAccountCode();
    }

    public String getAllocationMemo(AccountingReport obj) {
        return obj.getAllocationMemo();
    }

    public TaxCode getTaxCode(AccountingReport obj) {
        return obj.getTaxCode();
    }

    public Price getTaxAmount(AccountingReport obj) {
        return Price.ZERO_DOLLAR;
    }

    public String isCredit(AccountingReport obj) {
        if (obj instanceof AccountingSalesReport) {
            return "Y";
        }
        if (obj instanceof AccountingFinanceReport) {
            return "N";
        }
        return "N";
    }

    @Override
    protected Class getBusinessObjectClass() {
        return AccountingReport.class;
    }

    @Override
    public char getQuoteChar() {
        return '\u0000';
    }

    @Override
    public void doBeforeWrittingMappings(Writer writer) throws IOException {
        writer.write("{}\r\n");
    }
}

